/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.fabric.service;

import java.util.UUID;
import me.moros.gaia.common.command.CommandPermissions;
import me.moros.gaia.common.locale.Message;
import me.moros.gaia.common.service.AbstractSelectionService;
import me.moros.math.Vector3i;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.permission.PermissionChecker;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;

public final class GaiaSelectionService
extends AbstractSelectionService {
    public GaiaSelectionService() {
        AttackBlockCallback.EVENT.register(this::onLeftClickBlock);
        UseBlockCallback.EVENT.register(this::onRightClickBlock);
        ServerPlayConnectionEvents.DISCONNECT.register(this::onPlayerDisconnect);
    }

    private boolean canInteract(class_1657 player, class_1937 world, class_1268 hand) {
        if (hand == class_1268.field_5810 || world.field_9236) {
            return false;
        }
        if (!player.method_5998(class_1268.field_5808).method_31574(class_1802.field_8406)) {
            return false;
        }
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            if (sp.field_13974.method_14257() != class_1934.field_9219) {
                return sp.get(PermissionChecker.POINTER).map(c -> c.test(CommandPermissions.CREATE.toString())).orElse(false);
            }
        }
        return false;
    }

    private class_1269 onLeftClickBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 blockPos, class_2350 direction) {
        if (this.canInteract(player, world, hand)) {
            UUID uuid = player.method_5667();
            class_2960 level = world.method_27983().method_29177();
            Vector3i pos = Vector3i.of(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            this.registerClick(uuid, (Key)level, pos);
            Message.SELECTION_FIRST.send((Audience)((class_3222)player), pos.toString());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1269 onRightClickBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (this.canInteract(player, world, hand)) {
            UUID uuid = player.method_5667();
            class_2960 level = world.method_27983().method_29177();
            class_2338 blockPos = blockHitResult.method_17777();
            Vector3i pos = Vector3i.of(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            this.registerInteraction(uuid, (Key)level, pos);
            Message.SELECTION_SECOND.send((Audience)((class_3222)player), pos.toString());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void onPlayerDisconnect(class_3244 handler, MinecraftServer server) {
        this.invalidate(handler.method_32311().method_5667());
    }
}

