/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker;

import java.util.function.Consumer;
import java.util.function.Function;
import me.moros.tasker.AbstractTimerWheel;
import me.moros.tasker.Expiring;
import me.moros.tasker.TaskList;

final class HierarchicalTimerWheel
extends AbstractTimerWheel {
    private final int[] BUCKETS = new int[]{60, 40, 30, 8, 3};
    private final int[] SPANS = new int[]{60, 2400, 72000, 576000, 1728000, 1728000};
    private final TaskList pending;
    private final TaskList[][] wheel;
    private final int[] index;
    private final int length = this.BUCKETS.length;

    HierarchicalTimerWheel() {
        this.index = new int[this.length];
        this.pending = new TaskList.PendingTaskList();
        this.wheel = new TaskList[this.length][];
        for (int i = 0; i < this.length; ++i) {
            int innerLength = this.BUCKETS[i];
            this.wheel[i] = new TaskList[innerLength];
            for (int j = 0; j < innerLength; ++j) {
                this.wheel[i][j] = new TaskList();
            }
        }
    }

    @Override
    protected void advanceSync() {
        this.incrementTick();
        for (int i = 0; i < this.length; ++i) {
            boolean cascade = this.increment(i);
            this.expire(this.wheel[i][this.index[i]], cascade && i > 0);
            if (!cascade) break;
        }
        this.expire(this.pending);
    }

    @Override
    protected void shutdownSync(boolean run) {
        Consumer<Expiring> action = run ? Runnable::run : Function.identity()::apply;
        this.pending.clear(action);
        for (int i = 0; i < this.length; ++i) {
            for (TaskList tasks : this.wheel[i]) {
                tasks.clear(action);
            }
        }
    }

    private void expire(TaskList tasks, boolean cascadeReschedule) {
        Expiring node = tasks.first();
        while (node != null) {
            Expiring next = node.next();
            if (node.expiringTick <= this.currentTick()) {
                node.unlink();
                node.run();
                int repeat = node.repeat();
                if (repeat > 0) {
                    this.reschedule(node, repeat);
                }
            } else if (cascadeReschedule) {
                this.reschedule(node, node.expiringTick - this.currentTick());
            } else {
                return;
            }
            node = next;
        }
    }

    @Override
    protected TaskList findBucket(int ticks) {
        if (ticks <= 0) {
            return this.pending;
        }
        for (int i = 0; i < this.length; ++i) {
            int tickCapacity = this.SPANS[i + 1];
            if (ticks > tickCapacity) continue;
            return this.offset(i, ticks);
        }
        return this.offset(this.length - 1, Math.min(ticks, this.SPANS[this.length]));
    }

    private TaskList offset(int idx, int ticks) {
        int innerIndex = (this.index[idx] + ticks % this.SPANS[idx]) % this.BUCKETS[idx];
        return this.wheel[idx][innerIndex];
    }

    private boolean increment(int idx) {
        int n = idx;
        this.index[n] = this.index[n] + 1;
        if (this.index[n] >= this.BUCKETS[idx]) {
            this.index[idx] = 0;
            return true;
        }
        return false;
    }
}

