/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker.executor;

import java.util.Objects;
import me.moros.tasker.executor.AsyncExecutor;
import me.moros.tasker.executor.CompositeHolder;
import me.moros.tasker.executor.SimpleAsyncExecutor;
import me.moros.tasker.executor.SyncExecutor;

public interface CompositeExecutor {
    public SyncExecutor sync();

    public AsyncExecutor async();

    default public void shutdown() {
        this.sync().shutdown();
        this.async().shutdown();
    }

    public static CompositeExecutor of(SyncExecutor sync) {
        return CompositeExecutor.of(sync, new SimpleAsyncExecutor());
    }

    public static CompositeExecutor of(SyncExecutor sync, AsyncExecutor async) {
        Objects.requireNonNull(sync);
        Objects.requireNonNull(async);
        return new CompositeHolder(sync, async);
    }
}

