/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke;

import com.mojang.logging.LogUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.knifick.badjoke.init.ModBlocks;
import net.knifick.badjoke.init.ModCreativeTabs;
import net.knifick.badjoke.init.ModEntities;
import net.knifick.badjoke.init.ModItems;
import net.knifick.badjoke.init.ModParticleTypes;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="joke")
public class BadJokeMod {
    public static final String MODID = "joke";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setValue((Integer)work.getValue() - 1);
            if ((Integer)work.getValue() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getKey()).run());
        workQueue.removeAll(actions);
    }

    public static void performCommandAsServerSync(MinecraftServer server, String rawCommand, boolean silent) {
        String cmd = BadJokeMod.stripSlash(rawCommand);
        CommandSourceStack source = server.createCommandSourceStack();
        if (silent) {
            source = source.withSuppressedOutput();
        }
        server.getCommands().performPrefixedCommand(source, cmd);
    }

    public static void performCommandAsPlayerSync(ServerPlayer player, String rawCommand, boolean silent) {
        String cmd = BadJokeMod.stripSlash(rawCommand);
        MinecraftServer server = player.server;
        CommandSourceStack source = player.createCommandSourceStack().withPermission(4);
        if (silent) {
            source = source.withSuppressedOutput();
        }
        server.getCommands().performPrefixedCommand(source, cmd);
    }

    private static String stripSlash(String s) {
        return s != null && s.startsWith("/") ? s.substring(1) : s;
    }

    public BadJokeMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::registerNetworking);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSounds.REGISTRY.register(modEventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        ModParticleTypes.REGISTRY.register(modEventBus);
        ModEntities.REGISTRY.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        BadJokeModVariables.ATTACHMENT_TYPES.register(modEventBus);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

