/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.block;

import net.knifick.badjoke.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class SulfurBombBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final float EXPLOSION_POWER = 200.5f;
    private static final int MAGMA_RADIUS = 100;
    private static final float MAGMA_CHANCE = 0.8f;
    private static final float FIRE_ABOVE_CHANCE = 0.35f;
    private static final int SHOCKWAVE_POINTS = 360;
    private static final double SHOCKWAVE_RADIUS = 24.0;
    private static final int FLASH_PARTICLES = 900;
    private static final int CORE_FLAME_PARTICLES = 640;
    private static final int MUSHROOM_STEM_STEPS = 24;
    private static final int MUSHROOM_CAP_RINGS = 12;
    private static final int MUSHROOM_RING_POINTS = 240;
    private static final int LONG_SMOKE_PUFFS = 600;
    private static final int FALL_OUT_PARTICLES = 800;
    private static final double FALLOUT_RADIUS = 44.0;

    public SulfurBombBlock() {
        super(BlockBehaviour.Properties.of().strength(1.0f).noOcclusion().isRedstoneConductor((s, l, p) -> false).isSuffocating((s, l, p) -> false).isViewBlocking((s, l, p) -> false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack held = player.getItemInHand(hand);
        if (!held.is(Items.FLINT_AND_STEEL)) {
            return ItemInteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            double cx = (double)pos.getX() + 0.5;
            double cy = (double)pos.getY() + 0.5;
            double cz = (double)pos.getZ() + 0.5;
            ServerLevel server = (ServerLevel)level;
            RandomSource r = level.getRandom();
            level.explode(null, cx, cy, cz, 200.5f, Level.ExplosionInteraction.BLOCK);
            level.playSound(null, pos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 6.0f, 0.8f + r.nextFloat() * 0.4f);
            level.playSound(null, pos, (SoundEvent)ModSounds.BOMB.get(), SoundSource.BLOCKS, 600.0f, 1.0f);
            level.getEntities(null, new AABB(pos).inflate(30.0)).forEach(entity -> {
                double dist = entity.distanceToSqr(cx, cy, cz);
                double dmg = Math.max(0.0, 80.0 - dist * 0.5);
                entity.hurt(level.damageSources().explosion(null), (float)dmg);
            });
            this.emitFlash(server, cx, cy, cz, r);
            this.emitCoreFlames(server, cx, cy, cz);
            this.emitShockwaveRing(server, cx, cy + 0.2, cz, 24.0, 360);
            this.emitMushroomColumn(server, cx, cy, cz, r);
            this.emitMushroomCap(server, cx, cy, cz, r);
            this.emitLingeringSmoke(server, cx, cy, cz, r);
            this.emitFallout(server, cx, cy, cz, r);
            this.emitSparks(server, cx, cy, cz, r);
            this.transformNeighborhood(server, pos, r);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    held.hurtAndBreak(1, serverLevel, serverPlayer, item -> serverLevel.playSound(null, serverPlayer.blockPosition(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f));
                }
            }
            level.removeBlock(pos, false);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void emitFlash(ServerLevel s, double x, double y, double z, RandomSource r) {
        Vector3f white = new Vector3f(1.0f, 0.98f, 0.9f);
        Vector3f yellow = new Vector3f(1.0f, 0.85f, 0.2f);
        Vector3f orange = new Vector3f(1.0f, 0.55f, 0.1f);
        s.sendParticles((ParticleOptions)new DustColorTransitionOptions(white, yellow, 2.5f), x, y + 0.4, z, 900, 1.8, 1.2, 1.8, 0.02);
        s.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y + 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        s.sendParticles((ParticleOptions)new DustColorTransitionOptions(yellow, orange, 2.0f), x, y + 0.4, z, 220, 1.6, 1.0, 1.6, 0.01);
    }

    private void emitCoreFlames(ServerLevel s, double x, double y, double z) {
        s.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y + 0.3, z, 640, 2.2, 1.2, 2.2, 0.02);
        s.sendParticles((ParticleOptions)ParticleTypes.LAVA, x, y + 0.2, z, 160, 1.0, 0.6, 1.0, 0.15);
        s.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y + 0.4, z, 180, 1.4, 1.0, 1.4, 0.01);
        s.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y + 0.5, z, 120, 1.2, 0.8, 1.2, 0.01);
    }

    private void emitShockwaveRing(ServerLevel s, double x, double y, double z, double radius, int points) {
        for (int i = 0; i < points; ++i) {
            double t = Math.PI * 2 * (double)i / (double)points;
            double rx = x + radius * Math.cos(t);
            double rz = z + radius * Math.sin(t);
            s.sendParticles((ParticleOptions)ParticleTypes.CLOUD, rx, y, rz, 4, 0.3, 0.0, 0.3, 0.02);
            s.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, rx, y + 0.1, rz, 1, 0.02, 0.02, 0.02, 0.0);
        }
        s.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, x, y + 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void emitMushroomColumn(ServerLevel s, double x, double y, double z, RandomSource r) {
        double stepY = 0.9;
        double baseR = 2.2;
        double rGrowth = 0.55;
        for (int i = 0; i < 24; ++i) {
            double ny = y + 0.6 + (double)i * stepY;
            double nr = baseR + (double)i * rGrowth;
            this.spawnRing(s, (ParticleOptions)ParticleTypes.LARGE_SMOKE, x, ny, z, nr, 240, 0.12, 0.1, 0.12, 0.0);
            this.spawnRing(s, (ParticleOptions)ParticleTypes.CLOUD, x, ny + 0.1, z, nr * 0.85, 240, 0.1, 0.08, 0.1, 0.0);
            Vector3f bottom = new Vector3f(0.25f, 0.18f, 0.15f);
            Vector3f top = new Vector3f(0.45f, 0.28f, 0.18f);
            s.sendParticles((ParticleOptions)new DustColorTransitionOptions(bottom, top, 1.3f), x, ny, z, 35, nr * 0.25, 0.15, nr * 0.25, 0.02);
        }
    }

    private void emitMushroomCap(ServerLevel s, double x, double y, double z, RandomSource r) {
        double capY = y + 0.6 + 21.6 + 1.4;
        double capR = 6.5;
        for (int ring = 0; ring < 12; ++ring) {
            double rr = capR + (double)ring * 0.9;
            this.spawnRing(s, (ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, x, capY + (double)ring * 0.25, z, rr, 240, 0.18, 0.05, 0.18, 0.0);
            this.spawnRing(s, (ParticleOptions)ParticleTypes.LARGE_SMOKE, x, capY + (double)ring * 0.22, z, rr * 0.92, 240, 0.14, 0.05, 0.14, 0.0);
        }
        s.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x, capY + 0.6, z, 180, 3.0, 0.8, 3.0, 0.02);
        s.sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, x, capY + 0.3, z, 90, 2.2, 0.6, 2.2, 0.01);
    }

    private void emitLingeringSmoke(ServerLevel s, double x, double y, double z, RandomSource r) {
        s.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, x, y + 0.6, z, 600, 3.0, 0.6, 3.0, 0.01);
        s.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y + 0.5, z, 300, 2.2, 0.4, 2.2, 0.01);
    }

    private void emitFallout(ServerLevel s, double x, double y, double z, RandomSource r) {
        Vector3f dark = new Vector3f(0.18f, 0.16f, 0.15f);
        Vector3f light = new Vector3f(0.45f, 0.42f, 0.36f);
        s.sendParticles((ParticleOptions)new DustColorTransitionOptions(light, dark, 1.0f), x, y + 6.0, z, 800, 44.0, 0.0, 44.0, 0.0);
        s.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.GRAY_CONCRETE_POWDER.defaultBlockState()), x, y + 8.0, z, 266, 44.0, 0.0, 44.0, 0.0);
        s.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.SAND.defaultBlockState()), x, y + 7.5, z, 200, 44.0, 0.0, 44.0, 0.0);
        s.sendParticles((ParticleOptions)ParticleTypes.ASH, x, y + 6.0, z, 400, 44.0, 0.0, 44.0, 0.0);
    }

    private void emitSparks(ServerLevel s, double x, double y, double z, RandomSource r) {
        s.sendParticles((ParticleOptions)ParticleTypes.CRIT, x, y + 0.2, z, 180, 3.0, 0.4, 3.0, 0.03);
        s.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y + 0.1, z, 140, 2.2, 0.3, 2.2, 0.01);
        s.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y + 0.2, z, 180, 2.5, 0.4, 2.5, 0.01);
    }

    private void transformNeighborhood(ServerLevel level, BlockPos pos, RandomSource r) {
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-100, -1, -100), (BlockPos)pos.offset(100, 1, 100)).forEach(bp -> {
            if (bp.distSqr((Vec3i)pos) <= 10000.0 && level.random.nextFloat() < 0.8f) {
                BlockState bs = level.getBlockState(bp);
                if (bs.isAir() || bs.getFluidState().isSource()) {
                    return;
                }
                level.setBlock(bp, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
                BlockPos up = bp.above();
                if (level.getBlockState(up).isAir() && level.random.nextFloat() < 0.35f) {
                    level.setBlock(up, Blocks.FIRE.defaultBlockState(), 11);
                }
            }
        });
    }

    private void spawnRing(ServerLevel s, ParticleOptions p, double x, double y, double z, double radius, int points, double offX, double offY, double offZ, double speed) {
        for (int i = 0; i < points; ++i) {
            double t = Math.PI * 2 * (double)i / (double)points;
            double rx = x + radius * Math.cos(t);
            double rz = z + radius * Math.sin(t);
            s.sendParticles(p, rx, y, rz, 2, offX, offY, offZ, speed);
        }
    }
}

