/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client;

import java.util.List;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;

@EventBusSubscriber
public class MusicRemover {
    private static boolean wasBegin = false;
    private static final List<Holder<SoundEvent>> CUSTOM_MUSIC = List.of(ModSounds.TRACK1, ModSounds.TRACK2, ModSounds.TRACK3, ModSounds.TRACK4, ModSounds.TRACK5, ModSounds.TRACK6, ModSounds.TRACK7, ModSounds.TRACK8, ModSounds.TRACK9, ModSounds.TRACK10, ModSounds.TRACK11, ModSounds.TRACK12);

    @SubscribeEvent
    private static void onPlaySound(PlaySoundEvent e) {
        SoundInstance snd = e.getSound();
        if (snd == null) {
            return;
        }
        if (snd.getSource() == SoundSource.MUSIC) {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player == null) {
                return;
            }
            boolean begin = BadJokeModVariables.MapVariables.get((LevelAccessor)player.level()).begin;
            ResourceLocation id = snd.getLocation();
            boolean isOur = "joke".equals(id.getNamespace());
            if (begin && !isOur) {
                e.setSound(null);
            }
        }
    }

    @SubscribeEvent
    private static void onClientTick(ClientTickEvent.Post e) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        boolean begin = BadJokeModVariables.MapVariables.get((LevelAccessor)mc.player.level()).begin;
        if (begin != wasBegin) {
            wasBegin = begin;
            mc.getMusicManager().stopPlaying();
            if (begin) {
                MusicRemover.playRandomCustomMusic(mc);
            }
        }
    }

    private static void playRandomCustomMusic(Minecraft mc) {
        if (CUSTOM_MUSIC.isEmpty()) {
            return;
        }
        Holder<SoundEvent> pick = CUSTOM_MUSIC.get(mc.level.random.nextInt(CUSTOM_MUSIC.size()));
        SimpleSoundInstance inst = SimpleSoundInstance.forMusic((SoundEvent)((SoundEvent)pick.value()));
        mc.getSoundManager().play((SoundInstance)inst);
    }
}

