/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.OptionalLong;
import net.minecraft.world.level.levelgen.WorldOptions;

public final class SmileSeedGate {
    private static final long SEED_JOKE = SmileSeedGate.normSeed("JOKE");
    private static final long SEED_joke = SmileSeedGate.normSeed("joke");
    private static final long SEED_joker = SmileSeedGate.normSeed("joker");
    private static final long SEED_JOKER = SmileSeedGate.normSeed("JOKER");

    private SmileSeedGate() {
    }

    private static long normSeed(String s) {
        OptionalLong opt = WorldOptions.parseSeed((String)s);
        if (opt.isPresent()) {
            return opt.getAsLong();
        }
        return SmileSeedGate.murmur64(s);
    }

    private static long murmur64(String s) {
        long k2;
        long k1;
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long h1 = 0L;
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        while (buf.remaining() >= 16) {
            k1 = buf.getLong();
            k2 = buf.getLong();
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27) * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h1 ^= (k2 *= -8663945395140668459L);
            h1 = Long.rotateLeft(h1, 31) * 5L + 944331445L;
        }
        k1 = 0L;
        k2 = 0L;
        switch (buf.remaining()) {
            case 15: {
                k2 ^= (long)(buf.get(14) & 0xFF) << 48;
                break;
            }
            case 14: {
                k2 ^= (long)(buf.get(13) & 0xFF) << 40;
                break;
            }
            case 13: {
                k2 ^= (long)(buf.get(12) & 0xFF) << 32;
                break;
            }
            case 12: {
                k2 ^= (long)(buf.get(11) & 0xFF) << 24;
                break;
            }
            case 11: {
                k2 ^= (long)(buf.get(10) & 0xFF) << 16;
                break;
            }
            case 10: {
                k2 ^= (long)(buf.get(9) & 0xFF) << 8;
                break;
            }
            case 9: {
                k2 ^= (long)(buf.get(8) & 0xFF);
                break;
            }
            case 8: {
                k1 ^= buf.getLong(0);
                break;
            }
            case 7: {
                k1 ^= (long)(buf.get(6) & 0xFF) << 48;
                break;
            }
            case 6: {
                k1 ^= (long)(buf.get(5) & 0xFF) << 40;
                break;
            }
            case 5: {
                k1 ^= (long)(buf.get(4) & 0xFF) << 32;
                break;
            }
            case 4: {
                k1 ^= (long)(buf.get(3) & 0xFF) << 24;
                break;
            }
            case 3: {
                k1 ^= (long)(buf.get(2) & 0xFF) << 16;
                break;
            }
            case 2: {
                k1 ^= (long)(buf.get(1) & 0xFF) << 8;
                break;
            }
            case 1: {
                k1 ^= (long)(buf.get(0) & 0xFF);
            }
        }
        if (buf.remaining() > 8) {
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h1 ^= (k2 *= -8663945395140668459L);
        }
        if (buf.remaining() > 0) {
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
        }
        h1 ^= (long)data.length;
        h1 ^= h1 >>> 33;
        h1 *= -49064778989728563L;
        h1 ^= h1 >>> 33;
        h1 *= -4265267296055464877L;
        h1 ^= h1 >>> 33;
        return h1;
    }

    public static boolean matches(long seed) {
        return seed == SEED_JOKE || seed == SEED_joke || seed == SEED_joker || seed == SEED_JOKER;
    }
}

