/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public final class WindowsAumid {
    private WindowsAumid() {
    }

    public static void ensureInstalled(String appId, String displayName, String icoResource) {
        if (!WindowsAumid.isWindows()) {
            return;
        }
        Objects.requireNonNull(appId);
        Objects.requireNonNull(displayName);
        try {
            Path dataDir = Paths.get(System.getProperty("user.home"), "AppData", "Local", "BadJoke");
            Files.createDirectories(dataDir, new FileAttribute[0]);
            Path icoPath = dataDir.resolve("discord.ico");
            try (InputStream in = WindowsAumid.class.getResourceAsStream(icoResource);){
                if (in == null) {
                    throw new IllegalStateException("ICO resource not found: " + icoResource);
                }
                Files.copy(in, icoPath, StandardCopyOption.REPLACE_EXISTING);
            }
            Path startMenu = Paths.get(System.getenv("APPDATA"), "Microsoft", "Windows", "Start Menu", "Programs");
            Files.createDirectories(startMenu, new FileAttribute[0]);
            Path lnkPath = startMenu.resolve(displayName + ".lnk");
            String javaHome = System.getProperty("java.home");
            Path javaw = Paths.get(javaHome, "bin", "javaw.exe");
            if (!Files.isRegularFile(javaw, new LinkOption[0])) {
                javaw = Paths.get(System.getenv("WINDIR"), "System32", "notepad.exe");
            }
            String ps = WindowsAumid.getPowerShellCreateShortcutScript(appId, lnkPath.toString(), javaw.toString(), icoPath.toString());
            Path ps1 = Files.createTempFile("register-aumid-", ".ps1", new FileAttribute[0]);
            Files.writeString(ps1, (CharSequence)ps, StandardCharsets.UTF_8, new OpenOption[0]);
            new ProcessBuilder("powershell", "-NoProfile", "-ExecutionPolicy", "Bypass", "-File", ps1.toString()).redirectErrorStream(true).start().waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static String getPowerShellCreateShortcutScript(String appId, String lnk, String target, String icon) {
        appId = appId.replace("'", "''");
        lnk = lnk.replace("'", "''");
        target = target.replace("'", "''");
        icon = icon.replace("'", "''");
        return "$ErrorActionPreference='Stop'\n$AppId='" + appId + "'\n$ShortcutPath='" + lnk + "'\n$TargetPath='" + target + "'\n$IconPath='" + icon + "'\nNew-Item -ItemType Directory -Force -Path (Split-Path -Parent $ShortcutPath) | Out-Null\n@\"\nusing System;\nusing System.Runtime.InteropServices;\nusing System.Text;\n\n[ComImport, Guid(\"00021401-0000-0000-C000-000000000046\")] class CShellLink {}\n\n[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid(\"000214F9-0000-0000-C000-000000000046\")]\ninterface IShellLinkW {\n  void GetPath([Out, MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszFile, int cch, IntPtr pfd, int fFlags);\n  void GetIDList(out IntPtr ppidl);\n  void SetIDList(IntPtr pidl);\n  void GetDescription([Out, MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszName, int cch);\n  void SetDescription([MarshalAs(UnmanagedType.LPWStr)] string pszName);\n  void GetWorkingDirectory([Out, MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszDir, int cch);\n  void SetWorkingDirectory([MarshalAs(UnmanagedType.LPWStr)] string pszDir);\n  void GetArguments([Out, MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszArgs, int cch);\n  void SetArguments([MarshalAs(UnmanagedType.LPWStr)] string pszArgs);\n  void GetHotkey(out short wHotkey);\n  void SetHotkey(short wHotkey);\n  void GetShowCmd(out int iShowCmd);\n  void SetShowCmd(int iShowCmd);\n  void GetIconLocation([Out, MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszIconPath, int cch, out int iIcon);\n  void SetIconLocation([MarshalAs(UnmanagedType.LPWStr)] string pszIconPath, int iIcon);\n  void SetRelativePath([MarshalAs(UnmanagedType.LPWStr)] string pszPathRel, int dwReserved);\n  void Resolve(IntPtr hwnd, int fFlags);\n  void SetPath([MarshalAs(UnmanagedType.LPWStr)] string pszFile);\n}\n\n[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid(\"0000010b-0000-0000-C000-000000000046\")]\ninterface IPersistFile {\n  void GetClassID(out Guid pClassID);\n  int IsDirty();\n  void Load([MarshalAs(UnmanagedType.LPWStr)] string pszFileName, int dwMode);\n  void Save([MarshalAs(UnmanagedType.LPWStr)] string pszFileName, bool fRemember);\n  void SaveCompleted([MarshalAs(UnmanagedType.LPWStr)] string pszFileName);\n  void GetCurFile([MarshalAs(UnmanagedType.LPWStr)] out string ppszFileName);\n}\n\n[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid(\"886D8EEB-8CF2-4446-8D02-CDBA1DBDCF99\")]\ninterface IPropertyStore {\n  void GetCount(out uint cProps);\n  void GetAt(uint iProp, out PROPERTYKEY pkey);\n  void GetValue(ref PROPERTYKEY key, out PROPVARIANT pv);\n  void SetValue(ref PROPERTYKEY key, ref PROPVARIANT pv);\n  void Commit();\n}\n\n[StructLayout(LayoutKind.Sequential, Pack=4)]\nstruct PROPERTYKEY { public Guid fmtid; public uint pid; }\n\n[StructLayout(LayoutKind.Sequential)]\nstruct PROPVARIANT {\n  public ushort vt; public ushort w1; public ushort w2; public ushort w3;\n  public IntPtr p; public uint u;\n}\n\nstatic class Native {\n  [DllImport(\"propsys.dll\", CharSet=CharSet.Unicode)]\n  public static extern int InitPropVariantFromString(string s, out PROPVARIANT pv);\n  [DllImport(\"ole32.dll\")] public static extern int PropVariantClear(ref PROPVARIANT pv);\n}\n\npublic static class ShellLinkHelper {\n  static readonly PROPERTYKEY PKEY_AppUserModel_ID = new PROPERTYKEY { fmtid = new Guid(\"9F4C2855-9F79-4B39-A8D0-E1D42DE1D5F3\"), pid = 5 };\n  public static void CreateShortcut(string shortcutPath, string target, string appId, string icon) {\n    var link = (IShellLinkW)new CShellLink();\n    link.SetPath(target);\n    if (!string.IsNullOrEmpty(icon)) link.SetIconLocation(icon, 0);\n    var ps = (IPropertyStore)link;\n    PROPVARIANT pv; Native.InitPropVariantFromString(appId, out pv);\n    ps.SetValue(ref PKEY_AppUserModel_ID, ref pv); ps.Commit();\n    Native.PropVariantClear(ref pv);\n    ((IPersistFile)link).Save(shortcutPath, true);\n  }\n}\n\"@ | Add-Type -Language CSharp\n\n[ShellLinkHelper]::CreateShortcut($ShortcutPath, $TargetPath, $AppId, $IconPath)\nWrite-Host \"Created $ShortcutPath with AUMID $AppId\"\n";
    }
}

