/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;

public final class WindowsToast {
    private WindowsToast() {
    }

    public static void notifyAsync(String appId, String title, String message, Path icon) {
        CompletableFuture.runAsync(() -> {
            try {
                WindowsToast.runPowershellToast(appId, title, message, icon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void runPowershellToast(String appId, String title, String message, Path icon) throws Exception {
        String iconArg = icon != null ? icon.toAbsolutePath().toString() : "";
        title = title.replace("'", "''");
        message = message.replace("'", "''");
        appId = appId.replace("'", "''");
        iconArg = iconArg.replace("'", "''");
        String script = "$ErrorActionPreference='Stop'\n$null=[Windows.UI.Notifications.ToastNotificationManager,Windows.UI.Notifications,ContentType=WindowsRuntime]\n$tpl=[Windows.UI.Notifications.ToastTemplateType]::ToastImageAndText02\n$xml=[Windows.UI.Notifications.ToastNotificationManager]::GetTemplateContent($tpl)\n$texts=$xml.GetElementsByTagName('text')\n$texts.Item(0).AppendChild($xml.CreateTextNode('" + title + "'))|Out-Null\n$texts.Item(1).AppendChild($xml.CreateTextNode('" + message + "'))|Out-Null\nif('" + iconArg + "' -ne ''){ $img=$xml.GetElementsByTagName('image').Item(0); $img.SetAttribute('src','" + iconArg + "') }\n$audio=$xml.CreateElement('audio'); $audio.SetAttribute('silent','true'); $xml.DocumentElement.AppendChild($audio)|Out-Null\n$toast=[Windows.UI.Notifications.ToastNotification]::new($xml)\n$notifier=[Windows.UI.Notifications.ToastNotificationManager]::CreateToastNotifier('" + appId + "')\n$notifier.Show($toast)\n";
        Path ps1 = Files.createTempFile("wintoastdemo-", ".ps1", new FileAttribute[0]);
        Files.writeString(ps1, (CharSequence)script, new OpenOption[0]);
        ps1.toFile().deleteOnExit();
        new ProcessBuilder("powershell", "-NoProfile", "-ExecutionPolicy", "Bypass", "-File", ps1.toString()).redirectErrorStream(true).start();
    }
}

