/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientRenderHandler {
    private static final ResourceLocation SPLASH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/custom/splash_texture.png");
    private static final float MAX_LIFETIME = 30.0f;
    private static final float INITIAL_SIZE = 0.5f;
    private static final float GROWTH_RATE = 0.3f;
    private static final List<Wave> waves = new CopyOnWriteArrayList<Wave>();

    public static void trigger(double x, double y, double z, double dx, double dz) {
        double modifier = 0.05;
        waves.add(new Wave(x, y, z, dx * modifier, dz * modifier));
    }

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        PoseStack pose = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 camPos = camera.getPosition();
        for (Wave wave : waves) {
            float gameTime = (float)Minecraft.getInstance().level.getGameTime() + event.getPartialTick().getGameTimeDeltaPartialTick(true);
            wave.age = gameTime - (float)wave.spawnTick;
            if (wave.age > 30.0f) {
                waves.remove(wave);
                continue;
            }
            ClientRenderHandler.renderWave(pose, camPos, wave);
        }
    }

    private static void renderWave(PoseStack poseStack, Vec3 cam, Wave wave) {
        float halfLife = 15.0f;
        float alpha = 1.0f - Math.abs(wave.age / halfLife - 1.0f);
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        float size = 0.5f + 0.3f * wave.age;
        poseStack.pushPose();
        poseStack.translate(-cam.x, -cam.y, -cam.z);
        double movedX = wave.x + wave.dx * (double)wave.age;
        double movedZ = wave.z + wave.dz * (double)wave.age;
        poseStack.translate(movedX, wave.y, movedZ);
        poseStack.scale(size, size, size);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SPLASH_TEXTURE);
        RenderSystem.applyModelViewMatrix();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f m = poseStack.last().pose();
        float s = 0.5f;
        buf.addVertex(m, -s, 0.0f, -s).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        buf.addVertex(m, s, 0.0f, -s).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        buf.addVertex(m, s, 0.0f, s).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        buf.addVertex(m, -s, 0.0f, s).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private static class Wave {
        final double x;
        final double y;
        final double z;
        final double dx;
        final double dz;
        float age;
        long spawnTick;

        Wave(double x, double y, double z, double dx, double dz) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dx = dx;
            this.dz = dz;
            this.spawnTick = Minecraft.getInstance().level.getGameTime();
        }
    }
}

