/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.effects;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.util.Mth;

public final class SmileChunkOverlay {
    private static final int[][] FACE8 = new int[][]{{0, -12882899, -12485329, 0, 0, -12485329, -12882899, 0}, {0, -5855835, -11037307, 0, 0, -11037307, -5855835, 0}, {0, -5526613, -9717081, 0, 0, -9717081, -4934476, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, -5492174, -5492174, 0, 0, -5492174, -5492174, 0}, {-6999245, -4476106, -4739533, -4574413, -4574413, -3818440, -3555533, -6999245}, {-987924, -7720141, -5134026, -6186700, -5857471, -5068226, -7720141, -987924}, {-1645597, -987924, -7720141, -7720141, -7720141, -7720141, -987924, -1645597}};
    private static final int[][] RANK8 = new int[][]{{-1, 0, 1, -1, -1, 2, 3, -1}, {-1, 4, 5, -1, -1, 6, 7, -1}, {-1, 8, 9, -1, -1, 10, 11, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-1, 12, 13, -1, -1, 14, 15, -1}, {16, 17, 18, 19, 20, 21, 22, 23}, {24, 25, 26, 27, 28, 29, 30, 31}, {32, 33, 34, 35, 36, 37, 38, 39}};
    private static final int TOTAL_PIXELS = 40;
    private static final int ALPHA = -872415232;

    private SmileChunkOverlay() {
    }

    public static void draw(GuiGraphics gg, StoringChunkProgressListener pl, int cx, int cy, int cellSize, int padding, float progress01) {
        int step = cellSize + padding;
        int l = pl.getDiameter();
        int i1 = l * step - padding;
        int left = cx - i1 / 2;
        int top = cy - i1 / 2;
        int drawN = Mth.clamp((int)((int)Math.floor(progress01 * 40.0f)), (int)0, (int)40);
        for (int gy = 0; gy < l; ++gy) {
            for (int gx = 0; gx < l; ++gx) {
                int color;
                int u = Mth.clamp((int)((int)Math.floor((double)gx * 8.0 / (double)l)), (int)0, (int)7);
                int v = Mth.clamp((int)((int)Math.floor((double)gy * 8.0 / (double)l)), (int)0, (int)7);
                int rank = RANK8[v][u];
                if (rank < 0 || rank >= drawN || (color = FACE8[v][u]) == 0) continue;
                color = color & 0xFFFFFF | 0xCC000000;
                int x1 = left + gx * step;
                int y1 = top + gy * step;
                gg.fill(x1, y1, x1 + cellSize, y1 + cellSize, color);
            }
        }
    }
}

