/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.knifick.badjoke.entity.VictimEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class VictimRenderer {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/entity/victim.png");

    @SubscribeEvent
    public static void onRenderStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 camPos = camera.getPosition();
        float partitialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        for (VictimEntity victim : mc.level.getEntitiesOfClass(VictimEntity.class, new AABB(camPos, camPos).inflate(500.0))) {
            VictimRenderer.render(victim, partitialTicks, poseStack);
        }
    }

    public static void render(VictimEntity entity, float partialTicks, PoseStack poseStack) {
        Vec3 cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        double x = Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
        poseStack.translate(x - cam.x, y - cam.y + 6.5, z - cam.z);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(10.0f, 16.0f, 10.0f);
        float shakeStrength = 0.05f;
        float time = ((float)entity.tickCount + partialTicks) * 10.0f;
        double shakeX = ((double)Mth.sin((float)(time * 0.1f + (float)entity.getId())) * 0.5 + Math.random() - 0.5) * (double)shakeStrength;
        double shakeY = ((double)Mth.cos((float)(time * 0.15f + (float)entity.getId())) * 0.5 + Math.random() - 0.5) * (double)shakeStrength;
        poseStack.translate(shakeX, shakeY, 0.0);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.disableCull();
        RenderSystem.applyModelViewMatrix();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = poseStack.last().pose();
        float size = 0.5f;
        buf.addVertex(matrix, -size, -size, 0.0f).setUv(0.0f, 1.0f);
        buf.addVertex(matrix, size, -size, 0.0f).setUv(1.0f, 1.0f);
        buf.addVertex(matrix, size, size, 0.0f).setUv(1.0f, 0.0f);
        buf.addVertex(matrix, -size, size, 0.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

