/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.screen;

import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.network.payloads.EventRatePayload;
import net.knifick.badjoke.network.payloads.SafeModePayload;
import net.knifick.badjoke.network.payloads.ScreamerModePayload;
import net.knifick.badjoke.network.payloads.ScreenFilterPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.LevelAccessor;

public class ConfigScreen
extends Screen {
    private boolean safeModeLocal;
    private Button safeModeBtn;
    private boolean screamerModeLocal;
    private Button screamerModeBtn;
    private boolean screenFilterLocal;
    private Button screenFilterBtn;
    private float eventRateLocal;
    private EditBox eventRateBox;

    public ConfigScreen(Component title) {
        super(title);
    }

    protected void init() {
        super.init();
        BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)Minecraft.getInstance().level);
        BadJokeModVariables.PlayerVariables vars_player = (BadJokeModVariables.PlayerVariables)Minecraft.getInstance().player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        this.safeModeLocal = vars.safe_mode;
        this.screamerModeLocal = vars.screamer_mode;
        this.screenFilterLocal = vars_player.screen_filter;
        this.eventRateLocal = vars.event_rate * 100.0f;
        this.safeModeBtn = Button.builder((Component)this.safeModeLabel(), b -> {
            this.safeModeLocal = !this.safeModeLocal;
            b.setMessage(this.safeModeLabel());
        }).bounds(this.width / 2 + 30, (int)((float)this.height * 0.135f), 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.safeModeBtn);
        this.screamerModeBtn = Button.builder((Component)this.screamerModeLabel(), b -> {
            this.screamerModeLocal = !this.screamerModeLocal;
            b.setMessage(this.screamerModeLabel());
        }).bounds(this.width / 2 + 30, (int)((float)this.height * 0.235f), 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.screamerModeBtn);
        this.eventRateBox = new EditBox(this.font, this.width / 2 + 30, (int)((float)this.height * 0.335f), 80, 20, (Component)Component.literal((String)"Event rate"));
        this.eventRateBox.setMaxLength(4);
        this.eventRateBox.setValue(Integer.toString(Math.round(this.eventRateLocal)));
        this.eventRateBox.setFilter(s -> s.isEmpty() || s.matches("\\d{1,4}"));
        this.eventRateBox.setResponder(text -> {
            float parsed = ConfigScreen.parseOrDefault(text, this.eventRateLocal);
            this.eventRateLocal = ConfigScreen.clamp(parsed, 0.0f, 1000.0f);
        });
        this.addRenderableWidget((GuiEventListener)this.eventRateBox);
        this.setFocused((GuiEventListener)this.eventRateBox);
        this.eventRateBox.setFocused(true);
        this.screenFilterBtn = Button.builder((Component)this.screenFilterLabel(), b -> {
            this.screenFilterLocal = !this.screenFilterLocal;
            b.setMessage(this.screenFilterLabel());
        }).bounds(this.width / 2 + 30, (int)((float)this.height * 0.435f), 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.screenFilterBtn);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"joke.configuration.done"), btn -> {
            this.onApplyClicked();
            this.minecraft.setScreen(null);
        }).bounds(this.width / 2 + 20, (int)((float)this.height * 0.9f), 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"joke.configuration.close"), btn -> this.minecraft.setScreen(null)).bounds(this.width / 2 - 100, (int)((float)this.height * 0.9f), 80, 20).build());
    }

    private Component safeModeLabel() {
        return Component.literal((String)(this.safeModeLocal ? "ON" : "OFF"));
    }

    private Component screamerModeLabel() {
        return Component.literal((String)(this.screamerModeLocal ? "ON" : "OFF"));
    }

    private Component screenFilterLabel() {
        return Component.literal((String)(this.screenFilterLocal ? "ON" : "OFF"));
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        super.render(g, mouseX, mouseY, partialTick);
        MutableComponent title = Component.translatable((String)"joke.configuration.title");
        g.drawString(this.font, (Component)title, this.width / 2 - this.font.width((FormattedText)title) / 2, (int)((float)this.height * 0.05f), 0xFFFFFF, true);
        MutableComponent labelSafe = Component.translatable((String)"joke.configuration.safeMode");
        g.drawString(this.font, (Component)labelSafe, this.width / 2 - 80 - this.font.width((FormattedText)labelSafe) / 2, (int)((float)this.height * 0.15f), 0xFFFFFF, true);
        MutableComponent labelScreamer = Component.translatable((String)"joke.configuration.screamerMode");
        g.drawString(this.font, (Component)labelScreamer, this.width / 2 - 80 - this.font.width((FormattedText)labelScreamer) / 2, (int)((float)this.height * 0.25f), 0xFFFFFF, true);
        MutableComponent labelEventRate = Component.translatable((String)"joke.configuration.eventRate");
        g.drawString(this.font, (Component)labelEventRate, this.width / 2 - 80 - this.font.width((FormattedText)labelEventRate) / 2, (int)((float)this.height * 0.35f), 0xFFFFFF, true);
        MutableComponent labelScreenFilter = Component.translatable((String)"joke.configuration.screenFilter");
        g.drawString(this.font, (Component)labelScreenFilter, this.width / 2 - 80 - this.font.width((FormattedText)labelScreenFilter) / 2, (int)((float)this.height * 0.45f), 0xFFFFFF, true);
    }

    private void onApplyClicked() {
        float value;
        this.eventRateLocal = value = ConfigScreen.clamp(ConfigScreen.parseOrDefault(this.eventRateBox.getValue(), this.eventRateLocal), 0.0f, 1000.0f);
        Connection connection = Minecraft.getInstance().getConnection().getConnection();
        connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new SafeModePayload(this.safeModeLocal)));
        connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ScreamerModePayload(this.screamerModeLocal)));
        connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new EventRatePayload(this.eventRateLocal / 100.0f)));
        connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ScreenFilterPayload(this.screenFilterLocal)));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static float clamp(float v, float lo, float hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static float parseOrDefault(String s, float def) {
        try {
            if (s == null || s.isEmpty()) {
                return def;
            }
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }
}

