/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.knifick.badjoke.client.ScreenHandler;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.payloads.DialogueBoxClosePayload;
import net.knifick.badjoke.scare.PhonePhrases;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class DialogueBoxOverlay {
    private static final ResourceLocation DIALOGUE_BOX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/screens/dialogue_box.png");
    private static boolean visible = false;
    private static float alpha = 0.0f;
    private static PhonePhrases componentText = PhonePhrases.Empty;
    private static String fullText = "";
    private static int visibleChars = 0;
    private static int tickDelay = 0;
    private static int endTickDelay = 0;
    private static final int CHAR_DELAY_TICKS = 2;
    private static final int TICKS_TO_CLOSE = 40;
    private static final List<CharData> charDataList = new ArrayList<CharData>();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        if (!visible) {
            return;
        }
        int screenWidth = event.getGuiGraphics().guiWidth();
        int screenHeight = event.getGuiGraphics().guiHeight();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        boolean isGlitch = componentText == PhonePhrases.glitch;
        RandomSource random = Minecraft.getInstance().player != null ? Minecraft.getInstance().player.level().random : RandomSource.create();
        float shakePower = isGlitch ? 3.0f : 0.0f;
        int offsetX = isGlitch ? random.nextInt((int)(-shakePower), (int)shakePower + 1) : 0;
        int offsetY = isGlitch ? random.nextInt((int)(-shakePower), (int)shakePower + 1) : 0;
        float alphaFlicker = isGlitch ? 0.8f + random.nextFloat() * 0.2f : alpha;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaFlicker);
        int boxWidth = 200;
        int boxHeight = 100;
        int boxX = screenWidth / 2 - boxWidth / 2 + offsetX;
        int boxY = (int)((double)(screenHeight - boxHeight) - (double)screenHeight * 0.1) + offsetY;
        GuiGraphics gfx = event.getGuiGraphics();
        gfx.blit(DIALOGUE_BOX_TEXTURE, boxX, boxY, 0.0f, 0.0f, boxWidth, boxHeight, boxWidth, boxHeight);
        if (isGlitch && random.nextInt(3) == 0) {
            int colorShift = random.nextInt(255);
            RenderSystem.setShaderColor((float)1.0f, (float)random.nextFloat(), (float)random.nextFloat(), (float)0.25f);
            gfx.blit(DIALOGUE_BOX_TEXTURE, boxX + random.nextInt(-2, 3), boxY + random.nextInt(-2, 3), 0.0f, 0.0f, boxWidth, boxHeight, boxWidth, boxHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaFlicker);
        }
        if (alpha >= 0.9f && visibleChars > 0) {
            if (Minecraft.getInstance().player == null) {
                return;
            }
            Font font = Minecraft.getInstance().font;
            int maxCharsPerLine = 25;
            int lineHeight = 11;
            int baseX = boxX + 28;
            int baseY = boxY + 30;
            int i = 0;
            for (int drawn = 0; drawn < visibleChars; ++drawn) {
                CharData cd = charDataList.get(i);
                int line = drawn / maxCharsPerLine;
                String prefix = charDataList.stream().limit(i).skip(line * maxCharsPerLine).map(d -> String.valueOf(d.c())).collect(Collectors.joining());
                int x = baseX + font.width(prefix);
                int y = baseY + line * lineHeight;
                int offsetCharX = cd.shake() || isGlitch ? random.nextInt(-1, 2) : 0;
                int offsetCharY = cd.shake() || isGlitch ? random.nextInt(-1, 2) : 0;
                int color = 0xFFFFFF;
                if (isGlitch && random.nextInt(5) == 0) {
                    color = random.nextInt(0xFFFFFF) | 0xFF000000;
                }
                gfx.drawString(font, (Component)Component.literal((String)String.valueOf(cd.c())), x + offsetCharX, y + offsetCharY, color, false);
                ++i;
            }
        }
        if (isGlitch && random.nextInt(8) == 0) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + random.nextFloat() * 0.3f));
            gfx.fill(0, 0, screenWidth, screenHeight, 0x55FFFFFF);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ScreenHandler.postRender();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        int needed;
        if (!visible || Minecraft.getInstance().isPaused()) {
            return;
        }
        if (alpha < 1.0f) {
            alpha += 0.1f;
        }
        if (alpha >= 0.9f && visibleChars < charDataList.size() && ++tickDelay >= (needed = DialogueBoxOverlay.charDataList.get((int)DialogueBoxOverlay.visibleChars).delayTicks)) {
            tickDelay = 0;
            if (Minecraft.getInstance().player != null) {
                if (visibleChars == 0 && componentText == PhonePhrases.glitch) {
                    Minecraft.getInstance().player.playSound((SoundEvent)ModSounds.GLITCH_JOKE.get());
                } else if (DialogueBoxOverlay.charDataList.get((int)DialogueBoxOverlay.visibleChars).voice) {
                    Minecraft.getInstance().player.playSound((SoundEvent)ModSounds.VOICE_SOUND.get());
                }
            }
            ++visibleChars;
        }
        if (visibleChars == charDataList.size() && ++endTickDelay >= 40 && Minecraft.getInstance().getConnection() != null) {
            Connection connection = Minecraft.getInstance().getConnection().getConnection();
            connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new DialogueBoxClosePayload(componentText)));
            DialogueBoxOverlay.toggle(componentText);
        }
    }

    public static void toggle(PhonePhrases phrases) {
        alpha = visible ? 1.0f : 0.0f;
        visible = !visible;
        visibleChars = 0;
        tickDelay = 0;
        endTickDelay = 0;
        if (visible) {
            componentText = phrases;
            fullText = componentText.getPhrase().getString();
            DialogueBoxOverlay.parseMarkup();
        }
    }

    private static void parseMarkup() {
        charDataList.clear();
        int currentDelay = 2;
        boolean currentShake = false;
        boolean voice = true;
        for (int i = 0; i < fullText.length(); ++i) {
            char ch = fullText.charAt(i);
            if (ch == '$' && i + 1 < fullText.length()) {
                char code = fullText.charAt(i + 1);
                if (Character.isDigit(code)) {
                    currentDelay = Character.getNumericValue(code);
                    ++i;
                    continue;
                }
                if (code == 'r') {
                    currentDelay = 2;
                    currentShake = false;
                    voice = true;
                    ++i;
                    continue;
                }
                if (code == 'b') {
                    currentShake = true;
                    ++i;
                    continue;
                }
                if (code == 'm') {
                    voice = false;
                    ++i;
                    continue;
                }
            }
            charDataList.add(new CharData(ch, currentDelay, currentShake, voice));
        }
    }

    private record CharData(char c, int delayTicks, boolean shake, boolean voice) {
    }
}

