/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.knifick.badjoke.client.ScreenHandler;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class EmptyRevealingOverlay {
    private static boolean visible = false;
    private static float alpha = 0.0f;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        if (!visible) {
            return;
        }
        int w = event.getGuiGraphics().guiWidth();
        int h = event.getGuiGraphics().guiHeight();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int color = (int)(alpha * 255.0f) << 24;
        event.getGuiGraphics().fill(0, 0, w, h, color);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        ScreenHandler.postRender();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        alpha = Math.min((float)vars.step_counter / 30.0f, 1.0f);
        visible = alpha > 0.01f;
    }
}

