/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.payloads.FakeVillagerPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class FakeVillagerOverlay {
    private static final ResourceLocation SCREAMER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/screens/smile.png");
    private static float alpha = 0.0f;
    public static int timer = 0;
    private static final int MAX_TIME = 80;
    public static boolean visible = false;
    private static SimpleSoundInstance gusSound;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderFrame(ScreenEvent.Render.Post event) {
        if (alpha <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        int w = window.getGuiScaledWidth();
        int h = window.getGuiScaledHeight();
        GuiGraphics gfx = event.getGuiGraphics();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gfx.blit(SCREAMER_TEXTURE, 0, 0, 0.0f, 0.0f, w, h, w, h);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (visible) {
            if (++timer >= 20) {
                alpha = (float)(timer - 20) / 60.0f;
            }
            if (timer == 15) {
                gusSound = SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.GUS.get()), (float)1.0f);
                mc.getSoundManager().play((SoundInstance)gusSound);
            }
            if (timer >= 80) {
                timer = 0;
                alpha = 0.0f;
                mc.setScreen(null);
                ClientPacketListener clientConnection = Minecraft.getInstance().getConnection();
                if (clientConnection != null) {
                    clientConnection.getConnection().send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new FakeVillagerPayload()));
                }
                visible = false;
            }
        } else {
            timer = 0;
            alpha = 0.0f;
            FakeVillagerOverlay.stopSound();
        }
    }

    private static void stopSound() {
        if (!visible && gusSound != null) {
            Minecraft.getInstance().getSoundManager().stop((SoundInstance)gusSound);
            gusSound = null;
        }
    }
}

