/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.knifick.badjoke.client.ScreenHandler;
import net.knifick.badjoke.init.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class JokeRunOverlay {
    private static final ResourceLocation RUN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/screens/run_sheet.png");
    private static final int FRAME_W = 83;
    private static final int FRAME_H = 154;
    private static final int FRAME_COUNT = 6;
    private static final int SHEET_W = 83;
    private static final int SHEET_H = 924;
    private static final int DURATION_TICKS = 100;
    private static final float SCALE_START = 0.01f;
    private static final float SCALE_END = 5.0f;
    private static boolean visible = false;
    private static int timer = 0;
    private static int frame = 0;
    private static int frameTickAccum = 0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        if (!visible) {
            return;
        }
        GuiGraphics gg = event.getGuiGraphics();
        int screenW = gg.guiWidth();
        int screenH = gg.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        float t = Math.min(1.0f, (float)timer / 100.0f);
        float eased = t * t * t * t * t * t * t * t * t * t * t * t * t * t * t;
        float scale = 0.01f + 4.99f * eased;
        PoseStack pose = gg.pose();
        pose.pushPose();
        pose.translate((float)screenW / 2.0f, (float)screenH / 2.0f, 0.0f);
        pose.scale(scale, scale, 1.0f);
        int drawX = -41;
        int drawY = -77;
        int v = frame * 154;
        gg.blit(RUN_TEXTURE, drawX, drawY, 0.0f, (float)v, 83, 154, 83, 924);
        pose.popPose();
        ScreenHandler.postRender();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        if (!visible) {
            return;
        }
        frame = (frame + 1) % 6;
        if (++timer >= 100) {
            visible = false;
            timer = 0;
            frame = 0;
            frameTickAccum = 0;
        }
        if (timer == 72) {
            Minecraft.getInstance().player.playSound((SoundEvent)ModSounds.GUDOK.get());
        }
    }

    public static void show() {
        visible = true;
        timer = 0;
        frame = 0;
        frameTickAccum = 0;
    }
}

