/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.knifick.badjoke.client.ScreenHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class SmileOverlay {
    private static final ResourceLocation SCREAMER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/screens/smile.png");
    private static boolean visible = false;
    private static int ticks = 0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        if (!visible) {
            return;
        }
        int w = event.getGuiGraphics().guiWidth();
        int h = event.getGuiGraphics().guiHeight();
        Level world = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (entity != null) {
            world = entity.level();
            x = entity.getX();
            y = entity.getY();
            z = entity.getZ();
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        event.getGuiGraphics().blit(SCREAMER_TEXTURE, 0, 0, 0.0f, 0.0f, w, h, w, h);
        ScreenHandler.postRender();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        if (visible) {
            if (ticks < 10) {
                ++ticks;
            } else {
                visible = false;
            }
        }
    }

    public static void show() {
        visible = true;
        ticks = 0;
    }
}

