/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity;

import java.util.ArrayDeque;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.scare.AmuletEntity;
import net.knifick.badjoke.util.RisingRingParticles;
import net.knifick.badjoke.util.TagsUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BallobikCorruptedEntity
extends Monster
implements GeoEntity,
AmuletEntity {
    public static final EntityDataAccessor<Boolean> WATCHED = SynchedEntityData.defineId(BallobikCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(BallobikCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_isTamed = SynchedEntityData.defineId(BallobikCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ArrayDeque<String> actionQueue = new ArrayDeque();
    private String currentAction = null;

    public void triggerAction(String name) {
        this.triggerAction(name, false);
    }

    public BallobikCorruptedEntity(EntityType<BallobikCorruptedEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WATCHED, (Object)false);
        builder.define(TEXTURE, (Object)"ballobik_corupt");
        builder.define(DATA_isTamed, (Object)false);
    }

    public void setWatched(boolean watched) {
        this.entityData.set(WATCHED, (Object)watched);
    }

    public boolean getWatched() {
        return (Boolean)this.entityData.get(WATCHED);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    public void triggerAction(String name, boolean interrupt) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (interrupt) {
            this.actionQueue.clear();
            this.currentAction = null;
        }
        this.actionQueue.addLast(name);
    }

    public boolean isActionPlaying() {
        return this.currentAction != null;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){
            private int windup;
            {
                this.windup = -1;
            }

            public boolean canUse() {
                return super.canUse() && BallobikCorruptedEntity.this.getWatched() && !TagsUtil.hasStunTag((Entity)this.mob);
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && BallobikCorruptedEntity.this.getWatched() && !TagsUtil.hasStunTag((Entity)this.mob);
            }

            public void stop() {
                super.stop();
                this.windup = -1;
            }

            protected void checkAndPerformAttack(LivingEntity target) {
                if (this.windup > 0) {
                    if (!this.mob.isWithinMeleeAttackRange(target) || !this.mob.getSensing().hasLineOfSight((Entity)target)) {
                        this.windup = -1;
                        return;
                    }
                    --this.windup;
                    if (this.windup == 0) {
                        if (this.mob.isWithinMeleeAttackRange(target) && this.mob.getSensing().hasLineOfSight((Entity)target)) {
                            this.mob.doHurtTarget((Entity)target);
                            this.resetAttackCooldown();
                        }
                        this.windup = -1;
                    }
                    return;
                }
                if (this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(target) && this.mob.getSensing().hasLineOfSight((Entity)target)) {
                    BallobikCorruptedEntity.this.triggerAction("attack");
                    this.mob.swing(InteractionHand.MAIN_HAND, true);
                    this.windup = 5;
                }
            }
        });
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.1f, 0.0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataisTamed", ((Boolean)this.entityData.get(DATA_isTamed)).booleanValue());
        compound.putBoolean("Watched", this.getWatched());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataisTamed")) {
            this.entityData.set(DATA_isTamed, (Object)compound.getBoolean("DataisTamed"));
        }
        if (compound.contains("Watched")) {
            this.entityData.set(WATCHED, (Object)compound.getBoolean("Watched"));
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.9);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }

    private PlayState basePredicate(AnimationState<BallobikCorruptedEntity> s) {
        if (TagsUtil.hasStunTag((Entity)this) || this.isActionPlaying()) {
            return PlayState.STOP;
        }
        if (this.isDeadOrDying()) {
            return s.setAndContinue(RawAnimation.begin().thenPlay("death"));
        }
        if (!this.onGround()) {
            return s.setAndContinue(RawAnimation.begin().thenLoop("flight"));
        }
        if (s.isMoving()) {
            return s.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return s.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    private PlayState actionsPredicate(AnimationState<BallobikCorruptedEntity> s) {
        AnimationController ctrl = s.getController();
        if (this.currentAction == null) {
            String next = this.actionQueue.pollFirst();
            if (next == null) {
                return PlayState.STOP;
            }
            this.currentAction = next;
            ctrl.setAnimation(RawAnimation.begin().thenPlay(this.currentAction));
            return PlayState.CONTINUE;
        }
        if (ctrl.hasAnimationFinished() && this.currentAction != null) {
            this.currentAction = null;
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "base", 0, this::basePredicate));
        data.add(new AnimationController((GeoAnimatable)this, "actions", 0, this::actionsPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void amulet() {
        TagsUtil.applyStunTag((Entity)this);
        this.triggerAction("amulet", true);
        this.setTexture("ballobik_corupt_amulet");
        this.playSound((SoundEvent)ModSounds.AMULET.get());
        this.playSound(SoundEvents.SHIELD_BLOCK);
        RisingRingParticles.startRisingRing((Entity)this, (ParticleOptions)ParticleTypes.END_ROD, 0.7, 240, 0.08);
        BadJokeMod.queueServerWork(40, () -> ((BallobikCorruptedEntity)this).discard());
    }
}

