/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity;

import java.util.Comparator;
import java.util.List;
import net.knifick.badjoke.entity.JokerCorruptedEntity;
import net.knifick.badjoke.entity.JokerEntity;
import net.knifick.badjoke.init.ModEntities;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.network.payloads.VillagerGUISenderPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class FakeVillagerEntity
extends Villager {
    public Player trades;

    public FakeVillagerEntity(EntityType<? extends Villager> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        Player player = this.getTradingPlayer();
        if (player != null && this.trades == null) {
            this.startTrading(player);
        } else if (player == null && this.trades != null) {
            this.stopTrading(this.trades);
        }
    }

    private void stopTrading(Player player) {
        this.trades = null;
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new VillagerGUISenderPayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void startTrading(Player player) {
        this.trades = player;
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new VillagerGUISenderPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void fire(ServerPlayer player) {
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        Object joker = vars.defineReputation().equals((Object)BadJokeModVariables.PlayerVariables.Reputation.BAD) ? new JokerCorruptedEntity((EntityType<JokerCorruptedEntity>)((EntityType)ModEntities.JOKER_CORRUPTED.get()), player.level()) : new JokerEntity((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.JOKER.get()), player.level());
        double detectionRadius = 30.0;
        AABB aabb = new AABB(player.blockPosition()).inflate(detectionRadius);
        List players = player.level().getEntitiesOfClass(FakeVillagerEntity.class, aabb);
        if (players.isEmpty()) {
            return;
        }
        FakeVillagerEntity nearestPlayer = players.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)player))).orElse(null);
        joker.setPos(nearestPlayer.position());
        joker.getLookControl().setLookAt((Entity)player);
        player.level().addFreshEntity((Entity)joker);
        nearestPlayer.discard();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ModEntities.FAKE_VILLAGER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> BadJokeModVariables.MapVariables.get((LevelAccessor)world.getLevel()).begin, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        return builder;
    }
}

