/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.scare.AmuletEntity;
import net.knifick.badjoke.util.RisingRingParticles;
import net.knifick.badjoke.util.TagsUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class JokerCorruptedEntity
extends Monster
implements GeoEntity,
AmuletEntity {
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(JokerCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(JokerCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_isTamed = SynchedEntityData.defineId(JokerCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private static final int MAX_CLONES = 5;
    private static final int BASE_DELAY_TICKS = 100;
    private static final int STEP_TICKS = 10;
    private static final int MIN_DELAY_TICKS = 10;
    private static final Random RNG = new Random();
    private long lastChatTick = 0L;
    @Nullable
    private UUID fixedTargetUuid;
    @Nullable
    private Player cachedTarget;
    private static Map<UUID, Integer> LIMITER = new HashMap<UUID, Integer>();
    private int generation = 0;
    private boolean hasCloned = false;
    private int timer = 0;
    private Player targeting;
    String prevAnim = "empty";

    public JokerCorruptedEntity(EntityType<JokerCorruptedEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"prapor");
        builder.define(DATA_isTamed, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FollowFixedOrNearestPlayerGoal(this, 1.0, 1.0));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.1f, 0.0);
    }

    protected void dropAllDeathLoot(ServerLevel serverLevel, DamageSource damageSource) {
        if (this.generation == 0) {
            super.dropAllDeathLoot(serverLevel, damageSource);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataisTamed", ((Boolean)this.entityData.get(DATA_isTamed)).booleanValue());
        compound.putInt("JokeGen", this.generation);
        compound.putBoolean("JokeHasCloned", this.hasCloned);
        if (this.fixedTargetUuid != null) {
            compound.putUUID("JokeTarget", this.fixedTargetUuid);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataisTamed")) {
            this.entityData.set(DATA_isTamed, (Object)compound.getBoolean("DataisTamed"));
        }
        this.generation = compound.getInt("JokeGen");
        this.hasCloned = compound.getBoolean("JokeHasCloned");
        this.fixedTargetUuid = compound.hasUUID("JokeTarget") ? compound.getUUID("JokeTarget") : null;
        this.cachedTarget = null;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public void die(DamageSource damageSource) {
        if (this.targeting != null) {
            UUID targetUUID = this.targeting.getUUID();
            Integer currentLimit = LIMITER.get(targetUUID);
            if (currentLimit != null && currentLimit > 0) {
                LIMITER.put(targetUUID, currentLimit - 1);
            } else {
                LIMITER.remove(targetUUID);
            }
        }
        super.die(damageSource);
    }

    public void baseTick() {
        super.baseTick();
        this.setCustomName((Component)Component.literal((String)"jOkE"));
        this.setCustomNameVisible(true);
        if (!this.level().isClientSide) {
            Player target = this.getOrFindTarget();
            if (target != null && target.isAlive()) {
                this.maybeChat();
            }
            if (target != null && LIMITER.get(target.getUUID()) == null) {
                LIMITER.put(target.getUUID(), 0);
            }
            if (target != null) {
                UUID targetUUID = target.getUUID();
                int currentLimit = LIMITER.getOrDefault(targetUUID, 0);
                this.targeting = target;
                if (currentLimit < 5) {
                    ++this.timer;
                    int delay = Math.max(10, 100 - this.generation * 10);
                    if (this.timer >= delay) {
                        this.timer = 0;
                        LIMITER.put(targetUUID, currentLimit + 1);
                        this.spawnClone();
                    }
                }
            }
        }
    }

    @Nullable
    private Player getOrFindTarget() {
        Player nearest;
        List players;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.fixedTargetUuid != null) {
            if (this.cachedTarget == null || !this.cachedTarget.isAlive() || !this.fixedTargetUuid.equals(this.cachedTarget.getUUID())) {
                this.cachedTarget = server.getServer().getPlayerList().getPlayer(this.fixedTargetUuid);
            }
            if (this.cachedTarget != null && this.cachedTarget.isAlive()) {
                return this.cachedTarget;
            }
        }
        if (!(players = server.getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(16.0))).isEmpty() && (nearest = (Player)players.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)this))).orElse(null)) != null) {
            this.fixedTargetUuid = nearest.getUUID();
            this.cachedTarget = nearest;
            return nearest;
        }
        return null;
    }

    private void maybeChat() {
        long interval = 60 + RNG.nextInt(60);
        if ((long)this.tickCount - this.lastChatTick > interval) {
            this.lastChatTick = this.tickCount;
            this.sendRandomJokeMessage();
        }
    }

    private void sendRandomJokeMessage() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String[] messages = new String[]{"Joke", "jOkE", "hehe joke", "JOKE!!!", "ha... joke", "why so serious?", "just a joke..."};
        String msg = messages[RNG.nextInt(messages.length)];
        String name = this.getCustomName() != null ? this.getCustomName().getString() : "jOkE";
        serverLevel.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)("<" + name + "> " + msg)), false);
    }

    private void spawnClone() {
        Player target;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        JokerCorruptedEntity clone = (JokerCorruptedEntity)this.getType().create((Level)server);
        if (clone == null) {
            return;
        }
        server.playSound(null, this.blockPosition(), SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        double dx = (RNG.nextDouble() - 0.5) * 0.6;
        double dz = (RNG.nextDouble() - 0.5) * 0.6;
        clone.moveTo(this.getX() + dx, this.getY(), this.getZ() + dz, this.getYRot(), this.getXRot());
        clone.setCustomName(this.getCustomName());
        clone.setCustomNameVisible(true);
        clone.fixedTargetUuid = this.fixedTargetUuid;
        clone.generation = this.generation + 1;
        Player player = target = this.cachedTarget != null ? this.cachedTarget : this.getOrFindTarget();
        if (target != null) {
            clone.setTarget((LivingEntity)target);
        }
        server.addFreshEntity((Entity)clone);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.9);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void amulet() {
        TagsUtil.applyStunTag((Entity)this);
        this.setAnimation("amulet");
        RisingRingParticles.startRisingRing((Entity)this, (ParticleOptions)ParticleTypes.END_ROD, 0.7, 240, 0.08);
        BadJokeMod.queueServerWork(40, () -> ((JokerCorruptedEntity)this).discard());
    }

    static class FollowFixedOrNearestPlayerGoal
    extends Goal {
        private final JokerCorruptedEntity joker;
        private final double speed;
        private final double stopDistance;

        public FollowFixedOrNearestPlayerGoal(JokerCorruptedEntity joker, double speed, double stopDistance) {
            this.joker = joker;
            this.speed = speed;
            this.stopDistance = stopDistance;
        }

        public boolean canUse() {
            Player p = (Player)this.joker.getTarget();
            return p != null && !TagsUtil.hasStunTag((Entity)this.joker);
        }

        public boolean canContinueToUse() {
            Player p = (Player)this.joker.getTarget();
            if (p == null) {
                return false;
            }
            double d2 = p.distanceToSqr((Entity)this.joker);
            return d2 > this.stopDistance * this.stopDistance && d2 < 256.0 && p.isAlive() && !TagsUtil.hasStunTag((Entity)this.joker);
        }

        public void tick() {
            Player p = (Player)this.joker.getTarget();
            if (p != null) {
                this.joker.getNavigation().moveTo((Entity)p, this.speed);
                if (p.position().distanceToSqr(this.joker.position()) < 2.0) {
                    this.joker.doHurtTarget((Entity)p);
                }
            }
        }
    }
}

