/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class JokerEntity
extends PathfinderMob {
    private static final int MAX_CLONES = 50;
    private static final int BASE_DELAY_TICKS = 100;
    private static final int STEP_TICKS = 10;
    private static final int MIN_DELAY_TICKS = 10;
    private static final Random RNG = new Random();
    private long lastChatTick = 0L;
    @Nullable
    private UUID fixedTargetUuid;
    @Nullable
    private Player cachedTarget;
    private static Map<UUID, Integer> LIMITER = new HashMap<UUID, Integer>();
    private int generation = 0;
    private boolean hasCloned = false;
    private int timer = 0;
    private Player targeting;

    public JokerEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new FollowFixedOrNearestPlayerGoal(this, 1.0, 1.5));
    }

    public void die(DamageSource damageSource) {
        if (this.targeting != null) {
            UUID targetUUID = this.targeting.getUUID();
            Integer currentLimit = LIMITER.get(targetUUID);
            if (currentLimit != null && currentLimit > 0) {
                LIMITER.put(targetUUID, currentLimit - 1);
            } else {
                LIMITER.remove(targetUUID);
            }
        }
        super.die(damageSource);
    }

    public void baseTick() {
        super.baseTick();
        this.setCustomName((Component)Component.literal((String)"jOkE"));
        this.setCustomNameVisible(true);
        if (!this.level().isClientSide) {
            Player target = this.getOrFindTarget();
            if (target != null && target.isAlive()) {
                this.maybeChat();
            }
            if (target != null && LIMITER.get(target.getUUID()) == null) {
                LIMITER.put(target.getUUID(), 0);
            }
            if (target != null) {
                UUID targetUUID = target.getUUID();
                int currentLimit = LIMITER.getOrDefault(targetUUID, 0);
                this.targeting = target;
                if (currentLimit < 50) {
                    ++this.timer;
                    int delay = Math.max(10, 100 - this.generation * 10);
                    if (this.timer >= delay) {
                        this.timer = 0;
                        LIMITER.put(targetUUID, currentLimit + 1);
                        this.spawnClone();
                    }
                }
            }
        }
    }

    @Nullable
    private Player getOrFindTarget() {
        Player nearest;
        List players;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.fixedTargetUuid != null) {
            if (this.cachedTarget == null || !this.cachedTarget.isAlive() || !this.fixedTargetUuid.equals(this.cachedTarget.getUUID())) {
                this.cachedTarget = server.getServer().getPlayerList().getPlayer(this.fixedTargetUuid);
            }
            if (this.cachedTarget != null && this.cachedTarget.isAlive()) {
                return this.cachedTarget;
            }
        }
        if (!(players = server.getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(16.0))).isEmpty() && (nearest = (Player)players.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)this))).orElse(null)) != null) {
            this.fixedTargetUuid = nearest.getUUID();
            this.cachedTarget = nearest;
            return nearest;
        }
        return null;
    }

    private void maybeChat() {
        long interval = 60 + RNG.nextInt(60);
        if ((long)this.tickCount - this.lastChatTick > interval) {
            this.lastChatTick = this.tickCount;
            this.sendRandomJokeMessage();
        }
    }

    private void sendRandomJokeMessage() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String[] messages = new String[]{"Joke", "jOkE", "hehe joke", "JOKE!!!", "ha... joke", "why so serious?", "just a joke..."};
        String msg = messages[RNG.nextInt(messages.length)];
        String name = this.getCustomName() != null ? this.getCustomName().getString() : "jOkE";
        serverLevel.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)("<" + name + "> " + msg)), false);
    }

    private void spawnClone() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        JokerEntity clone = (JokerEntity)this.getType().create((Level)server);
        if (clone == null) {
            return;
        }
        server.playSound(null, this.blockPosition(), SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        double dx = (RNG.nextDouble() - 0.5) * 0.6;
        double dz = (RNG.nextDouble() - 0.5) * 0.6;
        clone.moveTo(this.getX() + dx, this.getY(), this.getZ() + dz, this.getYRot(), this.getXRot());
        clone.setCustomName(this.getCustomName());
        clone.setCustomNameVisible(true);
        clone.fixedTargetUuid = this.fixedTargetUuid;
        server.addFreshEntity((Entity)clone);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.STEP_HEIGHT, 1.9).add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("JokeGen", this.generation);
        tag.putBoolean("JokeHasCloned", this.hasCloned);
        if (this.fixedTargetUuid != null) {
            tag.putUUID("JokeTarget", this.fixedTargetUuid);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.generation = tag.getInt("JokeGen");
        this.hasCloned = tag.getBoolean("JokeHasCloned");
        this.fixedTargetUuid = tag.hasUUID("JokeTarget") ? tag.getUUID("JokeTarget") : null;
        this.cachedTarget = null;
    }

    static class FollowFixedOrNearestPlayerGoal
    extends Goal {
        private final JokerEntity joker;
        private final double speed;
        private final double stopDistance;

        public FollowFixedOrNearestPlayerGoal(JokerEntity joker, double speed, double stopDistance) {
            this.joker = joker;
            this.speed = speed;
            this.stopDistance = stopDistance;
        }

        public boolean canUse() {
            Player p = this.joker.getOrFindTarget();
            return p != null;
        }

        public boolean canContinueToUse() {
            Player p = this.joker.getOrFindTarget();
            if (p == null) {
                return false;
            }
            double d2 = p.distanceToSqr((Entity)this.joker);
            return d2 > this.stopDistance * this.stopDistance && d2 < 256.0 && p.isAlive();
        }

        public void tick() {
            Player p = this.joker.getOrFindTarget();
            if (p != null) {
                this.joker.getNavigation().moveTo((Entity)p, this.speed);
            }
        }
    }
}

