/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity;

import java.util.Comparator;
import java.util.List;
import net.knifick.badjoke.scare.EventSystem;
import net.knifick.badjoke.scare.Events;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class KukoldJokerEntity
extends PathfinderMob {
    public KukoldJokerEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            EventSystem.runEvent(Events.ScreamerEvent, player);
            player.setHealth(1.0f);
            this.discard();
        }
        return super.hurt(source, amount);
    }

    public void tick() {
        super.tick();
        double detectionRadius = 100.0;
        AABB aabb = new AABB(this.blockPosition()).inflate(detectionRadius);
        List players = this.level().getEntitiesOfClass(ServerPlayer.class, aabb);
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer nearestPlayer = players.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)this))).orElse(null);
        if (nearestPlayer == null) {
            return;
        }
        double distance = this.distanceTo((Entity)nearestPlayer);
        if (distance <= 4.0) {
            EventSystem.runEvent(Events.ScreamerEvent, nearestPlayer);
            nearestPlayer.setHealth(1.0f);
            this.discard();
        }
        Vec3 targetPos = nearestPlayer.position();
        this.getLookControl().setLookAt(targetPos.x, targetPos.y + (double)nearestPlayer.getBbHeight() * 0.5, targetPos.z);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.9);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }
}

