/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity;

import java.util.ArrayDeque;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.init.ModEntities;
import net.knifick.badjoke.init.ModItems;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.scare.AmuletEntity;
import net.knifick.badjoke.util.TagsUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ScaryJokeCorruptedEntity
extends PathfinderMob
implements GeoEntity,
AmuletEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(ScaryJokeCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(ScaryJokeCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_isTamed = SynchedEntityData.defineId(ScaryJokeCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ACTION_NAME = SynchedEntityData.defineId(ScaryJokeCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> ACTION_VER = SynchedEntityData.defineId(ScaryJokeCorruptedEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ArrayDeque<String> actionQueue = new ArrayDeque();
    private String currentAction = null;
    private int clientSeenActionVersion = -1;
    private int serverActionVersion = 0;

    public ScaryJokeCorruptedEntity(EntityType<ScaryJokeCorruptedEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    public void triggerAction(String name) {
        this.triggerAction(name, false);
    }

    public void triggerAction(String name, boolean interrupt) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (this.level().isClientSide()) {
            if (interrupt) {
                this.actionQueue.clear();
                this.currentAction = null;
            }
            this.actionQueue.addLast(name);
            return;
        }
        this.serverActionVersion = interrupt ? ++this.serverActionVersion : ++this.serverActionVersion;
        this.entityData.set(ACTION_NAME, (Object)name);
        this.entityData.set(ACTION_VER, (Object)this.serverActionVersion);
    }

    public boolean isActionPlaying() {
        return this.currentAction != null;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        String name;
        int ver;
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide() && (key.equals(ACTION_VER) || key.equals(ACTION_NAME)) && (ver = ((Integer)this.entityData.get(ACTION_VER)).intValue()) != this.clientSeenActionVersion && (name = (String)this.entityData.get(ACTION_NAME)) != null && !name.isEmpty()) {
            this.actionQueue.addLast(name);
            this.clientSeenActionVersion = ver;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(TEXTURE, (Object)"prapor");
        builder.define(DATA_isTamed, (Object)false);
        builder.define(ACTION_NAME, (Object)"");
        builder.define(ACTION_VER, (Object)-1);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.getNavigation().getNodeEvaluator().setCanFloat(false);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, this, 2.0, false){

            public boolean canUse() {
                return super.canUse() && !TagsUtil.hasStunTag((Entity)this.mob);
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !TagsUtil.hasStunTag((Entity)this.mob);
            }

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() * 10.0f + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
    }

    public boolean doHurtTarget(Entity target) {
        Player player;
        ItemStack chest;
        boolean result = super.doHurtTarget(target);
        if (target instanceof Player && (chest = (player = (Player)target).getItemBySlot(EquipmentSlot.CHEST)).is((Item)ModItems.AMULET.get())) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, target.getX(), target.getY(), target.getZ(), 4.0f, Level.ExplosionInteraction.MOB);
        }
        this.playSound((SoundEvent)ModSounds.BOMB.get());
        this.playSound((SoundEvent)ModSounds.JOKER.get());
        this.discard();
        return result;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.1f, 0.0);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataisTamed", ((Boolean)this.entityData.get(DATA_isTamed)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataisTamed")) {
            this.entityData.set(DATA_isTamed, (Object)compound.getBoolean("DataisTamed"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        ScaryJokeCorruptedEntity entity = this;
        Level world = this.level();
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        Player nearestPlayer = this.level().getNearestPlayer((Entity)this, 64.0);
        if (nearestPlayer != null) {
            this.getLookControl().setLookAt((Entity)nearestPlayer, 180.0f, 180.0f);
        }
        if (this.getTarget() != null && this.tickCount % 100 == 0) {
            BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)this.level());
            if (!vars.screamer_mode) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.EPILEPTIC, SoundSource.HOSTILE, 9.375f, 0.3f);
            } else {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.EPILEPTIC_Q, SoundSource.HOSTILE, 9.375f, 0.3f);
            }
        }
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ModEntities.SCARE_JOKE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.9);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }

    private PlayState basePredicate(AnimationState<ScaryJokeCorruptedEntity> s) {
        if (TagsUtil.hasStunTag((Entity)this) || this.isActionPlaying()) {
            return PlayState.STOP;
        }
        if (this.isDeadOrDying()) {
            return s.setAndContinue(RawAnimation.begin().thenPlay("death"));
        }
        if (!this.onGround()) {
            return s.setAndContinue(RawAnimation.begin().thenLoop("flight"));
        }
        if (s.isMoving()) {
            return s.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return s.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    private PlayState actionsPredicate(AnimationState<ScaryJokeCorruptedEntity> s) {
        AnimationController ctrl = s.getController();
        if (this.currentAction == null) {
            String next = this.actionQueue.pollFirst();
            if (next == null) {
                return PlayState.STOP;
            }
            this.currentAction = next;
            ctrl.setAnimation(RawAnimation.begin().thenPlay(this.currentAction));
            return PlayState.CONTINUE;
        }
        if (ctrl.hasAnimationFinished()) {
            this.currentAction = null;
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "base", 0, this::basePredicate));
        data.add(new AnimationController((GeoAnimatable)this, "actions", 0, this::actionsPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void amulet() {
        TagsUtil.applyStunTag((Entity)this);
        this.triggerAction("amulet", true);
        this.playSound((SoundEvent)ModSounds.AMULET_JOKE.get());
        this.playSound(SoundEvents.SHIELD_BLOCK);
        BadJokeMod.queueServerWork(40, () -> {
            this.discard();
            Level patt0$temp = this.level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                this.playSound(SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX(), this.getY() + 2.0, this.getZ(), 1000, 1.5, 1.5, 1.5, 0.008);
            }
        });
    }
}

