/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity;

import java.util.List;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.scare.EventSystem;
import net.knifick.badjoke.scare.Events;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VictimEntity
extends Mob {
    public VictimEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void baseTick() {
        Player player;
        super.baseTick();
        this.noPhysics = true;
        this.setNoGravity(true);
        this.setInvulnerable(true);
        if (this.tickCount % 280 == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.BALLOBIK, SoundSource.HOSTILE, 9.375f, 1.0f);
        }
        if (!(this.getTarget() != null && this.getTarget().isAlive() || (player = this.level().getNearestPlayer((Entity)this, 64.0)) == null)) {
            this.setTarget((LivingEntity)player);
        }
        if (this.getTarget() != null) {
            LivingEntity livingEntity;
            Vec3 targetPos = this.getTarget().position();
            Vec3 currentPos = this.position();
            double distance = currentPos.distanceTo(targetPos);
            if (distance <= 2.0 && !this.level().isClientSide && (livingEntity = this.getTarget()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                EventSystem.runEvent(Events.VictimAttackEvent, serverPlayer);
                this.discard();
                return;
            }
            Vec3 direction = targetPos.subtract(currentPos).normalize().scale(0.35);
            this.setPos(this.getX() + direction.x, this.getY() + direction.y, this.getZ() + direction.z);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.9);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }
}

