/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.entity.model;

import net.knifick.badjoke.entity.BallobikCorruptedEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;

public class BallobikCorruptedModel
extends GeoModel<BallobikCorruptedEntity> {
    public ResourceLocation getAnimationResource(BallobikCorruptedEntity entity) {
        return ResourceLocation.parse((String)"joke:animations/ballobik_corupt.animation.json");
    }

    public ResourceLocation getModelResource(BallobikCorruptedEntity entity) {
        return ResourceLocation.parse((String)"joke:geo/ballobik_corupt.geo.json");
    }

    public ResourceLocation getTextureResource(BallobikCorruptedEntity entity) {
        return ResourceLocation.parse((String)("joke:textures/entity/" + entity.getTexture() + ".png"));
    }

    public void setCustomAnimations(BallobikCorruptedEntity animatable, long instanceId, AnimationState animationState) {
        LivingEntity e = (LivingEntity)animationState.getData(DataTickets.ENTITY);
        if (e == null) {
            return;
        }
        GeoBone tail = this.getAnimationProcessor().getBone("tail");
        GeoBone tail1 = this.getAnimationProcessor().getBone("tail1");
        GeoBone tail2 = this.getAnimationProcessor().getBone("tail2");
        float ageInTicks = (float)e.tickCount + animationState.getPartialTick();
        float motionY = (float)e.getDeltaMovement().y;
        float targetPitch = motionY * 1.3f;
        float maxUp = -0.1f;
        float maxDown = -0.6f;
        targetPitch = Mth.clamp((float)targetPitch, (float)maxDown, (float)maxUp);
        float smooth = 0.1f;
        if (tail != null) {
            tail.setRotX(tail.getRotX() + (targetPitch - tail.getRotX()) * smooth);
        }
        if (tail1 != null) {
            tail1.setRotX(tail1.getRotX() + (targetPitch - tail1.getRotX()) * smooth);
        }
        if (tail2 != null) {
            tail2.setRotX(tail2.getRotX() + (targetPitch - tail2.getRotX()) * smooth);
        }
        float baseAmp = 0.005f;
        float waveSpd = 0.1f;
        if (tail != null) {
            tail.setRotX(tail.getRotX() + (float)Math.sin(ageInTicks * waveSpd + 1.0f) * baseAmp);
        }
        if (tail1 != null) {
            tail1.setRotX(tail1.getRotX() + (float)Math.sin(ageInTicks * waveSpd + 1.5f) * baseAmp);
        }
        if (tail2 != null) {
            tail2.setRotX(tail2.getRotX() + (float)Math.sin(ageInTicks * waveSpd + 2.0f) * baseAmp);
        }
    }
}

