/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.event.clientToServer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.network.payloads.StepPayload;
import net.knifick.badjoke.scare.realise.VictimRealising;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber
public class StepEvent {
    private static final Map<UUID, Vec3> lastPositions = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Integer> idleTimers = new HashMap<UUID, Integer>();
    private static final ResourceLocation EMPTY_DIM = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"empty");
    private static final int IDLE_THRESHOLD = 40;

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.level().dimension().location().equals((Object)EMPTY_DIM)) {
            return;
        }
        UUID id = player.getUUID();
        float walkDelta = player.walkDist - player.walkDistO;
        boolean isWalking = walkDelta >= 0.1f && player.onGround();
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        if (isWalking) {
            int interval;
            boolean slow;
            boolean fast = walkDelta >= 0.15f;
            boolean bl = slow = walkDelta >= 0.1f && walkDelta < 0.15f;
            int n = fast ? 5 : (interval = slow ? 10 : -1);
            if (interval > 0 && player.tickCount % interval == 0) {
                Vec3 currentPos = player.position();
                Vec3 lastPos = lastPositions.getOrDefault(id, currentPos);
                Vec3 delta = currentPos.subtract(lastPos);
                lastPositions.put(id, currentPos);
                double dx = delta.x;
                double dz = delta.z;
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    for (ServerPlayer other : server.getPlayerList().getPlayers()) {
                        if (!other.level().dimension().location().equals((Object)EMPTY_DIM)) continue;
                        PacketDistributor.sendToPlayer((ServerPlayer)other, (CustomPacketPayload)new StepPayload(player.getX(), player.getY(), player.getZ(), dx, dz), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                ++vars.step_counter;
                vars.syncPlayerVariables((Entity)player);
                if (vars.step_counter >= 32) {
                    vars.step_counter = 0;
                    vars.syncPlayerVariables((Entity)player);
                    VictimRealising.teleport(player, (ResourceKey<Level>)Level.OVERWORLD, vars.oldPos);
                }
                idleTimers.put(id, 0);
                player.serverLevel().playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.EMPTY_FOOTSTEP, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            int idle = idleTimers.getOrDefault(id, 0) + 1;
            idleTimers.put(id, idle);
            if (idle > 40 && vars.step_counter > 0) {
                --vars.step_counter;
                vars.syncPlayerVariables((Entity)player);
            }
        }
    }
}

