/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.event.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.network.payloads.ConfigScreenPayload;
import net.knifick.badjoke.scare.EventSystem;
import net.knifick.badjoke.scare.Events;
import net.knifick.badjoke.scare.PhonePhrases;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class JokeCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"joke").then(Commands.literal((String)"reputation").executes(arguments -> {
            Player entity = (Player)((CommandSourceStack)arguments.getSource()).getEntity();
            if (entity == null) {
                return 0;
            }
            BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)entity.getData(BadJokeModVariables.PLAYER_VARIABLES);
            entity.sendSystemMessage((Component)Component.translatable((String)"reputation.message").append(JokeCommand.defineReputation(vars.reputation)));
            vars.syncPlayerVariables((Entity)entity);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"event").executes(arguments -> {
            ServerPlayer entity = (ServerPlayer)((CommandSourceStack)arguments.getSource()).getEntity();
            if (entity == null) {
                return 0;
            }
            EventSystem.randEvent(entity);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"event_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (Events events : Events.values()) {
                builder.suggest(events.name());
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            Events eventes;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
            String eventName = StringArgumentType.getString((CommandContext)ctx, (String)"event_name");
            try {
                eventes = Events.valueOf(eventName);
            }
            catch (IllegalArgumentException e) {
                player.sendSystemMessage((Component)Component.literal((String)("No such event: " + eventName)));
                return 0;
            }
            if (eventes != Events.CallEvent) {
                EventSystem.runEvent(eventes, player);
            } else {
                EventSystem.runEvent(eventes, player, PhonePhrases.Empty);
            }
            return 1;
        })).then(Commands.argument((String)"additional", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (PhonePhrases phrase : PhonePhrases.values()) {
                builder.suggest(phrase.name());
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            PhonePhrases phrase;
            Events eventes;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
            String eventName = StringArgumentType.getString((CommandContext)ctx, (String)"event_name");
            String additional = StringArgumentType.getString((CommandContext)ctx, (String)"additional");
            try {
                eventes = Events.valueOf(eventName);
            }
            catch (IllegalArgumentException e) {
                player.sendSystemMessage((Component)Component.literal((String)("No such event: " + eventName)));
                return 0;
            }
            try {
                phrase = PhonePhrases.valueOf(additional);
            }
            catch (IllegalArgumentException e) {
                player.sendSystemMessage((Component)Component.literal((String)("No such phrase: " + additional)));
                return 0;
            }
            EventSystem.runEvent(eventes, player, phrase);
            return 1;
        }))))).then(Commands.literal((String)"debug").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
            BadJokeModVariables.MapVariables map_vars = BadJokeModVariables.MapVariables.get((LevelAccessor)player.level());
            player.sendSystemMessage((Component)Component.literal((String)"[Debug Variables]").withStyle(ChatFormatting.GOLD));
            player.sendSystemMessage((Component)Component.literal((String)"Reputation: ").append(String.valueOf(vars.reputation)));
            player.sendSystemMessage((Component)Component.literal((String)"Phone Timer: ").append(String.valueOf(vars.phone_timer)));
            player.sendSystemMessage((Component)Component.literal((String)"Event Timer: ").append(String.valueOf(vars.event_timer)));
            player.sendSystemMessage((Component)Component.literal((String)"Phone Saver: ").append(String.valueOf(vars.phone_saver)));
            player.sendSystemMessage((Component)Component.literal((String)"Break Event: ").append(String.valueOf(vars.break_event)));
            player.sendSystemMessage((Component)Component.literal((String)"Phrase: ").append(vars.phrase.name()));
            player.sendSystemMessage((Component)Component.literal((String)"Cur Event: ").append(vars.cur_event.name()));
            player.sendSystemMessage((Component)Component.literal((String)"Is Calling: ").append(String.valueOf(vars.isCalling)));
            player.sendSystemMessage((Component)Component.literal((String)"Seen Phrases: ").append(vars.seen.toString()));
            player.sendSystemMessage((Component)Component.literal((String)"Steps: ").append(String.valueOf(vars.step_counter)));
            player.sendSystemMessage((Component)Component.literal((String)"OldPos: ").append(vars.oldPos.toString()));
            player.sendSystemMessage((Component)Component.literal((String)"[World Variables]").withStyle(ChatFormatting.GOLD));
            player.sendSystemMessage((Component)Component.literal((String)"Begin: ").append(String.valueOf(map_vars.begin)));
            return 1;
        }))).then(Commands.literal((String)"config").executes(ctx -> {
            PacketDistributor.sendToPlayer((ServerPlayer)((CommandSourceStack)ctx.getSource()).getPlayer(), (CustomPacketPayload)new ConfigScreenPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        })));
    }

    private static Component defineReputation(float reputation) {
        if (reputation >= 0.0f && reputation < 2.0f) {
            return Component.translatable((String)"reputation.normal").withStyle(ChatFormatting.YELLOW);
        }
        if (reputation >= 2.0f) {
            return Component.translatable((String)"reputation.good").withStyle(ChatFormatting.GREEN);
        }
        return Component.translatable((String)"reputation.bad").withStyle(ChatFormatting.DARK_RED);
    }
}

