/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.event.entity;

import java.util.Comparator;
import java.util.List;
import net.knifick.badjoke.entity.BallobikCorruptedEntity;
import net.knifick.badjoke.entity.BallobikEntity;
import net.knifick.badjoke.entity.ScaryJokeCorruptedEntity;
import net.knifick.badjoke.entity.ScaryJokeEntity;
import net.knifick.badjoke.scare.EventSystem;
import net.knifick.badjoke.scare.Events;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import software.bernie.geckolib.animatable.GeoEntity;

@EventBusSubscriber
public class LookAtEntityHandler {
    private static final double REACH_DISTANCE = 64.0;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        GeoEntity ballobik;
        PathfinderMob joker;
        Player player = event.getEntity();
        if (LookAtEntityHandler.isInCreativeOrSpectator(player)) {
            return;
        }
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVec = eyePos.add(player.getLookAngle().scale(64.0));
        AABB searchBox = new AABB(eyePos, lookVec);
        List entities = player.level().getEntities((Entity)player, searchBox, entity -> !entity.isSpectator() && entity.isPickable());
        Entity target = entities.stream().filter(e -> e.getBoundingBox().inflate((double)e.getPickRadius()).clip(eyePos, lookVec).isPresent()).min(Comparator.comparingDouble(e -> eyePos.distanceTo(e.getBoundingBox().inflate((double)e.getPickRadius()).clip(eyePos, lookVec).orElse(lookVec)))).orElse(null);
        if (target instanceof ScaryJokeEntity && (joker = (ScaryJokeEntity)target).getTarget() == null) {
            joker.setTarget((LivingEntity)player);
        }
        if (target instanceof ScaryJokeCorruptedEntity && (joker = (ScaryJokeCorruptedEntity)target).getTarget() == null) {
            joker.setTarget((LivingEntity)player);
        }
        if (target instanceof BallobikEntity) {
            ballobik = (BallobikEntity)target;
            if (!player.level().isClientSide) {
                EventSystem.runEvent(Events.ScreamerEvent, (ServerPlayer)player);
                ballobik.discard();
            }
        }
        if (target instanceof BallobikCorruptedEntity) {
            ballobik = (BallobikCorruptedEntity)target;
            if (!player.level().isClientSide) {
                ballobik.setWatched(true);
                ballobik.setTarget((LivingEntity)player);
            }
        }
    }

    private static boolean isInCreativeOrSpectator(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GameType mode = serverPlayer.gameMode.getGameModeForPlayer();
            return mode == GameType.SPECTATOR || mode == GameType.CREATIVE;
        }
        PlayerInfo info = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId());
        return info != null && (info.getGameMode() == GameType.SPECTATOR || info.getGameMode() == GameType.CREATIVE);
    }
}

