/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.event.spawn;

import net.knifick.badjoke.client.SmileSeedGate;
import net.knifick.badjoke.event.phone.PhoneGiver;
import net.knifick.badjoke.init.ModItems;
import net.knifick.badjoke.mixin.PrimaryLevelDataMut;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="joke")
public final class JokeSeedWorldHooks {
    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (!level.dimension().equals(ServerLevel.OVERWORLD)) {
            return;
        }
        MinecraftServer server = level.getServer();
        PrimaryLevelData worldData = (PrimaryLevelData)server.getWorldData();
        long seed = worldData.worldGenOptions().seed();
        if (!SmileSeedGate.matches(seed)) {
            return;
        }
        BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)level);
        if (!vars.begin) {
            vars.begin = true;
            vars.syncData((LevelAccessor)level);
        }
        long addDays = 1488L;
        long delta = addDays * 24000L;
        long newDayTime = level.getDayTime() + delta;
        level.setDayTime(newDayTime);
        LevelSettings old = ((PrimaryLevelDataMut)worldData).badjoke$getSettings();
        if (old.allowCommands()) {
            LevelSettings neu = new LevelSettings(old.levelName(), old.gameType(), old.hardcore(), old.difficulty(), false, old.gameRules(), old.getDataConfiguration(), old.getLifecycle());
            ((PrimaryLevelDataMut)worldData).badjoke$setSettings(neu);
            server.getPlayerList().getPlayers().forEach(p -> server.getPlayerList().sendPlayerPermissionLevel(p));
            try {
                server.saveEverything(false, false, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        ItemStack itemStack;
        boolean added;
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ServerLevel level = sp.serverLevel();
        long seed = level.getServer().getWorldData().worldGenOptions().seed();
        if (!SmileSeedGate.matches(seed)) {
            return;
        }
        if (!PhoneGiver.hasPhone((Player)sp) && !(added = sp.addItem(itemStack = new ItemStack((ItemLike)ModItems.PHONE.get())))) {
            ItemEntity itemEntity = new ItemEntity(sp.level(), sp.getX(), sp.getY(), sp.getZ(), itemStack);
            sp.level().addFreshEntity((Entity)itemEntity);
        }
    }
}

