/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.game;

import java.util.Objects;
import net.minecraft.world.phys.Vec2;

public abstract class Billboard<T extends Billboard<T>> {
    protected double x;
    protected double y;
    private final String key;
    private final int frames;
    private final double fps;
    private volatile String rtKey = null;
    private volatile int appearanceVersion = 0;
    private volatile boolean texDirty = false;
    private boolean solid = false;
    private double halfX = 0.3;
    private double halfY = 0.3;
    private boolean canInteract = false;
    private String prompt = "\u0412\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c";

    protected Billboard(String key, int frames, double fps) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Billboard key must not be null/empty");
        }
        if (frames < 1) {
            throw new IllegalArgumentException("frames must be >= 1");
        }
        if (fps < 0.0) {
            throw new IllegalArgumentException("fps must be >= 0");
        }
        this.key = key;
        this.frames = frames;
        this.fps = fps;
    }

    public final String key() {
        return this.key;
    }

    public final int frames() {
        return this.frames;
    }

    public final double fps() {
        return this.fps;
    }

    public String effKey() {
        return this.rtKey != null ? this.rtKey : this.key;
    }

    public int appearanceVersion() {
        return this.appearanceVersion;
    }

    public boolean isStatic() {
        return this.frames <= 1 || this.fps <= 0.0;
    }

    public synchronized T setTexture(String newKey) {
        if (!this.isStatic()) {
            throw new IllegalStateException("Dynamic texture is allowed only for static billboards (frames==1 || fps==0).");
        }
        if (newKey == null || newKey.isEmpty()) {
            throw new IllegalArgumentException("newKey must not be null/empty");
        }
        if (!Objects.equals(this.rtKey, newKey)) {
            this.rtKey = newKey;
            ++this.appearanceVersion;
            this.texDirty = true;
        }
        return (T)this;
    }

    public synchronized T resetTexture() {
        if (this.rtKey != null) {
            this.rtKey = null;
            ++this.appearanceVersion;
            this.texDirty = true;
        }
        return (T)this;
    }

    public boolean consumeTextureChangeFlag() {
        if (this.texDirty) {
            this.texDirty = false;
            return true;
        }
        return false;
    }

    public boolean isTextureDirty() {
        return this.texDirty;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final Vec2 getPos() {
        return new Vec2((float)this.x, (float)this.y);
    }

    public final boolean isSolid() {
        return this.solid;
    }

    public final double boxHalfX() {
        return this.halfX;
    }

    public final double boxHalfY() {
        return this.halfY;
    }

    public final boolean canInteract() {
        return this.canInteract;
    }

    public String prompt() {
        return this.prompt;
    }

    public T solid(boolean v) {
        this.solid = v;
        return (T)this;
    }

    public T box(double halfX, double halfY) {
        this.halfX = halfX;
        this.halfY = halfY;
        return (T)this;
    }

    public T interactable(boolean v) {
        this.canInteract = v;
        return (T)this;
    }

    public T prompt(String p) {
        this.prompt = p;
        return (T)this;
    }

    public void onInteract(InteractionCtx ctx) {
    }

    public void update(double dt, double px, double py) {
    }

    public Billboard at(Vec2 pos) {
        Billboard b = this.copy();
        b.x = pos.x;
        b.y = pos.y;
        this.copyBasePropsTo(b);
        return b;
    }

    protected abstract Billboard copy();

    protected final void copyBasePropsTo(Billboard b) {
        b.solid = this.solid;
        b.halfX = this.halfX;
        b.halfY = this.halfY;
        b.canInteract = this.canInteract;
        b.prompt = this.prompt;
        b.rtKey = this.rtKey;
        b.appearanceVersion = this.appearanceVersion;
        b.texDirty = false;
    }

    public static Billboard ofStatic(String key) {
        return new SimpleBillboard(key, 1, 0.0);
    }

    public static Billboard ofAnimated(String key, int frames, double fps) {
        return new SimpleBillboard(key, frames, fps);
    }

    private static final class SimpleBillboard
    extends Billboard {
        SimpleBillboard(String key, int frames, double fps) {
            super(key, frames, fps);
        }

        @Override
        protected Billboard copy() {
            return new SimpleBillboard(this.key(), this.frames(), this.fps());
        }
    }

    public static interface InteractionCtx {
        public double playerX();

        public double playerY();

        public void say(String var1);
    }
}

