/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.game;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.game.Billboard;
import net.knifick.badjoke.game.EnemyTag;
import net.knifick.badjoke.game.SoundEngine;
import net.knifick.badjoke.game.WorldMap;
import net.knifick.badjoke.network.payloads.GameClosePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.phys.Vec2;
import org.lwjgl.glfw.GLFW;

public final class RaycasterApp {
    private static final String MODID = "joke";
    private static volatile boolean open = false;
    public static final SoundEngine SND = new SoundEngine("joke");
    public static double STAMINA_DRAIN = 0.15;
    public static boolean inWardrobe = false;
    public static boolean isBoots = false;
    public static Vec2 oldPos = Vec2.ZERO;
    private static double px;
    private static double py;
    public static double pitchPx;
    private static double dirX;
    private static double dirY;
    private static double planeX;
    private static double planeY;
    public static final InteractionHub INTERACT;
    private static GameWindow currentWindow;
    public static volatile Nav NAV;

    public static void launch() {
        RaycasterApp.launchWithOnExit(null);
    }

    public static void launchWithOnExit(Runnable onExit) {
        if (open) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Headless: no window");
            return;
        }
        open = true;
        STAMINA_DRAIN = 0.15;
        inWardrobe = false;
        isBoots = false;
        EventQueue.invokeLater(() -> {
            currentWindow = new GameWindow(onExit);
            currentWindow.start();
        });
    }

    public static void closeWindow() {
        EventQueue.invokeLater(() -> {
            if (currentWindow != null) {
                currentWindow.dispatchEvent(new WindowEvent(currentWindow, 201));
            }
        });
    }

    public static void setPlayerPos(Vec2 pos) {
        px = pos.x;
        py = pos.y;
    }

    public static Vec2 getPlayerPos() {
        return new Vec2((float)px, (float)py);
    }

    public static void rotate(double ang) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        double ndx = c * dirX + -s * dirY;
        double ndy = s * dirX + c * dirY;
        double npx = c * planeX + -s * planeY;
        double npy = s * planeX + c * planeY;
        dirX = ndx;
        dirY = ndy;
        planeX = npx;
        planeY = npy;
    }

    public static void rotateTo(double ang) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        dirX = -c;
        dirY = -s;
        double len = Math.hypot(planeX, planeY);
        if (len < 1.0E-9) {
            len = 0.66;
        }
        planeX = dirY * len;
        planeY = -dirX * len;
    }

    public static void onPlayerCaught(double ex, double ey) {
        try {
            SND.playAt("caught", ex, ey, 1.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Minecraft.getInstance().getConnection() != null) {
            BadJokeMod.LOGGER.info("[client] sending GameClosePayload(1)");
            Connection connection = Minecraft.getInstance().getConnection().getConnection();
            connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new GameClosePayload(1)));
        }
        RaycasterApp.closeWindow();
    }

    static {
        pitchPx = 0.0;
        dirX = -1.0;
        dirY = 0.0;
        planeX = 0.0;
        planeY = 0.66;
        INTERACT = new InteractionHub();
    }

    private static final class GameWindow
    extends JFrame
    implements WindowListener {
        private final GameCanvas canvas = new GameCanvas(1024, 640);
        private final Runnable onExit;
        private Thread loop;
        private volatile boolean running;
        private GraphicsDevice device;

        GameWindow(Runnable onExit) {
            super("Dolphin.exe");
            this.onExit = onExit;
            this.setDefaultCloseOperation(2);
            this.setIgnoreRepaint(true);
            this.setResizable(false);
            this.setUndecorated(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.canvas, "Center");
            this.addWindowListener(this);
        }

        void start() {
            try {
                this.setAutoRequestFocus(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            if (this.device.isFullScreenSupported()) {
                this.setUndecorated(true);
                this.setExtendedState(6);
                this.setVisible(true);
            } else {
                this.setExtendedState(6);
                this.setVisible(true);
            }
            SwingUtilities.invokeLater(() -> {
                this.toFront();
                this.requestFocus();
                this.canvas.requestFocusInWindow();
                this.canvas.requestFocusInWindow();
                this.canvas.captureMouse(true);
                this.canvas.initBufferStrategy();
            });
            this.running = true;
            this.loop = new Thread(this::gameLoop, "Raycaster-Loop");
            this.loop.setDaemon(true);
            this.loop.start();
        }

        private void gameLoop() {
            double fps = 60.0;
            double ns = 1.6666666666666666E7;
            long last = System.nanoTime();
            double acc = 0.0;
            while (this.running) {
                long now = System.nanoTime();
                acc += (double)(now - last) / 1.6666666666666666E7;
                last = now;
                while (acc >= 1.0) {
                    this.canvas.updateGame(0.016666666666666666);
                    acc -= 1.0;
                }
                this.canvas.renderFrame();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.canvas.captureMouse(false);
            this.canvas.shutdownWorkers();
            if (this.device != null && this.device.getFullScreenWindow() == this) {
                this.device.setFullScreenWindow(null);
            }
            this.dispose();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            open = false;
            try {
                SND.stopAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long window = Minecraft.getInstance().getWindow().getWindow();
            RenderSystem.recordRenderCall(() -> {
                GLFW.glfwShowWindow((long)window);
                GLFW.glfwRestoreWindow((long)window);
                GLFW.glfwFocusWindow((long)window);
            });
            if (this.onExit != null) {
                try {
                    this.onExit.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.running = false;
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.canvas.requestFocusInWindow();
            this.canvas.captureMouse(true);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.canvas.captureMouse(false);
        }
    }

    public static final class InteractionHub {
        private final ConcurrentMap<String, WallUse> wallByKey = new ConcurrentHashMap<String, WallUse>();
        private final ConcurrentMap<Class<?>, SpriteUse> spriteByClass = new ConcurrentHashMap();

        public void registerWall(String wallKey, WallUse handler) {
            if (wallKey != null && handler != null) {
                this.wallByKey.put(wallKey, handler);
            }
        }

        public void registerSprite(Class<? extends Billboard> type, SpriteUse handler) {
            if (type != null && handler != null) {
                this.spriteByClass.put(type, handler);
            }
        }

        WallUse wallHandler(String key) {
            return key == null ? null : (WallUse)this.wallByKey.get(key);
        }

        SpriteUse spriteHandlerFor(Billboard bb) {
            Class<?> c = bb.getClass();
            SpriteUse best = (SpriteUse)this.spriteByClass.get(c);
            if (best != null) {
                return best;
            }
            for (Map.Entry e : this.spriteByClass.entrySet()) {
                if (!((Class)e.getKey()).isAssignableFrom(c)) continue;
                return (SpriteUse)e.getValue();
            }
            return null;
        }

        public static interface WallUse {
            public void onUse(UseWallHit var1, UseContext var2);

            default public String prompt(UseWallHit hit) {
                return "\u0412\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c";
            }
        }

        public static interface SpriteUse {
            public void onUse(Billboard var1, UseContext var2);

            default public String prompt(Billboard bb) {
                return bb.prompt() != null ? bb.prompt() : "\u0412\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c";
            }
        }

        public static final class UseContext {
            public final double px;
            public final double py;
            public final Consumer<String> say;

            public UseContext(double px, double py, Consumer<String> say) {
                this.px = px;
                this.py = py;
                this.say = say;
            }
        }

        public static final class UseWallHit {
            public final int cellX;
            public final int cellY;
            public final int side;
            public final String wallKey;
            public final double dist;

            UseWallHit(int cx, int cy, int side, String key, double dist) {
                this.cellX = cx;
                this.cellY = cy;
                this.side = side;
                this.wallKey = key;
                this.dist = dist;
            }
        }
    }

    private static final class GameCanvas
    extends Canvas
    implements KeyListener,
    MouseMotionListener,
    MouseListener {
        private static final int DESIRED_STRIPES_PER_CORE = 2;
        private final int WORKERS;
        private final ExecutorService pool;
        private final int W;
        private final int H;
        private final BufferedImage back;
        private final Graphics2D g;
        private final int[] PIX;
        private BufferStrategy bs;
        private final float[] vignetteLUT;
        private final float[] fogLUT;
        private static final float FOG_LUT_STEP = 0.05f;
        private int frameId = 0;
        private final Random rng = new Random();
        private final WorldMap map;
        private double crouchLerp = 0.0;
        private double bobT = 0.0;
        private double camBobPx = 0.0;
        private double fovKick = 0.0;
        private float stepTimer = 0.0f;
        private boolean w;
        private boolean a;
        private boolean s_key;
        private boolean d;
        private boolean q;
        private boolean turnR;
        private boolean left;
        private boolean right;
        private boolean shift;
        private boolean ctrl;
        private boolean usePressed = false;
        private boolean useTap = false;
        private boolean flashlight = true;
        private String hoverPrompt = null;
        private float hoverAlpha = 0.0f;
        private static final double PLAYER_RADIUS = 0.3;
        private static final double MAX_USE_DIST = 1.0;
        private boolean sortDirty = true;
        private double stamina = 1.0;
        private boolean isEnd = false;
        private final double STAMINA_REGEN = 0.28;
        private boolean mouseCaptured = false;
        private Cursor prevCursor;
        private Cursor blankCursor;
        private Robot robot;
        private boolean ignoringWarp = false;
        private int centerX;
        private int centerY;
        private double mouseSensitivity = 0.0025;
        private double mouseSensitivityY = 1.3;
        private final Color SKY = new Color(5, 6, 8);
        private final Color FLOOR = new Color(3, 3, 4);
        private final int FOG_COLOR = -16448248;
        private double time = 0.0;
        private final double SPOT_INNER_COS = Math.cos(Math.toRadians(8.0));
        private final double SPOT_OUTER_COS = Math.cos(Math.toRadians(16.0));
        private final double SPOT_RANGE = 6.5;
        private final double SPOT_INTENS = 3.0;
        private final double SPOT_OVEREXPOSE_DOT = 0.992;
        private final double SPOT_OVEREXPOSE_NEAR = 0.9;
        private final float FOG_DENSITY = 0.24f;
        private final float FOG_HARD_DIST = 8.0f;
        private final WallTextures wallTex = new WallTextures();
        private final FloorTextures floorTex = new FloorTextures();
        private final CeilTextures ceilTex = new CeilTextures();
        private final SpriteSet spriteSet = new SpriteSet();
        private BufferedImage image;
        private final List<Sprite> sprites = new ArrayList<Sprite>();
        private float[] zBuffer;
        private Clip proximityNoise;
        private float noiseVolCur = 0.0f;
        private double noiseUpdateAcc = 0.0;
        private static final double NOISE_UPDATE_RATE = 0.05;
        private static final double NOISE_MAX_DIST = 4.0;
        private static final float NOISE_MAX_VOL = 0.5f;
        private static final String NOISE_KEY = "noise_loop";
        private float proxVisualNoise = 0.0f;

        GameCanvas(int w, int h) {
            this.W = w;
            this.H = h;
            this.setBackground(Color.BLACK);
            this.setIgnoreRepaint(true);
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            int cores = Math.max(1, Runtime.getRuntime().availableProcessors());
            this.WORKERS = Math.max(1, Math.min(cores * 2, this.W));
            this.pool = Executors.newFixedThreadPool(Math.min(this.WORKERS, cores * 2), r -> {
                Thread t = new Thread(r, "RayCPU-" + String.valueOf(UUID.randomUUID()));
                t.setDaemon(true);
                return t;
            });
            this.back = new BufferedImage(this.W, this.H, 1);
            this.g = this.back.createGraphics();
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            DataBufferInt db = (DataBufferInt)this.back.getRaster().getDataBuffer();
            this.PIX = db.getData();
            this.vignetteLUT = new float[this.W * this.H];
            double cx = (double)this.W * 0.5;
            double cy = (double)this.H * 0.5;
            double maxR2 = cx * cx + cy * cy;
            for (int y = 0; y < this.H; ++y) {
                double dy = (double)y - cy;
                for (int x = 0; x < this.W; ++x) {
                    float v;
                    double dx = (double)x - cx;
                    double r2 = (dx * dx + dy * dy) / maxR2;
                    this.vignetteLUT[y * this.W + x] = v = (float)Math.min(1.0, r2 * r2);
                }
            }
            this.fogLUT = GameCanvas.buildFogLUT(8.0f, 0.24f, 0.05f);
            this.blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "blank");
            try {
                this.robot = new Robot();
            }
            catch (AWTException ex) {
                this.robot = null;
            }
            this.map = WorldMap.demo();
            NAV = new Nav(){

                @Override
                public boolean isWalkable(double x, double y) {
                    return map.isWalkable(x, y);
                }

                @Override
                public int width() {
                    return map.getWidth();
                }

                @Override
                public int height() {
                    return map.getHeight();
                }

                @Override
                public int tile(int x, int y) {
                    return map.tileClamped(x, y);
                }

                @Override
                public double[] slide(double px, double py, double nx, double ny, double r) {
                    return map.resolveCollision(px, py, nx, ny, r);
                }

                @Override
                public boolean los(double ax, double ay, double bx, double by, double maxDist) {
                    double sideY;
                    int stepY;
                    double sideX;
                    int stepX;
                    double deltaY;
                    double dx = bx - ax;
                    double dy = by - ay;
                    double dist = Math.hypot(dx, dy);
                    if (dist > maxDist) {
                        return false;
                    }
                    if (dist < 1.0E-6) {
                        return true;
                    }
                    double rayX = dx / dist;
                    double rayY = dy / dist;
                    int mapX = (int)Math.floor(ax);
                    int mapY = (int)Math.floor(ay);
                    double deltaX = rayX == 0.0 ? 1.0E30 : Math.abs(1.0 / rayX);
                    double d = deltaY = rayY == 0.0 ? 1.0E30 : Math.abs(1.0 / rayY);
                    if (rayX < 0.0) {
                        stepX = -1;
                        sideX = (ax - (double)mapX) * deltaX;
                    } else {
                        stepX = 1;
                        sideX = ((double)mapX + 1.0 - ax) * deltaX;
                    }
                    if (rayY < 0.0) {
                        stepY = -1;
                        sideY = (ay - (double)mapY) * deltaY;
                    } else {
                        stepY = 1;
                        sideY = ((double)mapY + 1.0 - ay) * deltaY;
                    }
                    double traveled = 0.0;
                    int tgtX = (int)Math.floor(bx);
                    int tgtY = (int)Math.floor(by);
                    while (traveled <= dist) {
                        if (mapX == tgtX && mapY == tgtY) {
                            return true;
                        }
                        if (sideX < sideY) {
                            traveled = sideX;
                            sideX += deltaX;
                            mapX += stepX;
                        } else {
                            traveled = sideY;
                            sideY += deltaY;
                            mapY += stepY;
                        }
                        if (map.tileClamped(mapX, mapY) == 0) continue;
                        return false;
                    }
                    return false;
                }
            };
            for (Billboard b : this.map.entitiesView()) {
                SpriteFrames frames = b.frames() > 1 ? this.spriteSet.loadAnimated(b.key(), b.frames(), b.fps()) : this.spriteSet.loadStatic(b.key());
                this.sprites.add(new Sprite(b, frames));
            }
            this.zBuffer = new float[this.W];
            SND.loadAllFromRayFolder();
            String path = "/assets/joke/textures/ray/wardrobe_overlay.png";
            this.image = GameCanvas.loadPNG(path);
            RaycasterApp.setPlayerPos(new Vec2(this.map.playerSpawn.x, this.map.playerSpawn.y));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static BufferedImage loadPNG(String classpath) {
            try (InputStream is = RaycasterApp.class.getResourceAsStream(classpath);){
                if (is == null) {
                    BufferedImage bufferedImage2 = null;
                    return bufferedImage2;
                }
                BufferedImage bufferedImage = ImageIO.read(is);
                return bufferedImage;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void initBufferStrategy() {
            if (this.bs != null) {
                return;
            }
            this.createBufferStrategy(3);
            this.bs = this.getBufferStrategy();
        }

        void shutdownWorkers() {
            this.pool.shutdownNow();
            if (this.proximityNoise != null) {
                this.proximityNoise.stop();
                this.proximityNoise.close();
                this.proximityNoise = null;
            }
        }

        void captureMouse(boolean capture) {
            if (capture == this.mouseCaptured) {
                return;
            }
            if (capture) {
                if (this.prevCursor == null) {
                    this.prevCursor = this.getCursor();
                }
                this.setCursor(this.blankCursor);
                this.recalcCenter();
                this.warpToCenter();
                this.mouseCaptured = true;
            } else {
                this.mouseCaptured = false;
                if (this.prevCursor != null) {
                    this.setCursor(this.prevCursor);
                }
            }
        }

        private void recalcCenter() {
            try {
                Point p = this.getLocationOnScreen();
                this.centerX = p.x + this.getWidth() / 2;
                this.centerY = p.y + this.getHeight() / 2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void warpToCenter() {
            if (this.robot != null) {
                this.ignoringWarp = true;
                this.robot.mouseMove(this.centerX, this.centerY);
            }
        }

        void updateGame(double dt) {
            this.time += dt;
            boolean intentMove = (this.w || this.a || this.s_key || this.d) && !inWardrobe;
            boolean intentRun = this.shift;
            double targetCrouch = this.ctrl ? 1.0 : 0.0;
            this.crouchLerp += (targetCrouch - this.crouchLerp) * Math.min(1.0, dt * 10.0);
            if (intentMove && intentRun && this.stamina > 0.0 && !this.isEnd) {
                this.stamina -= STAMINA_DRAIN * dt;
            } else if (intentMove && intentRun && this.stamina <= 0.01 && !this.isEnd) {
                this.isEnd = true;
            } else if (intentMove && intentRun && this.stamina >= 0.99) {
                this.isEnd = false;
            } else {
                this.stamina = intentMove ? (this.stamina += 0.15400000000000003 * dt) : (this.stamina += 0.28 * dt);
            }
            this.stamina = GameCanvas.clamp01d(this.stamina);
            boolean running = intentRun && intentMove && this.stamina > 0.0 && !this.isEnd;
            double targetKick = (running ? 0.18 : 0.0) - 0.05 * this.crouchLerp;
            this.fovKick += (targetKick - this.fovKick) * Math.min(1.0, dt * 6.0);
            double targetLen = 0.66 * (1.0 + this.fovKick);
            double curLen = Math.hypot(planeX, planeY);
            double s = curLen > 1.0E-9 ? targetLen / curLen : 1.0;
            planeX *= s;
            planeY *= s;
            double baseMove = 1.0;
            double crouchMul = 1.0 + -0.55 * this.crouchLerp;
            double runMul = running ? 2.25 : 1.0;
            double move = baseMove * runMul * crouchMul * dt;
            double nx = px;
            double ny = py;
            boolean moving = false;
            if (this.w && !inWardrobe) {
                nx += dirX * move;
                ny += dirY * move;
                moving = true;
            }
            if (this.s_key && !inWardrobe) {
                nx -= dirX * move;
                ny -= dirY * move;
                moving = true;
            }
            if (this.a && !inWardrobe) {
                nx += -dirY * move;
                ny += dirX * move;
                moving = true;
            }
            if (this.d && !inWardrobe) {
                nx += dirY * move;
                ny += -dirX * move;
                moving = true;
            }
            double[] r = this.map.resolveCollision(px, py, nx, ny, 0.3);
            px = r[0];
            py = r[1];
            this.resolveBillboardCollisions();
            if (moving) {
                this.sortDirty = true;
            }
            this.bobT = moving ? (this.bobT += dt * (running ? 2.0 : 1.2)) : (this.bobT += dt * 0.5);
            this.camBobPx = Math.sin(this.bobT * 10.0) * (moving ? (running ? 7.0 : 3.5) : 0.0) * (1.0 - 0.7 * this.crouchLerp);
            this.stepTimer = moving && isBoots ? (this.stepTimer += running ? 0.2f : 0.1f) : 0.0f;
            if (this.stepTimer >= 3.0f) {
                this.stepTimer = 0.0f;
                int i = new Random().nextInt(1, 3);
                SND.playAt("walk" + i, px, py, running ? 0.2f : 0.1f);
            }
            for (Sprite spt : this.sprites) {
                spt.update(dt, px, py);
            }
            InteractHit hovered = this.findUseTarget(1.0);
            String newPrompt = null;
            if (hovered != null) {
                if (hovered.type == InteractHit.Type.WALL) {
                    String text;
                    InteractionHub.UseWallHit h = hovered.wallHit;
                    InteractionHub.WallUse handler = INTERACT.wallHandler(h.wallKey);
                    if (handler != null && (text = handler.prompt(h)) != null && !text.isBlank()) {
                        newPrompt = "[E] " + text;
                    }
                } else if (hovered.type == InteractHit.Type.SPRITE) {
                    Billboard bb = hovered.sprite;
                    String text = null;
                    InteractionHub.SpriteUse handler = INTERACT.spriteHandlerFor(bb);
                    if (handler != null) {
                        text = handler.prompt(bb);
                    } else if (bb.canInteract()) {
                        text = bb.prompt();
                    }
                    if (text != null && !text.isEmpty()) {
                        newPrompt = "[E] " + text;
                    }
                }
            }
            this.hoverPrompt = newPrompt;
            this.hoverAlpha += (this.hoverPrompt != null ? 1.0f : -1.0f) * (float)Math.min(1.0, dt * 10.0);
            if (this.hoverAlpha < 0.0f) {
                this.hoverAlpha = 0.0f;
            }
            if (this.hoverAlpha > 1.0f) {
                this.hoverAlpha = 1.0f;
            }
            if (this.useTap) {
                this.useTap = false;
                if (hovered != null) {
                    this.performUse(hovered);
                }
            }
            this.updateProximityNoise(dt);
            SND.setListener(px, py, dirX, dirY);
        }

        private void updateProximityNoise(double dt) {
            double minDist = Double.POSITIVE_INFINITY;
            for (Sprite sp : this.sprites) {
                double dy;
                double dx;
                double d;
                if (!(sp.billboard instanceof EnemyTag) || !((d = Math.hypot(dx = sp.billboard.getX() - px, dy = sp.billboard.getY() - py)) < minDist)) continue;
                minDist = d;
            }
            double t = 0.0;
            if (minDist < 4.0) {
                double nd = Math.max(0.0, Math.min(4.0, minDist));
                t = 1.0 - nd / 4.0;
                t *= t;
            }
            float targetVol = (float)(t * 0.5);
            this.proxVisualNoise = (float)t;
            this.noiseUpdateAcc += dt;
            if (this.noiseUpdateAcc < 0.05) {
                return;
            }
            this.noiseUpdateAcc = 0.0;
            if (targetVol <= 0.001f) {
                if (this.proximityNoise != null) {
                    this.proximityNoise.stop();
                    this.proximityNoise.close();
                    this.proximityNoise = null;
                }
                this.noiseVolCur = 0.0f;
            } else if (this.proximityNoise == null) {
                this.proximityNoise = SND.loop(NOISE_KEY, targetVol, 0.0f);
                this.noiseVolCur = targetVol;
            } else if (Math.abs(targetVol - this.noiseVolCur) > 0.02f) {
                GameCanvas.setClipGain(this.proximityNoise, targetVol);
                this.noiseVolCur = targetVol;
            }
        }

        private static void setClipGain(Clip c, float linear) {
            if (c == null) {
                return;
            }
            linear = Math.max(1.0E-4f, Math.min(1.0f, linear));
            try {
                FloatControl gc = (FloatControl)c.getControl(FloatControl.Type.MASTER_GAIN);
                float min = gc.getMinimum();
                float max = gc.getMaximum();
                float db = (float)(20.0 * Math.log10(linear));
                db = Math.max(min, Math.min(max, db));
                gc.setValue(db);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void performUse(InteractHit hit) {
            if (hit.type == InteractHit.Type.WALL) {
                InteractionHub.UseWallHit h = hit.wallHit;
                InteractionHub.WallUse handler = INTERACT.wallHandler(h.wallKey);
                if (handler != null) {
                    handler.onUse(h, new InteractionHub.UseContext(px, py, this::say));
                } else {
                    this.say("There is nothing to use (wall: " + h.wallKey + ")");
                }
            } else {
                Billboard bb = hit.sprite;
                InteractionHub.SpriteUse handler = INTERACT.spriteHandlerFor(bb);
                if (handler != null) {
                    handler.onUse(bb, new InteractionHub.UseContext(px, py, this::say));
                } else if (bb.canInteract()) {
                    bb.onInteract(new Billboard.InteractionCtx(){

                        @Override
                        public double playerX() {
                            return px;
                        }

                        @Override
                        public double playerY() {
                            return py;
                        }

                        @Override
                        public void say(String text) {
                            this.say(text);
                        }
                    });
                } else {
                    if (inWardrobe) {
                        SND.playAt("wopen", px, py, 0.9f);
                        inWardrobe = false;
                    }
                    this.say("Nothing to use");
                }
            }
        }

        private void say(String text) {
            System.out.println("[USE] " + text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderFrame() {
            if (this.bs == null) {
                return;
            }
            double crouchPitchPx = (double)this.H * 0.08 * this.crouchLerp;
            int split = (int)Math.round((double)this.H / 2.0 + pitchPx + this.camBobPx + crouchPitchPx);
            this.g.setColor(this.SKY);
            this.g.fillRect(0, 0, this.W, Math.max(0, split));
            this.g.setColor(this.FLOOR);
            this.g.fillRect(0, split, this.W, Math.max(0, this.H - split));
            double ambient = 0.03 + 0.02 * Math.sin(this.time * 0.7) + (this.rng.nextDouble() * 0.02 - 0.01);
            this.renderCeiling(split, (float)ambient);
            this.renderFloor(split, (float)ambient);
            this.renderWallsParallel(split, (float)ambient);
            this.renderSprites((float)ambient, split);
            this.drawPostFX();
            this.g.setColor(new Color(220, 220, 230));
            int bw = 180;
            int bh = 8;
            int bx = 10;
            int by = this.H - 18;
            this.g.setColor(new Color(30, 30, 35));
            this.g.fillRect(bx - 1, by - 1, bw + 2, bh + 2);
            this.g.setColor(new Color(60, 60, 70));
            this.g.fillRect(bx, by, bw, bh);
            this.g.setColor(new Color(140, 200, 140));
            this.g.fillRect(bx, by, (int)((double)bw * this.stamina), bh);
            if (this.hoverAlpha > 0.0f && this.hoverPrompt != null) {
                this.g.setFont(new Font("SansSerif", 0, 14));
                int tw = this.g.getFontMetrics().stringWidth(this.hoverPrompt);
                int x = (this.W - tw) / 2;
                int y = this.H - 40;
                int pad = 6;
                int th = this.g.getFontMetrics().getAscent();
                this.g.setColor(new Color(0, 0, 0, (int)(160.0f * this.hoverAlpha)));
                this.g.fillRoundRect(x - pad, y - th - pad + 4, tw + pad * 2, th + pad * 2, 10, 10);
                this.g.setColor(new Color(230, 230, 235, (int)(255.0f * this.hoverAlpha)));
                this.g.drawString(this.hoverPrompt, x, y);
            }
            if (this.image != null && inWardrobe) {
                this.g.drawImage(this.image, 0, 0, this.W, this.H, null);
            }
            while (true) {
                Graphics gg = this.bs.getDrawGraphics();
                try {
                    gg.drawImage(this.back, 0, 0, this.getWidth(), this.getHeight(), null);
                }
                finally {
                    gg.dispose();
                }
                if (this.bs.contentsRestored()) continue;
                this.bs.show();
                Toolkit.getDefaultToolkit().sync();
                if (!this.bs.contentsLost()) break;
            }
        }

        private void renderFloor(int split, float ambient) {
            int yStart = Math.max(split + 1, 0);
            if (yStart >= this.H) {
                return;
            }
            double r0x = dirX - planeX;
            double r0y = dirY - planeY;
            double r1x = dirX + planeX;
            double r1y = dirY + planeY;
            float posZ = (float)this.H * 0.5f;
            for (int y = yStart; y < this.H; ++y) {
                float p = y - split;
                if (p < 1.0f) continue;
                float rowDist = posZ / p;
                float stepX = (float)((double)rowDist * (r1x - r0x) / (double)this.W);
                float stepY = (float)((double)rowDist * (r1y - r0y) / (double)this.W);
                float worldX = (float)(px + (double)rowDist * r0x);
                float worldY = (float)(py + (double)rowDist * r0y);
                int mip = (int)(rowDist * 0.45f) - 1;
                if (mip < 0) {
                    mip = 0;
                }
                float fog = this.fogFromLUT(rowDist);
                float shade = Math.max(0.06f, 1.0f / (1.0f + rowDist * 0.22f));
                float litBase = ambient + shade;
                if (litBase < 0.0f) {
                    litBase = 0.0f;
                } else if (litBase > 1.0f) {
                    litBase = 1.0f;
                }
                int off = y * this.W;
                int x = 0;
                while (x < this.W) {
                    String key = this.map.floorKeyAt(worldX, worldY);
                    WallTextures.Tex tex = this.floorTex.get(key);
                    int mm = Math.min(mip, tex.levels - 1);
                    float fx = worldX - (float)Math.floor(worldX);
                    float fy = worldY - (float)Math.floor(worldY);
                    int[] tdata = tex.data[mm];
                    int lw = tex.levelW[mm];
                    int lh = tex.levelH[mm];
                    int tx = (int)(fx * (float)lw);
                    if (tx < 0) {
                        tx = 0;
                    } else if (tx >= lw) {
                        tx = lw - 1;
                    }
                    int ty = (int)(fy * (float)lh);
                    if (ty < 0) {
                        ty = 0;
                    } else if (ty >= lh) {
                        ty = lh - 1;
                    }
                    int argb = tdata[ty * lw + tx];
                    float lit = litBase;
                    if (this.flashlight) {
                        double flash = this.flashlightIntensity(worldX, worldY, rowDist);
                        if ((lit += (float)flash) > 1.0f) {
                            lit = 1.0f;
                        }
                        if (lit < 0.0f) {
                            lit = 0.0f;
                        }
                    }
                    argb = GameCanvas.mulColorFastK(argb, lit);
                    if (fog > 0.0f) {
                        argb = GameCanvas.lerpColorFast(argb, -16448248, fog);
                    }
                    this.PIX[off] = argb;
                    worldX += stepX;
                    worldY += stepY;
                    ++x;
                    ++off;
                }
            }
        }

        private void renderCeiling(int split, float ambient) {
            int yEnd = Math.min(Math.max(split, 0), this.H);
            if (yEnd <= 0) {
                return;
            }
            double r0x = dirX - planeX;
            double r0y = dirY - planeY;
            double r1x = dirX + planeX;
            double r1y = dirY + planeY;
            float posZ = (float)this.H * 0.5f;
            for (int y = 0; y < yEnd; ++y) {
                float p = split - y;
                if (p < 1.0f) continue;
                float rowDist = posZ / p;
                float stepX = (float)((double)rowDist * (r1x - r0x) / (double)this.W);
                float stepY = (float)((double)rowDist * (r1y - r0y) / (double)this.W);
                float worldX = (float)(px + (double)rowDist * r0x);
                float worldY = (float)(py + (double)rowDist * r0y);
                int mip = (int)(rowDist * 0.45f) - 1;
                if (mip < 0) {
                    mip = 0;
                }
                float fog = this.fogFromLUT(rowDist);
                float shade = Math.max(0.06f, 1.0f / (1.0f + rowDist * 0.22f));
                float litBase = ambient + shade;
                if (litBase < 0.0f) {
                    litBase = 0.0f;
                } else if (litBase > 1.0f) {
                    litBase = 1.0f;
                }
                int off = y * this.W;
                int x = 0;
                while (x < this.W) {
                    String key = this.map.ceilKeyAt(worldX, worldY);
                    WallTextures.Tex tex = this.ceilTex.get(key);
                    int mm = mip >= tex.levels ? tex.levels - 1 : mip;
                    float fx = worldX - (float)Math.floor(worldX);
                    float fy = worldY - (float)Math.floor(worldY);
                    int[] tdata = tex.data[mm];
                    int lw = tex.levelW[mm];
                    int lh = tex.levelH[mm];
                    int tx = (int)(fx * (float)lw);
                    if (tx < 0) {
                        tx = 0;
                    } else if (tx >= lw) {
                        tx = lw - 1;
                    }
                    int ty = (int)(fy * (float)lh);
                    if (ty < 0) {
                        ty = 0;
                    } else if (ty >= lh) {
                        ty = lh - 1;
                    }
                    int argb = tdata[ty * lw + tx];
                    float lit = litBase;
                    if (this.flashlight) {
                        double flash = this.flashlightIntensity(worldX, worldY, rowDist);
                        if ((lit += (float)flash) > 1.0f) {
                            lit = 1.0f;
                        } else if (lit < 0.0f) {
                            lit = 0.0f;
                        }
                    }
                    argb = GameCanvas.mulColorFastK(argb, lit);
                    if (fog > 0.0f) {
                        argb = GameCanvas.lerpColorFast(argb, -16448248, fog);
                    }
                    this.PIX[off] = argb;
                    worldX += stepX;
                    worldY += stepY;
                    ++x;
                    ++off;
                }
            }
        }

        private void renderWallsParallel(int split, float ambient) {
            int stripes = Math.min(this.W, Math.max(1, this.WORKERS));
            int stripeW = Math.max(1, this.W / stripes);
            ArrayList<Callable<Void>> jobs = new ArrayList<Callable<Void>>(stripes);
            for (int i = 0; i < stripes; ++i) {
                int x0 = i * stripeW;
                int x1 = i == stripes - 1 ? this.W - 1 : x0 + stripeW - 1;
                jobs.add(() -> {
                    this.renderWallsStripe(x0, x1, split, ambient);
                    return null;
                });
            }
            try {
                this.pool.invokeAll(jobs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void renderWallsStripe(int xStart, int xEnd, int split, float ambient) {
            for (int x = xStart; x <= xEnd; ++x) {
                float perpDist;
                float sideY;
                int stepY;
                float sideX;
                int stepX;
                float deltaY;
                float camX = 2.0f * (float)x / (float)this.W - 1.0f;
                float rayX = (float)(dirX + planeX * (double)camX);
                float rayY = (float)(dirY + planeY * (double)camX);
                int mapX = (int)px;
                int mapY = (int)py;
                float deltaX = rayX == 0.0f ? 1.0E30f : Math.abs(1.0f / rayX);
                float f = deltaY = rayY == 0.0f ? 1.0E30f : Math.abs(1.0f / rayY);
                if (rayX < 0.0f) {
                    stepX = -1;
                    sideX = (float)((px - (double)mapX) * (double)deltaX);
                } else {
                    stepX = 1;
                    sideX = (float)(((double)mapX + 1.0 - px) * (double)deltaX);
                }
                if (rayY < 0.0f) {
                    stepY = -1;
                    sideY = (float)((py - (double)mapY) * (double)deltaY);
                } else {
                    stepY = 1;
                    sideY = (float)(((double)mapY + 1.0 - py) * (double)deltaY);
                }
                int hitId = 0;
                boolean side = false;
                while (hitId == 0) {
                    if (sideX < sideY) {
                        sideX += deltaX;
                        mapX += stepX;
                        side = false;
                    } else {
                        sideY += deltaY;
                        mapY += stepY;
                        side = true;
                    }
                    hitId = this.map.tileClamped(mapX, mapY);
                }
                float f2 = !side ? (float)(((double)mapX - px + (double)(1 - stepX) * 0.5) / (double)(rayX == 0.0f ? 1.0E-9f : rayX)) : (perpDist = (float)(((double)mapY - py + (double)(1 - stepY) * 0.5) / (double)(rayY == 0.0f ? 1.0E-9f : rayY)));
                if (perpDist < 0.3f) {
                    perpDist = 0.3f;
                }
                this.zBuffer[x] = perpDist;
                int lineH = (int)((float)this.H / perpDist);
                if (lineH < 1) {
                    lineH = 1;
                }
                int yStart = -lineH / 2 + split;
                int yEnd = lineH / 2 + split;
                String key = this.map.wallKeyById(hitId);
                WallTextures.Tex tex = this.wallTex.get(key);
                boolean LOD_BIAS = true;
                int mip = (int)(perpDist * 0.7f) - 1;
                if (mip < 0) {
                    mip = 0;
                } else if (mip >= tex.levels) {
                    mip = tex.levels - 1;
                }
                int[] tdata = tex.data[mip];
                int lw = tex.levelW[mip];
                int lh = tex.levelH[mip];
                double wallX = !side ? py + (double)(perpDist * rayY) : px + (double)(perpDist * rayX);
                wallX -= Math.floor(wallX);
                int tx = (int)(wallX * (double)lw);
                if (!side && rayX > 0.0f || side && rayY < 0.0f) {
                    tx = lw - 1 - tx;
                }
                if (tx < 0) {
                    tx = 0;
                } else if (tx >= lw) {
                    tx = lw - 1;
                }
                float step = (float)lh / (float)lineH;
                int y0 = Math.max(0, yStart);
                int y1 = Math.min(this.H - 1, yEnd);
                float vPos = (float)(y0 - yStart) * step;
                float shade = Math.max(0.04f, 1.0f / (1.0f + perpDist * 0.2f));
                if (side) {
                    shade *= 0.75f;
                }
                float hitX = (float)(px + (double)(perpDist * rayX));
                float hitY = (float)(py + (double)(perpDist * rayY));
                double flash = this.flashlight ? this.flashlightIntensity(hitX, hitY, perpDist) : 0.0;
                float fog = this.fogFromLUT(perpDist);
                float lit = ambient + shade + (float)flash;
                if (lit < 0.0f) {
                    lit = 0.0f;
                } else if (lit > 1.0f) {
                    lit = 1.0f;
                }
                int off = y0 * this.W + x;
                int k256 = (int)(lit * 256.0f + 0.5f);
                int y = y0;
                while (y <= y1) {
                    int ty = (int)vPos;
                    vPos += step;
                    if (ty < 0) {
                        ty = 0;
                    } else if (ty >= lh) {
                        ty = lh - 1;
                    }
                    int argb = tdata[ty * lw + tx];
                    argb = GameCanvas.mulRGB_K256(argb, k256);
                    if (fog > 0.0f) {
                        argb = GameCanvas.lerpColorFast(argb, -16448248, fog);
                    }
                    this.PIX[off] = argb | 0xFF000000;
                    ++y;
                    off += this.W;
                }
            }
        }

        private void renderSprites(float ambient, int split) {
            if (this.sortDirty) {
                this.sprites.sort((a, b) -> Double.compare(b.sqDistTo(px, py), a.sqDistTo(px, py)));
                this.sortDirty = false;
            }
            for (Sprite sp : this.sprites) {
                if (sp.billboard.consumeTextureChangeFlag()) {
                    String k = sp.billboard.key();
                    int f = sp.billboard.frames();
                    double ffps = sp.billboard.fps();
                    sp.frames = f > 1 ? this.spriteSet.loadAnimated(k, f, ffps) : this.spriteSet.loadStatic(k);
                }
                sp.billboard.update(sp.dtAccum, px, py);
                sp.dtAccum = 0.0;
                SpriteFrames.Frame fr = sp.frames.currentFrame();
                SpriteTexture tex = fr.tex;
                double sx = sp.billboard.getX() - px;
                double sy = sp.billboard.getY() - py;
                double invDet = 1.0 / (planeX * dirY - dirX * planeY);
                double trX = invDet * (dirY * sx - dirX * sy);
                double trY = invDet * (-planeY * sx + planeX * sy);
                if (trY <= 1.0E-4) continue;
                int screenX = (int)((double)this.W / 2.0 * (1.0 + trX / trY));
                int spriteH = Math.abs((int)((double)this.H / trY));
                int y0 = Math.max(0, -spriteH / 2 + split);
                int y1 = Math.min(this.H - 1, spriteH / 2 + split);
                int spriteW = spriteH;
                int x0 = -spriteW / 2 + screenX;
                int x1 = spriteW / 2 + screenX;
                if (x1 < 0 || x0 >= this.W) continue;
                x0 = Math.max(x0, 0);
                x1 = Math.min(x1, this.W - 1);
                double stepX = (double)tex.w / (double)spriteW;
                double stepY = (double)tex.h / (double)spriteH;
                float dx = (float)sx;
                float dy = (float)sy;
                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                double flash = this.flashlight ? this.flashlightIntensity(sp.billboard.getX(), sp.billboard.getY(), dist) : 0.0;
                float fog = this.fogFromLUT(dist);
                float shade = Math.max(0.08f, 1.0f / (1.0f + dist * 0.18f));
                float litBase = ambient + shade + (float)flash;
                if (litBase < 0.0f) {
                    litBase = 0.0f;
                } else if (litBase > 1.0f) {
                    litBase = 1.0f;
                }
                int k256 = (int)(litBase * 256.0f + 0.5f);
                for (int stripe = x0; stripe <= x1; ++stripe) {
                    int tx;
                    if (trY >= (double)this.zBuffer[stripe] || (tx = (int)Math.floor(((double)stripe - ((double)(-spriteW) / 2.0 + (double)screenX)) * stepX)) < 0 || tx >= tex.w) continue;
                    double tyf = ((double)y0 - ((double)split - (double)spriteH / 2.0)) * stepY;
                    int off = y0 * this.W + stripe;
                    int y = y0;
                    while (y <= y1) {
                        int argb;
                        int ty = (int)tyf;
                        tyf += stepY;
                        if (ty >= 0 && ty < tex.h && ((argb = tex.sample(tx, ty)) >>> 24 & 0xFF) >= 16) {
                            argb = GameCanvas.mulRGB_K256(argb, k256);
                            if (fog > 0.0f) {
                                argb = GameCanvas.lerpColorFast(argb, -16448248, fog);
                            }
                            this.PIX[off] = argb | 0xFF000000;
                        }
                        ++y;
                        off += this.W;
                    }
                }
            }
        }

        private double flashlightIntensity(double hx, double hy, double dist) {
            double invLen;
            double dot;
            double t;
            double vx = hx - px;
            double vy = hy - py;
            if ((t = GameCanvas.smoothstep(this.SPOT_OUTER_COS, this.SPOT_INNER_COS, dot = (vx *= (invLen = 1.0 / Math.max(1.0E-6, Math.sqrt(vx * vx + vy * vy)))) * dirX + (vy *= invLen) * dirY)) <= 0.0) {
                return 0.0;
            }
            double att = 1.0 / (1.0 + 1.5 * dist * dist);
            double intens = t * (att *= Math.max(0.0, 1.0 - dist / 6.5)) * 3.0;
            if (dist < 0.9 && dot > 0.992) {
                double over = (-0.008000000000000007 + dot) * 10.0;
                intens += Math.max(0.0, over);
            }
            return intens;
        }

        private static double smoothstep(double edge0Cos, double edge1Cos, double xDot) {
            double t = GameCanvas.clamp01((xDot - edge0Cos) / Math.max(1.0E-6, edge1Cos - edge0Cos));
            return t * t * (3.0 - 2.0 * t);
        }

        private static float[] buildFogLUT(float hardDist, float density, float step) {
            int n = Math.max(2, (int)Math.ceil(hardDist / step) + 1);
            float[] lut = new float[n];
            for (int i = 0; i < n; ++i) {
                float v;
                float d = (float)i * step;
                if (d >= hardDist) {
                    v = 1.0f;
                } else if (d <= 1.0f) {
                    v = 0.0f;
                } else {
                    float dd = d * density;
                    v = 1.0f - (float)Math.exp(-(dd * dd));
                    if (v < 0.0f) {
                        v = 0.0f;
                    } else if (v > 1.0f) {
                        v = 1.0f;
                    }
                }
                lut[i] = v;
            }
            return lut;
        }

        private float fogFromLUT(float dist) {
            if (dist >= 8.0f) {
                return 1.0f;
            }
            if (dist <= 0.0f) {
                return 0.0f;
            }
            int idx = (int)(dist / 0.05f);
            if (idx < 0) {
                idx = 0;
            }
            if (idx >= this.fogLUT.length) {
                idx = this.fogLUT.length - 1;
            }
            return this.fogLUT[idx];
        }

        private void drawPostFX() {
            int N = this.W * this.H;
            int baseNoise = this.frameId * -1640531527;
            for (int i = 0; i < N; ++i) {
                float n;
                float k;
                int argb = this.PIX[i];
                int h = i ^ baseNoise;
                h ^= h << 13;
                h ^= h >>> 17;
                float v = this.vignetteLUT[i];
                if ((k = 1.0f - v + (n = (float)(((h ^= h << 5) & 0xFF) - 128) * 1.5625E-4f * (1.0f + 100.0f * this.proxVisualNoise))) < 0.0f) {
                    k = 0.0f;
                }
                this.PIX[i] = GameCanvas.mulColorFastK(argb, k) | 0xFF000000;
            }
            ++this.frameId;
        }

        private static int mulColorFastK(int argb, float k) {
            if (k <= 0.0f) {
                return -16777216;
            }
            if (k >= 1.0f) {
                return argb | 0xFF000000;
            }
            int k256 = (int)(k * 256.0f + 0.5f);
            return 0xFF000000 | GameCanvas.mulRGB_K256(argb, k256);
        }

        private static int mulRGB_K256(int argb, int k256) {
            int rgb = argb & 0xFFFFFF;
            int rb = rgb & 0xFF00FF;
            int g = rgb & 0xFF00;
            rb = rb * k256 >>> 8;
            g = g * k256 >>> 8;
            return rb & 0xFF00FF | g & 0xFF00;
        }

        private static int lerpColorFast(int a, int b, float t) {
            if (t <= 0.0f) {
                return a | 0xFF000000;
            }
            if (t >= 1.0f) {
                return b | 0xFF000000;
            }
            int ar = a >>> 16 & 0xFF;
            int ag = a >>> 8 & 0xFF;
            int ab = a & 0xFF;
            int br = b >>> 16 & 0xFF;
            int bg = b >>> 8 & 0xFF;
            int bb = b & 0xFF;
            int r = ar + (int)((float)(br - ar) * t);
            int g = ag + (int)((float)(bg - ag) * t);
            int bl = ab + (int)((float)(bb - ab) * t);
            return 0xFF000000 | r << 16 | g << 8 | bl;
        }

        private static float clamp01(double v) {
            return (float)(v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v));
        }

        private static double clamp01d(double v) {
            return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.requestFocus();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 87: {
                    this.w = true;
                    break;
                }
                case 65: {
                    this.a = true;
                    break;
                }
                case 83: {
                    this.s_key = true;
                    break;
                }
                case 68: {
                    this.d = true;
                    break;
                }
                case 16: {
                    this.shift = true;
                    break;
                }
                case 17: {
                    this.ctrl = true;
                    break;
                }
                case 81: {
                    this.q = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 69: {
                    if (!this.usePressed) {
                        this.useTap = true;
                    }
                    this.usePressed = true;
                    break;
                }
                case 70: {
                    this.flashlight = !this.flashlight;
                    break;
                }
                case 66: {
                    System.out.println("X: " + RaycasterApp.getPlayerPos().x + " Y: " + RaycasterApp.getPlayerPos().y);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 87: {
                    this.w = false;
                    break;
                }
                case 65: {
                    this.a = false;
                    break;
                }
                case 83: {
                    this.s_key = false;
                    break;
                }
                case 68: {
                    this.d = false;
                    break;
                }
                case 16: {
                    this.shift = false;
                    break;
                }
                case 17: {
                    this.ctrl = false;
                    break;
                }
                case 81: {
                    this.q = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                    break;
                }
                case 69: {
                    this.usePressed = false;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.mouseCaptured) {
                return;
            }
            if (this.ignoringWarp) {
                this.ignoringWarp = false;
                return;
            }
            double sx = (double)this.W / Math.max(1.0, (double)this.getWidth());
            double sy = (double)this.H / Math.max(1.0, (double)this.getHeight());
            int dx = e.getXOnScreen() - this.centerX;
            int dy = e.getYOnScreen() - this.centerY;
            if (dx != 0 && !inWardrobe) {
                RaycasterApp.rotate((double)(-dx) * this.mouseSensitivity * sx);
                this.sortDirty = true;
            }
            if (dy != 0 && !inWardrobe) {
                double maxPitch = this.H;
                if ((pitchPx += (double)(-dy) * this.mouseSensitivityY * sy) > maxPitch) {
                    pitchPx = maxPitch;
                }
                if (pitchPx < -maxPitch) {
                    pitchPx = -maxPitch;
                }
            }
            this.recalcCenter();
            this.warpToCenter();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.mouseCaptured) {
                this.recalcCenter();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void resolveBillboardCollisions() {
            for (int iter = 0; iter < 2; ++iter) {
                boolean pushed = false;
                for (Sprite sp : this.sprites) {
                    double pen;
                    double ny;
                    double nx;
                    double r;
                    double clY;
                    double dy;
                    Billboard b = sp.billboard;
                    if (!b.isSolid() || inWardrobe && b instanceof EnemyTag) continue;
                    double cx = b.getX();
                    double cy = b.getY();
                    double minX = cx - b.boxHalfX();
                    double maxX = cx + b.boxHalfX();
                    double minY = cy - b.boxHalfY();
                    double maxY = cy + b.boxHalfY();
                    double clX = GameCanvas.clamp(px, minX, maxX);
                    double dx = px - clX;
                    double d2 = dx * dx + (dy = py - (clY = GameCanvas.clamp(py, minY, maxY))) * dy;
                    if (!(d2 < (r = 0.3) * r - 1.0E-9)) continue;
                    double d = Math.sqrt(Math.max(1.0E-12, d2));
                    if (d > 1.0E-9) {
                        nx = dx / d;
                        ny = dy / d;
                        pen = r - d;
                    } else {
                        double pxToCenterX = px - cx;
                        double pxToCenterY = py - cy;
                        if (Math.abs(pxToCenterX) > Math.abs(pxToCenterY)) {
                            nx = Math.signum(pxToCenterX);
                            ny = 0.0;
                        } else {
                            nx = 0.0;
                            ny = Math.signum(pxToCenterY);
                        }
                        pen = r * 0.5;
                    }
                    px += nx * pen;
                    py += ny * pen;
                    pushed = true;
                }
                if (!pushed) break;
            }
        }

        private static double clamp(double v, double lo, double hi) {
            return v < lo ? lo : (v > hi ? hi : v);
        }

        private InteractHit findUseTarget(double maxDist) {
            InteractHit best = null;
            UseWallCandidate wall = this.raycastCenterWall(maxDist);
            if (wall != null) {
                InteractHit h = new InteractHit();
                h.type = InteractHit.Type.WALL;
                h.dist = wall.perpDist;
                h.wallHit = new InteractionHub.UseWallHit(wall.mapX, wall.mapY, wall.side, this.map.wallKeyById(wall.hitId), wall.perpDist);
                best = h;
            }
            double ox = px;
            double oy = py;
            double dx = dirX;
            double dy = dirY;
            for (Sprite sp : this.sprites) {
                double maxY;
                Billboard b = sp.billboard;
                if (!b.canInteract()) continue;
                double cx = b.getX();
                double cy = b.getY();
                double minX = cx - b.boxHalfX();
                double maxX = cx + b.boxHalfX();
                double minY = cy - b.boxHalfY();
                double t = GameCanvas.rayAabb2D(ox, oy, dx, dy, minX, minY, maxX, maxY = cy + b.boxHalfY());
                if (Double.isNaN(t) || t <= 1.0E-6 || t > maxDist || best != null && !(t < best.dist)) continue;
                InteractHit h = new InteractHit();
                h.type = InteractHit.Type.SPRITE;
                h.dist = t;
                h.sprite = b;
                best = h;
            }
            return best != null && best.dist <= maxDist ? best : null;
        }

        private static double rayAabb2D(double ox, double oy, double dx, double dy, double minX, double minY, double maxX, double maxY) {
            double tmp;
            double t2;
            double t1;
            double INF = 1.0E30;
            double tmin = -1.0E30;
            double tmax = 1.0E30;
            if (Math.abs(dx) < 1.0E-9) {
                if (ox < minX || ox > maxX) {
                    return Double.NaN;
                }
            } else {
                t1 = (minX - ox) / dx;
                t2 = (maxX - ox) / dx;
                if (t1 > t2) {
                    tmp = t1;
                    t1 = t2;
                    t2 = tmp;
                }
                tmin = Math.max(tmin, t1);
                if ((tmax = Math.min(tmax, t2)) < tmin) {
                    return Double.NaN;
                }
            }
            if (Math.abs(dy) < 1.0E-9) {
                if (oy < minY || oy > maxY) {
                    return Double.NaN;
                }
            } else {
                t1 = (minY - oy) / dy;
                t2 = (maxY - oy) / dy;
                if (t1 > t2) {
                    tmp = t1;
                    t1 = t2;
                    t2 = tmp;
                }
                tmin = Math.max(tmin, t1);
                if ((tmax = Math.min(tmax, t2)) < tmin) {
                    return Double.NaN;
                }
            }
            if (tmin >= 0.0) {
                return tmin;
            }
            if (tmax >= 0.0) {
                return tmax;
            }
            return Double.NaN;
        }

        private UseWallCandidate raycastCenterWall(double maxDist) {
            float perpDist;
            float sideY;
            int stepY;
            float sideX;
            int stepX;
            float deltaY;
            float rayX = (float)dirX;
            float rayY = (float)dirY;
            int mapX = (int)px;
            int mapY = (int)py;
            float deltaX = rayX == 0.0f ? 1.0E30f : Math.abs(1.0f / rayX);
            float f = deltaY = rayY == 0.0f ? 1.0E30f : Math.abs(1.0f / rayY);
            if (rayX < 0.0f) {
                stepX = -1;
                sideX = (float)((px - (double)mapX) * (double)deltaX);
            } else {
                stepX = 1;
                sideX = (float)(((double)mapX + 1.0 - px) * (double)deltaX);
            }
            if (rayY < 0.0f) {
                stepY = -1;
                sideY = (float)((py - (double)mapY) * (double)deltaY);
            } else {
                stepY = 1;
                sideY = (float)(((double)mapY + 1.0 - py) * (double)deltaY);
            }
            int hitId = 0;
            int side = 0;
            float traveled = 0.0f;
            while (hitId == 0) {
                if (sideX < sideY) {
                    traveled = sideX;
                    sideX += deltaX;
                    mapX += stepX;
                    side = 0;
                } else {
                    traveled = sideY;
                    sideY += deltaY;
                    mapY += stepY;
                    side = 1;
                }
                hitId = this.map.tileClamped(mapX, mapY);
                if (!((double)traveled > maxDist)) continue;
                return null;
            }
            float f2 = side == 0 ? (float)(((double)mapX - px + (double)(1 - stepX) * 0.5) / (double)(rayX == 0.0f ? 1.0E-9f : rayX)) : (perpDist = (float)(((double)mapY - py + (double)(1 - stepY) * 0.5) / (double)(rayY == 0.0f ? 1.0E-9f : rayY)));
            if (perpDist < 0.0f) {
                return null;
            }
            if ((double)perpDist > maxDist) {
                return null;
            }
            UseWallCandidate res = new UseWallCandidate();
            res.mapX = mapX;
            res.mapY = mapY;
            res.side = side;
            res.hitId = hitId;
            res.perpDist = perpDist;
            return res;
        }

        private static final class WallTextures {
            private final Map<String, Tex> cache = new HashMap<String, Tex>();

            private WallTextures() {
            }

            Tex get(String key) {
                if (key == null) {
                    key = "default";
                }
                return this.cache.computeIfAbsent(key, WallTextures::loadOrGen);
            }

            private static Tex loadOrGen(String key) {
                String path = "/assets/joke/textures/ray/" + key + ".png";
                BufferedImage img = WallTextures.loadPNG(path);
                if (img == null) {
                    return Tex.genBrick(64, 64, WallTextures.colorFromKey(key), WallTextures.colorFromKey(key).darker()).buildMipmaps();
                }
                return Tex.fromImage(img).buildMipmaps();
            }

            private static Color colorFromKey(String key) {
                int h = key == null ? 0 : key.hashCode();
                return new Color(100 + (h >>> 1 & 0x7F), 100 + (h >>> 9 & 0x7F), 100 + (h >>> 17 & 0x7F));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static BufferedImage loadPNG(String classpath) {
                try (InputStream is = RaycasterApp.class.getResourceAsStream(classpath);){
                    if (is == null) {
                        BufferedImage bufferedImage2 = null;
                        return bufferedImage2;
                    }
                    BufferedImage bufferedImage = ImageIO.read(is);
                    return bufferedImage;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            static final class Tex {
                final int w;
                final int h;
                final int levels;
                final int[] levelW;
                final int[] levelH;
                final int[][] data;

                Tex(int w, int h, int[] argb) {
                    this.w = w;
                    this.h = h;
                    this.levels = 1;
                    this.levelW = new int[]{w};
                    this.levelH = new int[]{h};
                    this.data = new int[][]{argb};
                }

                Tex(int w, int h, int L, int[] lw, int[] lh, int[][] d) {
                    this.w = w;
                    this.h = h;
                    this.levels = L;
                    this.levelW = lw;
                    this.levelH = lh;
                    this.data = d;
                }

                static Tex fromImage(BufferedImage img) {
                    int w = img.getWidth();
                    int h = img.getHeight();
                    int[] px = img.getRGB(0, 0, w, h, null, 0, w);
                    return new Tex(w, h, px);
                }

                Tex buildMipmaps() {
                    ArrayList<int[]> lv = new ArrayList<int[]>();
                    ArrayList<Integer> lw = new ArrayList<Integer>();
                    ArrayList<Integer> lh = new ArrayList<Integer>();
                    lv.add(this.data[0]);
                    lw.add(this.w);
                    lh.add(this.h);
                    int cw = this.w;
                    int ch = this.h;
                    int[] prev = this.data[0];
                    int level = 0;
                    while (cw > 1 || ch > 1) {
                        int nw = Math.max(1, cw / 2);
                        int nh = Math.max(1, ch / 2);
                        int[] nxt = new int[nw * nh];
                        float desat = 0.0f;
                        if (level >= 2) {
                            desat = Math.min(0.35f, 0.15f + 0.1f * (float)(level - 1));
                        }
                        for (int y = 0; y < nh; ++y) {
                            int y0 = Math.min(ch - 1, 2 * y);
                            int y1 = Math.min(ch - 1, y0 + 1);
                            for (int x = 0; x < nw; ++x) {
                                int x0 = Math.min(cw - 1, 2 * x);
                                int x1 = Math.min(cw - 1, x0 + 1);
                                int c00 = prev[y0 * cw + x0];
                                int c10 = prev[y0 * cw + x1];
                                int c01 = prev[y1 * cw + x0];
                                int c11 = prev[y1 * cw + x1];
                                int avg = Tex.avg4GammaCorrect(c00, c10, c01, c11);
                                if (desat > 0.0f) {
                                    avg = Tex.desaturate(avg, desat);
                                }
                                nxt[y * nw + x] = avg;
                            }
                        }
                        lv.add(nxt);
                        lw.add(nw);
                        lh.add(nh);
                        prev = nxt;
                        cw = nw;
                        ch = nh;
                        ++level;
                    }
                    int L = lv.size();
                    int[] aw = new int[L];
                    int[] ah = new int[L];
                    int[][] ad = new int[L][];
                    for (int i = 0; i < L; ++i) {
                        aw[i] = (Integer)lw.get(i);
                        ah[i] = (Integer)lh.get(i);
                        ad[i] = (int[])lv.get(i);
                    }
                    return new Tex(this.w, this.h, L, aw, ah, ad);
                }

                private static int avg4GammaCorrect(int c0, int c1, int c2, int c3) {
                    float[] a0 = Tex.srgbToLinear(c0);
                    float[] a1 = Tex.srgbToLinear(c1);
                    float[] a2 = Tex.srgbToLinear(c2);
                    float[] a3 = Tex.srgbToLinear(c3);
                    float lr = (a0[1] + a1[1] + a2[1] + a3[1]) * 0.25f;
                    float lg = (a0[2] + a1[2] + a2[2] + a3[2]) * 0.25f;
                    float lb = (a0[3] + a1[3] + a2[3] + a3[3]) * 0.25f;
                    float la = (a0[0] + a1[0] + a2[0] + a3[0]) * 0.25f;
                    int A = Tex.clamp255((int)(la * 255.0f));
                    int R = Tex.clamp255((int)(Tex.linearToSrgb(lr) * 255.0f));
                    int G = Tex.clamp255((int)(Tex.linearToSrgb(lg) * 255.0f));
                    int B = Tex.clamp255((int)(Tex.linearToSrgb(lb) * 255.0f));
                    return A << 24 | R << 16 | G << 8 | B;
                }

                private static float[] srgbToLinear(int argb) {
                    float A = (float)(argb >>> 24 & 0xFF) / 255.0f;
                    float R = Tex.srgbToLinear((float)(argb >>> 16 & 0xFF) / 255.0f);
                    float G = Tex.srgbToLinear((float)(argb >>> 8 & 0xFF) / 255.0f);
                    float B = Tex.srgbToLinear((float)(argb & 0xFF) / 255.0f);
                    return new float[]{A, R, G, B};
                }

                private static float srgbToLinear(float c) {
                    return c <= 0.04045f ? c / 12.92f : (float)Math.pow((c + 0.055f) / 1.055f, 2.4);
                }

                private static float linearToSrgb(float c) {
                    return c <= 0.0031308f ? 12.92f * c : 1.055f * (float)Math.pow(c, 0.4166666666666667) - 0.055f;
                }

                private static int desaturate(int argb, float k) {
                    int A = argb >>> 24 & 0xFF;
                    int R = argb >>> 16 & 0xFF;
                    int G = argb >>> 8 & 0xFF;
                    int B = argb & 0xFF;
                    int L = Tex.clamp255((int)(0.2126f * (float)R + 0.7152f * (float)G + 0.0722f * (float)B));
                    R = Tex.clamp255((int)((float)R + (float)(L - R) * k));
                    G = Tex.clamp255((int)((float)G + (float)(L - G) * k));
                    B = Tex.clamp255((int)((float)B + (float)(L - B) * k));
                    return A << 24 | R << 16 | G << 8 | B;
                }

                private static int clamp255(int v) {
                    return v < 0 ? 0 : Math.min(255, v);
                }

                int sample(int tx, int ty, int level) {
                    level = Math.max(0, Math.min(this.levels - 1, level));
                    int lw = this.levelW[level];
                    int lh = this.levelH[level];
                    tx = Tex.mod(tx, lw);
                    ty = Tex.mod(ty, lh);
                    return this.data[level][ty * lw + tx];
                }

                static Tex genBrick(int w, int h, Color a, Color b) {
                    int[] px = new int[w * h];
                    for (int y = 0; y < h; ++y) {
                        for (int x = 0; x < w; ++x) {
                            Color c;
                            boolean brick = x / 8 % 2 == y / 8 % 2;
                            Color color = c = brick ? a : b;
                            if (x % 8 == 0 || y % 8 == 0) {
                                c = c.darker();
                            }
                            px[y * w + x] = 0xFF000000 | c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
                        }
                    }
                    return new Tex(w, h, px);
                }

                private static int mod(int x, int m) {
                    int r = x % m;
                    return r < 0 ? r + m : r;
                }
            }
        }

        private static final class FloorTextures {
            private final Map<String, WallTextures.Tex> cache = new HashMap<String, WallTextures.Tex>();

            private FloorTextures() {
            }

            WallTextures.Tex get(String key) {
                if (key == null) {
                    key = "floor";
                }
                return this.cache.computeIfAbsent(key, FloorTextures::loadOrGen);
            }

            private static WallTextures.Tex loadOrGen(String key) {
                String path = "/assets/joke/textures/ray/" + key + ".png";
                BufferedImage img = WallTextures.loadPNG(path);
                if (img == null) {
                    Color a = new Color(40, 40, 45);
                    Color b = new Color(28, 28, 32);
                    return WallTextures.Tex.genBrick(64, 64, a, b).buildMipmaps();
                }
                return WallTextures.Tex.fromImage(img).buildMipmaps();
            }
        }

        private static final class CeilTextures {
            private final Map<String, WallTextures.Tex> cache = new HashMap<String, WallTextures.Tex>();

            private CeilTextures() {
            }

            WallTextures.Tex get(String key) {
                if (key == null) {
                    key = "ceil";
                }
                return this.cache.computeIfAbsent(key, CeilTextures::loadOrGen);
            }

            private static WallTextures.Tex loadOrGen(String key) {
                String path = "/assets/joke/textures/ray/" + key + ".png";
                BufferedImage img = WallTextures.loadPNG(path);
                if (img == null) {
                    Color a = new Color(48, 50, 60);
                    Color b = new Color(30, 32, 38);
                    return WallTextures.Tex.genBrick(64, 64, a, b).buildMipmaps();
                }
                return WallTextures.Tex.fromImage(img).buildMipmaps();
            }
        }

        private static final class SpriteSet {
            private SpriteSet() {
            }

            SpriteFrames loadAnimated(String key, int count, double fps) {
                SpriteFrames f = new SpriteFrames(fps);
                for (int i = 0; i < count; ++i) {
                    String path = "/assets/joke/textures/ray/spr_" + key + "_" + i + ".png";
                    BufferedImage img = SpriteSet.loadPNG(path);
                    f.add(img == null ? SpriteSet.genCircle(48, 48, new Color(220, 50, 50, 220), new Color(120, 0, 0, 180)) : SpriteSet.fromImage(img));
                }
                return f;
            }

            SpriteFrames loadStatic(String key) {
                SpriteFrames f = new SpriteFrames(0.0);
                String path = "/assets/joke/textures/ray/spr_" + key + ".png";
                BufferedImage img = SpriteSet.loadPNG(path);
                f.add(img == null ? SpriteSet.genCircle(48, 48, new Color(240, 200, 80, 230), new Color(160, 120, 20, 180)) : SpriteSet.fromImage(img));
                return f;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private static BufferedImage loadPNG(String classpath) {
                try (InputStream is = RaycasterApp.class.getResourceAsStream(classpath);){
                    if (is == null) {
                        BufferedImage bufferedImage2 = null;
                        return bufferedImage2;
                    }
                    BufferedImage bufferedImage = ImageIO.read(is);
                    return bufferedImage;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            private static SpriteTexture fromImage(BufferedImage img) {
                int w = img.getWidth();
                int h = img.getHeight();
                int[] px = img.getRGB(0, 0, w, h, null, 0, w);
                return new SpriteTexture(w, h, px);
            }

            private static SpriteTexture genCircle(int w, int h, Color c1, Color c2) {
                int[] px = new int[w * h];
                double cx = (double)w / 2.0;
                double cy = (double)h / 2.0;
                double r = (double)Math.min(w, h) / 2.0 - 1.0;
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        double dx = (double)x - cx;
                        double dy = (double)y - cy;
                        double d = Math.sqrt(dx * dx + dy * dy);
                        if (d <= r) {
                            double t = d / r;
                            int R = (int)((double)c1.getRed() * (1.0 - t) + (double)c2.getRed() * t);
                            int G = (int)((double)c1.getGreen() * (1.0 - t) + (double)c2.getGreen() * t);
                            int B = (int)((double)c1.getBlue() * (1.0 - t) + (double)c2.getBlue() * t);
                            int A = (int)((double)c1.getAlpha() * (1.0 - t) + (double)c2.getAlpha() * t);
                            px[y * w + x] = A << 24 | R << 16 | G << 8 | B;
                            continue;
                        }
                        px[y * w + x] = 0;
                    }
                }
                return new SpriteTexture(w, h, px);
            }
        }

        private static final class SpriteFrames {
            private final List<Frame> frames = new ArrayList<Frame>();
            private final double fps;
            private double t;
            private int idx;

            SpriteFrames(double fps) {
                this.fps = fps;
            }

            void add(SpriteTexture t) {
                this.frames.add(new Frame(t));
            }

            void update(double dt) {
                if (this.fps <= 0.0 || this.frames.size() <= 1) {
                    return;
                }
                this.t += dt * this.fps;
                int adv = (int)Math.floor(this.t);
                if (adv != 0) {
                    this.t -= (double)adv;
                    this.idx = (this.idx + adv) % this.frames.size();
                }
            }

            Frame currentFrame() {
                return this.frames.get(Math.max(0, Math.min(this.frames.size() - 1, this.idx)));
            }

            static final class Frame {
                final SpriteTexture tex;

                Frame(SpriteTexture t) {
                    this.tex = t;
                }
            }
        }

        private static final class Sprite {
            final Billboard billboard;
            SpriteFrames frames;
            double dtAccum;

            Sprite(Billboard b, SpriteFrames fr) {
                this.billboard = b;
                this.frames = fr;
            }

            void update(double dt, double px, double py) {
                this.dtAccum += dt;
                this.frames.update(dt);
            }

            double sqDistTo(double ax, double ay) {
                double dx = this.billboard.getX() - ax;
                double dy = this.billboard.getY() - ay;
                return dx * dx + dy * dy;
            }
        }

        private static final class InteractHit {
            Type type;
            double dist;
            InteractionHub.UseWallHit wallHit;
            Billboard sprite;

            private InteractHit() {
            }

            static enum Type {
                WALL,
                SPRITE;

            }
        }

        private static final class SpriteTexture {
            final int w;
            final int h;
            final int[] data;

            SpriteTexture(int w, int h, int[] px) {
                this.w = w;
                this.h = h;
                this.data = px;
            }

            int sample(int x, int y) {
                if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
                    return 0;
                }
                return this.data[y * this.w + x];
            }
        }

        private static final class UseWallCandidate {
            int mapX;
            int mapY;
            int side;
            int hitId;
            double perpDist;

            private UseWallCandidate() {
            }
        }
    }

    public static interface Nav {
        public boolean isWalkable(double var1, double var3);

        public int width();

        public int height();

        public int tile(int var1, int var2);

        public double[] slide(double var1, double var3, double var5, double var7, double var9);

        public boolean los(double var1, double var3, double var5, double var7, double var9);
    }
}

