/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.game;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;

public final class SoundEngine {
    private final String modid;
    private final Map<String, Buf> cache = new ConcurrentHashMap<String, Buf>();
    private volatile double lx = 0.0;
    private volatile double ly = 0.0;
    private volatile double ldx = 1.0;
    private volatile double ldy = 0.0;
    private final Set<Clip> activeLoops = Collections.newSetFromMap(new ConcurrentHashMap());
    private final CopyOnWriteArrayList<SoundListener> listeners = new CopyOnWriteArrayList();

    public void stop(Clip c) {
        if (c == null) {
            return;
        }
        try {
            c.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.activeLoops.remove(c);
    }

    public void stopAll() {
        for (Clip c : new ArrayList<Clip>(this.activeLoops)) {
            try {
                c.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                c.close();
            }
            catch (Exception exception) {}
        }
        this.activeLoops.clear();
    }

    public SoundEngine(String modid) {
        this.modid = modid;
    }

    public void setListener(double x, double y, double dirX, double dirY) {
        this.lx = x;
        this.ly = y;
        double len = Math.hypot(dirX, dirY);
        if (len < 1.0E-8) {
            this.ldx = 1.0;
            this.ldy = 0.0;
        } else {
            this.ldx = dirX / len;
            this.ldy = dirY / len;
        }
    }

    public void load(String key) {
        this.cache.computeIfAbsent(key, k -> {
            String path = "/assets/" + this.modid + "/sounds/ray/" + k + ".wav";
            try (InputStream raw = SoundEngine.class.getResourceAsStream(path);){
                Buf buf;
                if (raw == null) {
                    throw new IOException("Not found: " + path);
                }
                try (BufferedInputStream bis = new BufferedInputStream(raw);){
                    AudioInputStream ais = AudioSystem.getAudioInputStream(bis);
                    AudioFormat src = ais.getFormat();
                    AudioFormat dst = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, src.getSampleRate() <= 0.0f ? 44100.0f : src.getSampleRate(), 16, src.getChannels() == -1 || src.getChannels() < 1 ? 2 : src.getChannels(), (src.getChannels() <= 0 ? 2 : src.getChannels()) * 2, src.getSampleRate() <= 0.0f ? 44100.0f : src.getSampleRate(), false);
                    if (!AudioSystem.isConversionSupported(dst, src)) {
                        dst = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
                        ais = AudioSystem.getAudioInputStream(dst, ais);
                    } else {
                        ais = AudioSystem.getAudioInputStream(dst, ais);
                    }
                    byte[] all = SoundEngine.readAll(ais);
                    buf = new Buf(dst, all);
                }
                return buf;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Buf(new AudioFormat(44100.0f, 16, 2, true, false), new byte[0]);
            }
        });
    }

    public void loadAllFromRayFolder() {
        String base = "/assets/" + this.modid + "/sounds/ray";
        List<String> names = SoundEngine.listResourceWavs(base);
        for (String name : names) {
            int slash = name.lastIndexOf(47);
            String file = slash >= 0 ? name.substring(slash + 1) : name;
            int dot = file.lastIndexOf(46);
            String key = dot >= 0 ? file.substring(0, dot) : file;
            if (key.isEmpty()) continue;
            this.load(key);
        }
    }

    private static List<String> listResourceWavs(String basePath) {
        ArrayList<String> out;
        block26: {
            out = new ArrayList<String>();
            try {
                Path root;
                Path dir;
                Path dir2;
                URL url = SoundEngine.class.getResource(basePath);
                if (url != null && "file".equals(url.getProtocol()) && Files.isDirectory(dir2 = Paths.get(url.toURI()), new LinkOption[0])) {
                    try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir2, "*.{wav,WAV}");){
                        for (Path p : ds) {
                            out.add(dir2.relativize(p).toString().replace('\\', '/'));
                        }
                    }
                    for (int i = 0; i < out.size(); ++i) {
                        out.set(i, "ray/" + (String)out.get(i));
                    }
                    return out;
                }
                String pathInJar = basePath.startsWith("/") ? basePath.substring(1) : basePath;
                CodeSource src = SoundEngine.class.getProtectionDomain().getCodeSource();
                if (src == null) break block26;
                URI loc = src.getLocation().toURI();
                Path p = Paths.get(loc);
                if (Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".jar")) {
                    try (JarFile jf = new JarFile(p.toFile());){
                        Enumeration<JarEntry> en = jf.entries();
                        while (en.hasMoreElements()) {
                            JarEntry je = en.nextElement();
                            String name = je.getName();
                            if (!name.startsWith(pathInJar + "/") || !name.endsWith(".wav") || je.isDirectory()) continue;
                            String tail = name.substring(name.indexOf("ray/"));
                            out.add(tail);
                        }
                        break block26;
                    }
                }
                if (!Files.isDirectory(p, new LinkOption[0]) || !Files.isDirectory(dir = (root = p).resolve(pathInJar), new LinkOption[0])) break block26;
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir, "*.{wav,WAV}");){
                    for (Path f : ds) {
                        out.add("ray/" + f.getFileName().toString().replace('\\', '/'));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    public void loadAll(String ... keys) {
        for (String k : keys) {
            this.load(k);
        }
    }

    public void play(String key) {
        this.play(key, 1.0f);
    }

    public void play(String key, float vol) {
        Buf b = this.cache.get(key);
        if (b == null) {
            this.load(key);
            b = this.cache.get(key);
        }
        this.startClip(b, vol, 0.0f, false);
    }

    public void addListener(SoundListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeListener(SoundListener l) {
        this.listeners.remove(l);
    }

    private void fireSound(String key, double x, double y, float vol) {
        for (SoundListener l : this.listeners) {
            l.onSound(key, x, y, vol);
        }
    }

    public void playAt(String key, double sx, double sy) {
        this.playAt(key, sx, sy, 1.0f);
    }

    public void playAt(String key, double sx, double sy, float baseVol) {
        double vy;
        double vx;
        double dist;
        Buf b = this.cache.get(key);
        if (b == null) {
            this.load(key);
            b = this.cache.get(key);
        }
        if ((dist = Math.hypot(vx = sx - this.lx, vy = sy - this.ly)) < 1.0E-6) {
            dist = 1.0E-6;
        }
        double inv = 1.0 / dist;
        double rx = this.ldy;
        double ry = -this.ldx;
        float pan = (float)SoundEngine.clamp((vx *= inv) * rx + (vy *= inv) * ry, -1.0, 1.0);
        double att = 1.0 / (1.0 + 0.35 * dist * dist);
        float vol = (float)SoundEngine.clamp((double)baseVol * att, 0.0, 1.0);
        this.fireSound(key, sx, sy, vol);
        this.startClip(b, vol, pan, false);
    }

    public Clip loop(String key, float vol, float pan) {
        Clip c;
        Buf b = this.cache.get(key);
        if (b == null) {
            this.load(key);
            b = this.cache.get(key);
        }
        if ((c = this.newClip(b)) == null) {
            return null;
        }
        SoundEngine.setGain(c, vol);
        SoundEngine.setPan(c, pan);
        this.activeLoops.add(c);
        c.addLineListener(ev -> {
            if (ev.getType() == LineEvent.Type.STOP || ev.getType() == LineEvent.Type.CLOSE) {
                this.activeLoops.remove(c);
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        c.loop(-1);
        c.start();
        return c;
    }

    private void startClip(Buf b, float vol, float pan, boolean wait) {
        Clip c = this.newClip(b);
        if (c == null) {
            return;
        }
        SoundEngine.setGain(c, vol);
        SoundEngine.setPan(c, pan);
        c.start();
        if (wait) {
            try {
                Thread.sleep(Math.max(1L, (long)(1000.0 * ((double)b.data.length / (double)b.fmt.getFrameSize()) / (double)b.fmt.getFrameRate())));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            c.drain();
            c.close();
        } else {
            c.addLineListener(ev -> {
                if (ev.getType() == LineEvent.Type.STOP) {
                    c.close();
                }
            });
        }
    }

    private Clip newClip(Buf b) {
        try {
            Clip c = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, b.fmt));
            c.open(b.fmt, b.data, 0, b.data.length);
            return c;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setGain(Clip c, float linear) {
        linear = Math.max(1.0E-4f, Math.min(1.0f, linear));
        try {
            FloatControl gc = (FloatControl)c.getControl(FloatControl.Type.MASTER_GAIN);
            float min = gc.getMinimum();
            float max = gc.getMaximum();
            float db = (float)(20.0 * Math.log10(linear));
            db = Math.max(min, Math.min(max, db));
            gc.setValue(db);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void setPan(Clip c, float pan) {
        pan = Math.max(-1.0f, Math.min(1.0f, pan));
        try {
            FloatControl pc = (FloatControl)c.getControl(FloatControl.Type.PAN);
            pc.setValue(pan);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static byte[] readAll(AudioInputStream ais) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int r;
            byte[] buf = new byte[65536];
            while ((r = ais.read(buf)) != -1) {
                bos.write(buf, 0, r);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private static double clamp(double v, double a, double b) {
        return v < a ? a : (v > b ? b : v);
    }

    private static final class Buf {
        final AudioFormat fmt;
        final byte[] data;

        Buf(AudioFormat f, byte[] d) {
            this.fmt = f;
            this.data = d;
        }
    }

    public static interface SoundListener {
        public void onSound(String var1, double var2, double var4, float var6);
    }
}

