/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.game;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.knifick.badjoke.game.Billboard;
import net.knifick.badjoke.game.RaycasterApp;
import net.knifick.badjoke.game.billboards.BagsBillboard;
import net.knifick.badjoke.game.billboards.BarsBillboard;
import net.knifick.badjoke.game.billboards.BoolBillboard;
import net.knifick.badjoke.game.billboards.BootsBillboard;
import net.knifick.badjoke.game.billboards.DolphinBillboard;
import net.knifick.badjoke.game.billboards.LstatueBillboard;
import net.knifick.badjoke.game.billboards.SecurityBillboard;
import net.knifick.badjoke.game.billboards.StatueBillboard;
import net.knifick.badjoke.game.billboards.VictimBillboard;
import net.knifick.badjoke.game.billboards.WardrobeFactory;
import net.knifick.badjoke.game.billboards.WardrobeGBillboard;
import net.knifick.badjoke.network.payloads.GameClosePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.phys.Vec2;

public final class WorldMap {
    private final int width;
    private final int height;
    private final int[][] grid;
    private final int[][] floorIds;
    private final int[][] ceilIds;
    private final List<String> wallKeyById = new ArrayList<String>();
    private final Map<String, Integer> wallIdByKey = new HashMap<String, Integer>();
    public final Vec2 playerSpawn;
    private final List<String> floorKeyById = new ArrayList<String>();
    private final Map<String, Integer> floorIdByKey = new HashMap<String, Integer>();
    private final List<String> ceilKeyById = new ArrayList<String>();
    private final Map<String, Integer> ceilIdByKey = new HashMap<String, Integer>();
    private final List<Billboard> entities = new ArrayList<Billboard>();

    public WorldMap(int width, int height, Vec2 playerSpawn) {
        if (width < 2 || height < 2) {
            throw new IllegalArgumentException("World too small");
        }
        this.width = width;
        this.height = height;
        this.grid = new int[height][width];
        this.floorIds = new int[height][width];
        this.ceilIds = new int[height][width];
        this.playerSpawn = playerSpawn;
        this.wallKeyById.add(null);
        this.floorKeyById.add(null);
        this.ceilKeyById.add(null);
    }

    public void createWorldBorders(Vec2 size, String textureKey) {
        int w = Math.round(size.x);
        int h = Math.round(size.y);
        if (w != this.width || h != this.height) {
            throw new IllegalArgumentException("Size mismatch: " + w + "x" + h + " vs world " + this.width + "x" + this.height);
        }
        int id = this.ensureWallTex(textureKey);
        for (int x = 0; x < this.width; ++x) {
            this.grid[0][x] = id;
            this.grid[this.height - 1][x] = id;
        }
        for (int y = 0; y < this.height; ++y) {
            this.grid[y][0] = id;
            this.grid[y][this.width - 1] = id;
        }
    }

    public void addWall(Vec2 from, Vec2 to, String textureKey) {
        int id = this.ensureWallTex(textureKey);
        int x0 = (int)Math.floor(from.x);
        int y0 = (int)Math.floor(from.y);
        int x1 = (int)Math.floor(to.x);
        int y1 = (int)Math.floor(to.y);
        this.bresenhamPaint(x0, y0, x1, y1, id);
    }

    public void addWallSize(Vec2 topLeft, Vec2 size, String textureKey) {
        int id = this.ensureWallTex(textureKey);
        int x0 = (int)Math.floor(topLeft.x);
        int y0 = (int)Math.floor(topLeft.y);
        int x1 = (int)Math.floor(topLeft.x + size.x) - 1;
        int y1 = (int)Math.floor(topLeft.y + size.y) - 1;
        x0 = Math.max(0, Math.min(x0, this.width - 1));
        y0 = Math.max(0, Math.min(y0, this.height - 1));
        x1 = Math.max(0, Math.min(x1, this.width - 1));
        y1 = Math.max(0, Math.min(y1, this.height - 1));
        if (x1 < x0 || y1 < y0) {
            return;
        }
        for (int y = y0; y <= y1; ++y) {
            for (int x = x0; x <= x1; ++x) {
                this.grid[y][x] = id;
            }
        }
    }

    public <T extends Billboard> void addEntity(Vec2 pos, T entity) {
        this.entities.add(entity.at(pos));
    }

    public void applyCharMap(int offsetX, int offsetY, String[] rows, Map<Character, String> legend) {
        if (rows == null) {
            return;
        }
        for (int y = 0; y < rows.length; ++y) {
            int gy;
            String row = rows[y];
            if (row == null || (gy = offsetY + y) < 0 || gy >= this.height) continue;
            int len = row.length();
            for (int x = 0; x < len; ++x) {
                int id;
                String key;
                int gx = offsetX + x;
                if (gx < 0 || gx >= this.width) continue;
                char c = row.charAt(x);
                this.grid[gy][gx] = c == '.' || c == ' ' ? 0 : ((key = legend.get(Character.valueOf(c))) == null || key.isEmpty() ? 0 : (id = this.ensureWallTex(key)));
            }
        }
    }

    public void applyCharMap(String[] rows, Map<Character, String> legend) {
        this.applyCharMap(0, 0, rows, legend);
    }

    public static Map<Character, String> legend(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("legend: \u043e\u0436\u0438\u0434\u0430\u044e\u0442\u0441\u044f \u043f\u0430\u0440\u044b (char,'key')");
        }
        HashMap<Character, String> m = new HashMap<Character, String>();
        for (int i = 0; i < pairs.length; i += 2) {
            Object k = pairs[i];
            Object v = pairs[i + 1];
            if (!(k instanceof Character) || !(v instanceof String)) {
                throw new IllegalArgumentException("legend: \u043f\u0430\u0440\u0430 #" + i / 2 + " \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c (Character, String)");
            }
            m.put((Character)k, (String)v);
        }
        return m;
    }

    int tileClamped(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return 1;
        }
        return this.grid[y][x];
    }

    boolean isWalkable(double x, double y) {
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        if (ix < 0 || ix >= this.width || iy < 0 || iy >= this.height) {
            return false;
        }
        return this.grid[iy][ix] == 0;
    }

    double[] resolveCollision(double px, double py, double nx, double ny, double r) {
        double dy;
        double rx = px;
        double ry = py;
        double dx = nx - px;
        if (dx != 0.0) {
            int signX = dx > 0.0 ? 1 : -1;
            int probeX = (int)Math.floor(nx + (double)signX * r);
            int y0 = (int)Math.floor(py - r);
            int y1 = (int)Math.floor(py + r);
            boolean free = true;
            for (int cy = y0; cy <= y1; ++cy) {
                if (this.tileClamped(probeX, cy) == 0) continue;
                free = false;
                break;
            }
            if (free) {
                rx = nx;
            }
        }
        if ((dy = ny - py) != 0.0) {
            int signY = dy > 0.0 ? 1 : -1;
            int probeY = (int)Math.floor(ny + (double)signY * r);
            int x0 = (int)Math.floor(rx - r);
            int x1 = (int)Math.floor(rx + r);
            boolean free = true;
            for (int cx = x0; cx <= x1; ++cx) {
                if (this.tileClamped(cx, probeY) == 0) continue;
                free = false;
                break;
            }
            if (free) {
                ry = ny;
            }
        }
        return new double[]{rx, ry};
    }

    List<Billboard> entitiesView() {
        return Collections.unmodifiableList(this.entities);
    }

    String wallKeyById(int id) {
        if (id <= 0 || id >= this.wallKeyById.size()) {
            return null;
        }
        return this.wallKeyById.get(id);
    }

    private int ensureWallTex(String key) {
        Integer id = this.wallIdByKey.get(key);
        if (id != null) {
            return id;
        }
        int nid = this.wallKeyById.size();
        this.wallKeyById.add(key);
        this.wallIdByKey.put(key, nid);
        return nid;
    }

    private void bresenhamPaint(int x0, int y0, int x1, int y1, int id) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
                this.grid[y][x] = id;
            }
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private static boolean hasOpenNeighbor(boolean[][] pass, int x, int y) {
        int H = pass.length;
        int W = pass[0].length;
        if (x > 1 && pass[y][x - 1]) {
            return true;
        }
        if (x < W - 2 && pass[y][x + 1]) {
            return true;
        }
        if (y > 1 && pass[y - 1][x]) {
            return true;
        }
        return y < H - 2 && pass[y + 1][x];
    }

    static WorldMap demo() {
        WorldMap m = new WorldMap(20, 20, new Vec2(11.9f, 5.8f));
        m.applyFloorCeilCharMap(new String[]{"....................", "....................", "....................", "....................", "....................", "....................", "....................", "....................", "....................", "....................", "....................", "....................", ".TTT................", "....................", "....................", "....................", "................D...", "....................", "....................", "...................."}, WorldMap.fcLegend(Character.valueOf('D'), WorldMap.fc("floor_exp", "ceil_exp"), Character.valueOf('T'), WorldMap.fc("floor_hole", "ceil")));
        m.applyCharMap(new String[]{"WWWWWW21WSWDWWWWWWWW", "S..W.........W.....W", "E............B.....C", "WWWW...............W", "W..WW.WW.WW.WW.....S", "W..V...W..W..W.....C", "WWWC...C..S..C.....W", "C..SW.WW.WW.WWWWDWWW", "W..W.........O.....W", "1..................D", "2............W.....W", "WWWWCWW..WWWWW.....S", "G...W.....W..W.....W", "W...W........WWWWWWW", "W.WWW.....W..W.....W", "D.........W..W.....W", "W......W..W.WW.....W", "WW.WWWWW...........W", "W.....W......W.....W", "WWDWWWWWWWDWWWWWWWWW"}, WorldMap.legend(Character.valueOf('W'), "wall", Character.valueOf('B'), "wall_bool", Character.valueOf('O'), "wall_boots", Character.valueOf('C'), "wall_candals", Character.valueOf('S'), "wall_ccandals", Character.valueOf('D'), "wall_door", Character.valueOf('V'), "wall_victim", Character.valueOf('1'), "wall_board1", Character.valueOf('2'), "wall_board2", Character.valueOf('E'), "wall_door_open", Character.valueOf('G'), "wall_govno"));
        BoolBillboard bool = (BoolBillboard)((BoolBillboard)((BoolBillboard)((BoolBillboard)new BoolBillboard().box(0.15, 0.1)).solid(true)).interactable(true)).prompt("\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        BootsBillboard boots = (BootsBillboard)((BootsBillboard)((BootsBillboard)((BootsBillboard)new BootsBillboard().box(0.1, 0.1)).solid(true)).interactable(true)).prompt("\u041d\u0430\u0434\u0435\u0442\u044c");
        BarsBillboard bars = (BarsBillboard)((BarsBillboard)new BarsBillboard().box(0.1, 0.9)).solid(true);
        BagsBillboard bags = (BagsBillboard)((BagsBillboard)((BagsBillboard)((BagsBillboard)new BagsBillboard().box(0.3, 0.3)).solid(true)).interactable(true)).prompt("");
        m.addEntity(new Vec2(16.7f, 4.4f), bool);
        m.addEntity(new Vec2(15.9f, 10.4f), boots);
        m.addEntity(new Vec2(7.0f, 2.4f), (DolphinBillboard)((DolphinBillboard)((DolphinBillboard)((DolphinBillboard)new DolphinBillboard().interactable(true)).prompt("")).box(0.25, 0.25)).solid(true));
        m.addEntity(new Vec2(3.5f, 2.5f), bars);
        m.addEntity(new Vec2(11.5f, 4.5f), ((Billboard)Billboard.ofStatic("bars").box(0.9, 0.1)).solid(true));
        m.addEntity(new Vec2(11.5f, 7.5f), Billboard.ofStatic("bars_br"));
        m.addEntity(new Vec2(5.5f, 7.5f), ((Billboard)Billboard.ofStatic("bars").box(0.9, 0.1)).solid(true));
        m.addEntity(new Vec2(5.5f, 4.5f), ((Billboard)Billboard.ofStatic("bars").box(0.9, 0.1)).solid(true));
        m.addEntity(new Vec2(5.5f, 18.5f), (SecurityBillboard)((SecurityBillboard)((SecurityBillboard)((SecurityBillboard)new SecurityBillboard().box(0.2, 0.2)).solid(true)).interactable(true)).prompt("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0438\u0433\u043d\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e"));
        m.addEntity(new Vec2(1.5f, 18.5f), ((Billboard)Billboard.ofStatic("table").box(0.3, 0.3)).solid(true));
        m.addEntity(new Vec2(5.1f, 14.5f), Billboard.ofStatic("camera"));
        m.addEntity(new Vec2(12.7f, 12.1f), Billboard.ofStatic("camera"));
        m.addEntity(new Vec2(1.1f, 16.9f), Billboard.ofStatic("camera"));
        m.addEntity(new Vec2(9.8f, 18.9f), Billboard.ofStatic("camera"));
        m.addEntity(new Vec2(9.6f, 10.9f), Billboard.ofStatic("camera"));
        m.addEntity(new Vec2(4.1f, 3.9f), Billboard.ofStatic("camera"));
        m.addEntity(new Vec2(1.1f, 1.1f), Billboard.ofStatic("camera"));
        m.addEntity(new Vec2(14.1f, 1.1f), Billboard.ofStatic("camera"));
        if (!LstatueBillboard.isUp) {
            m.addEntity(new Vec2(1.3f, 7.25f), (LstatueBillboard)((LstatueBillboard)new LstatueBillboard().interactable(true)).prompt("\u041f\u043e\u0434\u043d\u044f\u0442\u044c"));
        }
        m.addEntity(new Vec2(20.0f, 20.0f), new StatueBillboard());
        m.addEntity(new Vec2(2.0f, 7.25f), Billboard.ofStatic("statue"));
        m.addEntity(new Vec2(2.7f, 7.25f), Billboard.ofStatic("statue"));
        m.addEntity(new Vec2(3.2f, 7.25f), Billboard.ofStatic("statue"));
        m.addEntity(new Vec2(11.6f, 10.7f), Billboard.ofStatic("statue"));
        m.addEntity(new Vec2(9.7f, 10.7f), Billboard.ofStatic("statue"));
        m.addEntity(new Vec2(6.7f, 10.7f), Billboard.ofStatic("statue"));
        m.addEntity(new Vec2(4.7f, 2.45f), Billboard.ofStatic("exit"));
        m.addEntity(new Vec2(8.5f, 7.5f), Billboard.ofStatic("bars_br"));
        m.addEntity(new Vec2(8.5f, 4.5f), Billboard.ofStatic("bars_br"));
        m.addEntity(new Vec2(12.5f, 15.5f), bags);
        m.addEntity(new Vec2(11.3f, 14.8f), bags);
        m.addEntity(new Vec2(12.7f, 10.5f), WardrobeFactory.create(0.0f));
        m.addEntity(new Vec2(12.7f, 1.7f), WardrobeFactory.create(0.0f));
        m.addEntity(new Vec2(12.7f, 5.3f), WardrobeFactory.create(0.0f));
        m.addEntity(new Vec2(9.5f, 6.7f), WardrobeFactory.create(90.0f));
        m.addEntity(new Vec2(4.3f, 6.7f), WardrobeFactory.create(-180.0f));
        m.addEntity(new Vec2(2.7f, 1.4f), WardrobeFactory.create(0.0f));
        m.addEntity(new Vec2(11.3f, 12.3f), WardrobeFactory.create(-90.0f));
        m.addEntity(new Vec2(11.6f, 12.3f), WardrobeFactory.create(-90.0f));
        m.addEntity(new Vec2(11.9f, 12.3f), WardrobeFactory.create(-90.0f));
        m.addEntity(new Vec2(12.3f, 12.3f), WardrobeFactory.create(-90.0f));
        m.addEntity(new Vec2(11.6f, 12.3f), WardrobeFactory.create(-90.0f));
        m.addEntity(new Vec2(3.7f, 13.7f), ((WardrobeGBillboard)((WardrobeGBillboard)new WardrobeGBillboard().interactable(true)).prompt("\u0421\u043f\u0440\u044f\u0442\u0430\u0442\u044c\u0441\u044f")).angle((float)Math.toRadians(90.0)));
        m.addEntity(new Vec2(16.5f, 16.5f), new VictimBillboard());
        RaycasterApp.INTERACT.registerWall("wall_door_open", new RaycasterApp.InteractionHub.WallUse(){

            @Override
            public void onUse(RaycasterApp.InteractionHub.UseWallHit hit, RaycasterApp.InteractionHub.UseContext ctx) {
                if (Minecraft.getInstance().getConnection() != null) {
                    Connection connection = Minecraft.getInstance().getConnection().getConnection();
                    connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new GameClosePayload(6)));
                }
                RaycasterApp.closeWindow();
            }

            @Override
            public String prompt(RaycasterApp.InteractionHub.UseWallHit hit) {
                return "...";
            }
        });
        RaycasterApp.INTERACT.registerWall("wall_door", new RaycasterApp.InteractionHub.WallUse(){

            @Override
            public void onUse(RaycasterApp.InteractionHub.UseWallHit hit, RaycasterApp.InteractionHub.UseContext ctx) {
                RaycasterApp.SND.playAt("door", RaycasterApp.getPlayerPos().x, RaycasterApp.getPlayerPos().y, 0.9f);
            }

            @Override
            public String prompt(RaycasterApp.InteractionHub.UseWallHit hit) {
                return "\u041e\u0442\u043a\u0440\u044b\u0442\u044c";
            }
        });
        return m;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static boolean[][] generateMazeGrid(int W, int H, Random rng) {
        boolean[][] pass = new boolean[H][W];
        for (int y = 1; y < H - 1; ++y) {
            Arrays.fill(pass[y], 1, W - 1, false);
        }
        int sx = W % 2 == 1 ? W / 2 | 1 : W / 2 - 1 | 1;
        int sy = H % 2 == 1 ? H / 2 | 1 : H / 2 - 1 | 1;
        pass[sy][sx] = true;
        ArrayDeque<int[]> st = new ArrayDeque<int[]>();
        st.push(new int[]{sx, sy});
        int[] dx2 = new int[]{2, -2, 0, 0};
        int[] dy2 = new int[]{0, 0, 2, -2};
        while (!st.isEmpty()) {
            int[] c = (int[])st.peek();
            int cx = c[0];
            int cy = c[1];
            int[] order = new int[]{0, 1, 2, 3};
            for (int i = 3; i > 0; --i) {
                int j = rng.nextInt(i + 1);
                int t = order[i];
                order[i] = order[j];
                order[j] = t;
            }
            boolean progressed = false;
            for (int k = 0; k < 4; ++k) {
                int dir = order[k];
                int nx = cx + dx2[dir];
                int ny = cy + dy2[dir];
                if (nx <= 1 || nx >= W - 1 || ny <= 1 || ny >= H - 1 || pass[ny][nx]) continue;
                int mx = (cx + nx) / 2;
                int my = (cy + ny) / 2;
                pass[my][mx] = true;
                pass[ny][nx] = true;
                st.push(new int[]{nx, ny});
                progressed = true;
                break;
            }
            if (progressed) continue;
            st.pop();
        }
        int punches = W * H / 45;
        for (int i = 0; i < punches; ++i) {
            int x = 2 + rng.nextInt(Math.max(1, W - 4));
            int y = 2 + rng.nextInt(Math.max(1, H - 4));
            pass[y][x] = true;
        }
        pass[sy][sx] = true;
        return pass;
    }

    private static double sq(double v) {
        return v * v;
    }

    public static FC fc(String floor, String ceil) {
        return new FC(floor, ceil);
    }

    public static Map<Character, FC> fcLegend(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("fcLegend: \u0436\u0434\u0451\u043c \u043f\u0430\u0440\u044b (char, FC)");
        }
        HashMap<Character, FC> m = new HashMap<Character, FC>();
        for (int i = 0; i < pairs.length; i += 2) {
            if (!(pairs[i] instanceof Character) || !(pairs[i + 1] instanceof FC)) {
                throw new IllegalArgumentException("fcLegend: \u043f\u0430\u0440\u0430 #" + i / 2 + " \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c (Character, FC)");
            }
            m.put((Character)pairs[i], (FC)pairs[i + 1]);
        }
        return m;
    }

    public void applyFloorCeilCharMap(int offX, int offY, String[] rows, Map<Character, FC> legend) {
        if (rows == null) {
            return;
        }
        for (int y = 0; y < rows.length; ++y) {
            int gy;
            String row = rows[y];
            if (row == null || (gy = offY + y) < 0 || gy >= this.height) continue;
            int len = row.length();
            for (int x = 0; x < len; ++x) {
                int gx = offX + x;
                if (gx < 0 || gx >= this.width) continue;
                char c = row.charAt(x);
                if (c == '.' || c == ' ') {
                    this.floorIds[gy][gx] = 0;
                    this.ceilIds[gy][gx] = 0;
                    continue;
                }
                FC fc = legend.get(Character.valueOf(c));
                if (fc == null) {
                    this.floorIds[gy][gx] = 0;
                    this.ceilIds[gy][gx] = 0;
                    continue;
                }
                this.floorIds[gy][gx] = fc.floor == null || fc.floor.isEmpty() ? 0 : this.ensureFloorTex(fc.floor);
                this.ceilIds[gy][gx] = fc.ceil == null || fc.ceil.isEmpty() ? 0 : this.ensureCeilTex(fc.ceil);
            }
        }
    }

    public void applyFloorCeilCharMap(String[] rows, Map<Character, FC> legend) {
        this.applyFloorCeilCharMap(0, 0, rows, legend);
    }

    public String floorKeyAt(double wx, double wy) {
        int gx = (int)Math.floor(wx);
        int gy = (int)Math.floor(wy);
        if (gx < 0 || gx >= this.width || gy < 0 || gy >= this.height) {
            return "floor";
        }
        int id = this.floorIds[gy][gx];
        return id == 0 ? "floor" : this.floorKeyById.get(id);
    }

    public String ceilKeyAt(double wx, double wy) {
        int gx = (int)Math.floor(wx);
        int gy = (int)Math.floor(wy);
        if (gx < 0 || gx >= this.width || gy < 0 || gy >= this.height) {
            return "ceil";
        }
        int id = this.ceilIds[gy][gx];
        return id == 0 ? "ceil" : this.ceilKeyById.get(id);
    }

    private int ensureFloorTex(String key) {
        Integer id = this.floorIdByKey.get(key);
        if (id != null) {
            return id;
        }
        int nid = this.floorKeyById.size();
        this.floorKeyById.add(key);
        this.floorIdByKey.put(key, nid);
        return nid;
    }

    private int ensureCeilTex(String key) {
        Integer id = this.ceilIdByKey.get(key);
        if (id != null) {
            return id;
        }
        int nid = this.ceilKeyById.size();
        this.ceilKeyById.add(key);
        this.ceilIdByKey.put(key, nid);
        return nid;
    }

    public boolean inBounds(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public String getWallKeyAt(int x, int y) {
        if (!this.inBounds(x, y)) {
            return null;
        }
        int id = this.grid[y][x];
        return this.wallKeyById(id);
    }

    public void setWallKeyAt(int x, int y, String key) {
        int id;
        if (!this.inBounds(x, y)) {
            return;
        }
        this.grid[y][x] = key == null || key.isEmpty() ? 0 : (id = this.ensureWallTex(key));
    }

    public void toggleDoorAt(int x, int y, String keyClosed) {
        String cur = this.getWallKeyAt(x, y);
        boolean isClosed = keyClosed != null && keyClosed.equals(cur);
        this.setWallKeyAt(x, y, isClosed ? null : keyClosed);
    }

    public static final class FC {
        public final String floor;
        public final String ceil;

        public FC(String floor, String ceil) {
            this.floor = floor;
            this.ceil = ceil;
        }
    }
}

