/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.game.billboards;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import net.knifick.badjoke.game.Billboard;
import net.knifick.badjoke.game.EnemyTag;
import net.knifick.badjoke.game.RaycasterApp;
import net.knifick.badjoke.game.SoundEngine;

public final class VictimBillboard
extends Billboard<VictimBillboard>
implements SoundEngine.SoundListener,
EnemyTag {
    private State state = State.WANDER;
    private final Random rng = new Random();
    private Deque<int[]> path = new ArrayDeque<int[]>();
    private double tgtX;
    private double tgtY;
    private double repathTimer = 0.0;
    private double stuckTimer = 0.0;
    private double lastX;
    private double lastY;
    private double standTimer = 0.0;
    private final double visionDist = 9.0;
    private final double walkSpeed = 0.8;
    private final double runSpeed = 2.5;
    private final double radius = 0.3;
    private final double catchRadius = 1.0;
    private double loseTimer = 0.0;
    private static Clip CHASE_LOOP;
    private static int CHASE_ACTIVE_COUNT;
    private boolean thisInChase = false;
    private Clip chaseLoop;

    private static void startChaseLoopIfNeeded() {
        if (CHASE_LOOP == null) {
            CHASE_LOOP = RaycasterApp.SND.loop("chase", 0.85f, 0.0f);
        }
    }

    private static void stopChaseLoopIfNoChasers() {
        if (CHASE_ACTIVE_COUNT <= 0) {
            CHASE_ACTIVE_COUNT = 0;
            if (CHASE_LOOP != null) {
                try {
                    CHASE_LOOP.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    CHASE_LOOP.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CHASE_LOOP = null;
            }
        }
    }

    private void ensureChaseMusicOn() {
        if (this.chaseLoop == null) {
            this.chaseLoop = RaycasterApp.SND.loop("chase", 0.85f, 0.0f);
        }
    }

    private void stopChaseMusic() {
        if (this.chaseLoop != null) {
            RaycasterApp.SND.stop(this.chaseLoop);
            this.chaseLoop = null;
        }
    }

    private static void setClipLinearGain(Clip c, float linear) {
        if (c == null) {
            return;
        }
        linear = Math.max(1.0E-4f, Math.min(1.0f, linear));
        try {
            FloatControl gc = (FloatControl)c.getControl(FloatControl.Type.MASTER_GAIN);
            float db = (float)(20.0 * Math.log10(linear));
            db = Math.max(gc.getMinimum(), Math.min(gc.getMaximum(), db));
            gc.setValue(db);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public VictimBillboard() {
        super("victim", 1, 0.0);
        ((VictimBillboard)this.solid(true)).box(0.3, 0.3);
        RaycasterApp.SND.addListener(this);
    }

    @Override
    protected Billboard copy() {
        return new VictimBillboard();
    }

    @Override
    public void onSound(String key, double sx, double sy, float perceivedVol) {
        if (RaycasterApp.NAV == null) {
            return;
        }
        this.setInvestigateTarget(sx, sy);
    }

    private void setInvestigateTarget(double sx, double sy) {
        int[] cell = this.nearestFreeCell((int)Math.floor(sx), (int)Math.floor(sy));
        if (cell != null) {
            this.tgtX = (double)cell[0] + 0.5;
            this.tgtY = (double)cell[1] + 0.5;
            this.state = State.INVESTIGATE;
            this.repathTimer = 0.0;
            this.standTimer = 0.0;
        }
    }

    @Override
    public void update(double dt, double px, double py) {
        double dy;
        double dx;
        boolean sees;
        super.update(dt, px, py);
        if (RaycasterApp.NAV == null) {
            return;
        }
        State prevState = this.state;
        boolean bl = sees = this.canSee(px, py, 9.0) && !RaycasterApp.inWardrobe;
        if (sees) {
            this.state = State.CHASE;
            this.tgtX = px;
            this.tgtY = py;
            this.loseTimer = 0.0;
            this.standTimer = 0.0;
        } else if (this.state == State.CHASE) {
            this.loseTimer += dt;
            if (this.loseTimer > 0.8) {
                this.state = State.SEARCH;
                this.tgtX = px;
                this.tgtY = py;
                this.repathTimer = 0.0;
                this.standTimer = 0.0;
            }
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.idleTick(dt);
                break;
            }
            case 1: {
                this.wanderTick(dt);
                break;
            }
            case 2: {
                this.goToTargetTick(dt, 0.8, 2.0, State.WANDER);
                break;
            }
            case 4: {
                this.goToTargetTick(dt, 0.8, 2.5, State.WANDER);
                break;
            }
            case 3: {
                this.tgtX = px;
                this.tgtY = py;
                this.goToTargetTick(dt, 2.5, 0.0, State.SEARCH);
            }
        }
        if (this.state == State.CHASE && !RaycasterApp.inWardrobe && (dx = this.x - px) * dx + (dy = this.y - py) * dy <= 1.0) {
            RaycasterApp.onPlayerCaught(this.x, this.y);
        }
        if (this.state == State.CHASE && !RaycasterApp.inWardrobe) {
            this.ensureChaseMusicOn();
        } else {
            this.stopChaseMusic();
        }
        double moved = Math.hypot(this.x - this.lastX, this.y - this.lastY);
        this.stuckTimer = moved < 0.001 ? (this.stuckTimer += dt) : 0.0;
        this.lastX = this.x;
        this.lastY = this.y;
        if (this.stuckTimer > 0.6) {
            this.path.clear();
            this.repathTimer = 0.0;
            this.stuckTimer = 0.0;
        }
        if (prevState != State.CHASE && this.state == State.CHASE) {
            if (!this.thisInChase) {
                this.thisInChase = true;
                ++CHASE_ACTIVE_COUNT;
                VictimBillboard.startChaseLoopIfNeeded();
                VictimBillboard.setClipLinearGain(CHASE_LOOP, 0.85f);
            }
        } else if (prevState == State.CHASE && this.state != State.CHASE && this.thisInChase) {
            this.thisInChase = false;
            CHASE_ACTIVE_COUNT = Math.max(0, CHASE_ACTIVE_COUNT - 1);
            VictimBillboard.stopChaseLoopIfNoChasers();
        }
        if (this.thisInChase && RaycasterApp.inWardrobe && this.state == State.CHASE) {
            this.state = State.SEARCH;
            this.thisInChase = false;
            CHASE_ACTIVE_COUNT = Math.max(0, CHASE_ACTIVE_COUNT - 1);
            VictimBillboard.stopChaseLoopIfNoChasers();
            double ax = this.x;
            double ay = this.y;
            double vx = this.x - px;
            double vy = this.y - py;
            double len = Math.hypot(vx, vy);
            if (len < 0.001) {
                vx = this.rng.nextDouble() - 0.5;
                vy = this.rng.nextDouble() - 0.5;
                len = Math.hypot(vx, vy);
            }
            double dist = 8.0;
            this.setInvestigateTarget(ax + (vx /= len) * dist, ay + (vy /= len) * dist);
        }
    }

    private void idleTick(double dt) {
        if (this.rng.nextDouble() < dt * 0.3) {
            this.state = State.WANDER;
        }
    }

    private void wanderTick(double dt) {
        if (this.path.isEmpty()) {
            int cx = (int)Math.floor(this.x);
            int cy = (int)Math.floor(this.y);
            int tries = 12;
            while (tries-- > 0) {
                int gy;
                int gx = cx + this.rng.nextInt(15) - 4;
                if (!this.isFree(gx, gy = cy + this.rng.nextInt(15) - 4)) continue;
                this.tgtX = (double)gx + 0.5;
                this.tgtY = (double)gy + 0.5;
                this.buildPathTo(this.tgtX, this.tgtY);
                break;
            }
        }
        this.moveAlongPath(dt, 0.8);
    }

    private void goToTargetTick(double dt, double speed, double standAfter, State afterStand) {
        this.repathTimer -= dt;
        if (VictimBillboard.dist2(this.x, this.y, this.tgtX, this.tgtY) < 0.07840000000000001) {
            this.path.clear();
            if (standAfter > 0.0) {
                this.standTimer += dt;
                if (this.standTimer >= standAfter) {
                    this.standTimer = 0.0;
                    this.state = afterStand;
                }
            } else {
                this.standTimer = 0.0;
            }
            return;
        }
        this.standTimer = 0.0;
        if (this.repathTimer <= 0.0 || this.path.isEmpty()) {
            this.buildPathTo(this.tgtX, this.tgtY);
            this.repathTimer = this.state == State.CHASE ? 0.2 : 0.45;
        }
        this.moveAlongPath(dt, speed);
    }

    private void moveAlongPath(double dt, double speed) {
        double dy;
        double dx;
        double len;
        double wy;
        if (this.path.isEmpty()) {
            return;
        }
        int[] next = this.path.peekFirst();
        double wx = (double)next[0] + 0.5;
        if (VictimBillboard.dist2(this.x, this.y, wx, wy = (double)next[1] + 0.5) < 0.0504) {
            this.path.pollFirst();
            if (this.path.isEmpty()) {
                return;
            }
            next = this.path.peekFirst();
            wx = (double)next[0] + 0.5;
            wy = (double)next[1] + 0.5;
        }
        if ((len = Math.hypot(dx = wx - this.x, dy = wy - this.y)) < 1.0E-6) {
            return;
        }
        double nx = this.x + (dx /= len) * speed * dt;
        double ny = this.y + (dy /= len) * speed * dt;
        double[] r = RaycasterApp.NAV.slide(this.x, this.y, nx, ny, 0.3);
        this.x = r[0];
        this.y = r[1];
    }

    private boolean canSee(double tx, double ty, double maxDist) {
        return RaycasterApp.NAV.los(this.x, this.y, tx, ty, maxDist);
    }

    private boolean isFree(int gx, int gy) {
        return gx >= 0 && gy >= 0 && gx < RaycasterApp.NAV.width() && gy < RaycasterApp.NAV.height() && RaycasterApp.NAV.tile(gx, gy) == 0;
    }

    private void buildPathTo(double gx, double gy) {
        int ty;
        int sx = (int)Math.floor(this.x);
        int sy = (int)Math.floor(this.y);
        int tx = (int)Math.floor(gx);
        if (!this.isFree(tx, ty = (int)Math.floor(gy))) {
            int[] near = this.nearestFreeCell(tx, ty);
            if (near == null) {
                this.path.clear();
                return;
            }
            tx = near[0];
            ty = near[1];
        }
        List<int[]> pth = this.aStar(sx, sy, tx, ty);
        this.path.clear();
        if (pth != null) {
            this.path.addAll(pth);
        }
    }

    private int[] nearestFreeCell(int gx, int gy) {
        if (this.isFree(gx, gy)) {
            return new int[]{gx, gy};
        }
        int maxR = 4;
        for (int r = 1; r <= maxR; ++r) {
            for (int dy = -r; dy <= r; ++dy) {
                int y0 = gy + dy;
                for (int dx = -r; dx <= r; ++dx) {
                    int x0 = gx + dx;
                    if (Math.abs(dx) != r && Math.abs(dy) != r || !this.isFree(x0, y0)) continue;
                    return new int[]{x0, y0};
                }
            }
        }
        return null;
    }

    private static double dist2(double ax, double ay, double bx, double by) {
        double dx = ax - bx;
        double dy = ay - by;
        return dx * dx + dy * dy;
    }

    private List<int[]> aStar(int sx, int sy, int tx, int ty) {
        int W = RaycasterApp.NAV.width();
        int H = RaycasterApp.NAV.height();
        int[][] cameX = new int[H][W];
        int[][] cameY = new int[H][W];
        double[][] g = new double[H][W];
        boolean[][] used = new boolean[H][W];
        for (int y = 0; y < H; ++y) {
            Arrays.fill(g[y], Double.POSITIVE_INFINITY);
            Arrays.fill(cameX[y], -1);
            Arrays.fill(cameY[y], -1);
        }
        PriorityQueue<double[]> pq = new PriorityQueue<double[]>(Comparator.comparingDouble(a -> a[0]));
        g[sy][sx] = 0.0;
        pq.add(new double[]{VictimBillboard.heuristic(sx, sy, tx, ty), sx, sy});
        int[] DX = new int[]{1, -1, 0, 0};
        int[] DY = new int[]{0, 0, 1, -1};
        while (!pq.isEmpty()) {
            int x;
            double[] cur = pq.poll();
            int y = (int)cur[2];
            if (used[y][x = (int)cur[1]]) continue;
            used[y][x] = true;
            if (x == tx && y == ty) {
                ArrayDeque<int[]> rev = new ArrayDeque<int[]>();
                int cx = x;
                int cy = y;
                while (cx != sx || cy != sy) {
                    rev.addFirst(new int[]{cx, cy});
                    int px = cameX[cy][cx];
                    int py = cameY[cy][cx];
                    if (px < 0) break;
                    cx = px;
                    cy = py;
                }
                if (rev.isEmpty()) {
                    rev.add(new int[]{tx, ty});
                }
                return new ArrayList<int[]>(rev);
            }
            for (int dir = 0; dir < 4; ++dir) {
                double ng;
                int nx = x + DX[dir];
                int ny = y + DY[dir];
                if (nx < 0 || ny < 0 || nx >= W || ny >= H || RaycasterApp.NAV.tile(nx, ny) != 0 || !((ng = g[y][x] + 1.0) < g[ny][nx])) continue;
                g[ny][nx] = ng;
                cameX[ny][nx] = x;
                cameY[ny][nx] = y;
                double f = ng + VictimBillboard.heuristic(nx, ny, tx, ty);
                pq.add(new double[]{f, nx, ny});
            }
        }
        return null;
    }

    private static double heuristic(int x, int y, int tx, int ty) {
        int dx = Math.abs(x - tx);
        int dy = Math.abs(y - ty);
        return (double)(dx + dy) + 0.001 * (double)(dx * dx + dy * dy);
    }

    static {
        CHASE_ACTIVE_COUNT = 0;
    }

    private static enum State {
        IDLE,
        WANDER,
        INVESTIGATE,
        CHASE,
        SEARCH;

    }
}

