/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.init;

import net.knifick.badjoke.entity.BallobikCorruptedEntity;
import net.knifick.badjoke.entity.BallobikEntity;
import net.knifick.badjoke.entity.BossEntity;
import net.knifick.badjoke.entity.FakeVillagerEntity;
import net.knifick.badjoke.entity.JokerCorruptedEntity;
import net.knifick.badjoke.entity.JokerEntity;
import net.knifick.badjoke.entity.KukoldJokerEntity;
import net.knifick.badjoke.entity.OriginalJokerEntity;
import net.knifick.badjoke.entity.ScaryJokeCorruptedEntity;
import net.knifick.badjoke.entity.ScaryJokeEntity;
import net.knifick.badjoke.entity.SmegEntity;
import net.knifick.badjoke.entity.SparkEntity;
import net.knifick.badjoke.entity.VictimEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"joke");
    public static final DeferredHolder<EntityType<?>, EntityType<ScaryJokeEntity>> SCARE_JOKE = ModEntities.register("scare_joke", EntityType.Builder.of(ScaryJokeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 5.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<VictimEntity>> VICTIM = ModEntities.register("victim", EntityType.Builder.of(VictimEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 6.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<OriginalJokerEntity>> ORIGINAL_JOKER = ModEntities.register("original_joker", EntityType.Builder.of(OriginalJokerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<BallobikEntity>> BALLOBIK = ModEntities.register("ballobik", EntityType.Builder.of(BallobikEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<BossEntity>> BOSS = ModEntities.register("boss", EntityType.Builder.of(BossEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 5.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<SmegEntity>> SMEG = ModEntities.register("smeg", EntityType.Builder.of(SmegEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<SparkEntity>> SPARK = ModEntities.register("spark", EntityType.Builder.of(SparkEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<JokerEntity>> JOKER = ModEntities.register("joker", EntityType.Builder.of(JokerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<BallobikCorruptedEntity>> BALLOBIK_CORRUPTED = ModEntities.register("ballobik_corrupted", EntityType.Builder.of(BallobikCorruptedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<JokerCorruptedEntity>> JOKER_CORRUPTED = ModEntities.register("joker_corrupted", EntityType.Builder.of(JokerCorruptedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<ScaryJokeCorruptedEntity>> SCARE_JOKE_CORRUPTED = ModEntities.register("scare_joke_corrupted", EntityType.Builder.of(ScaryJokeCorruptedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 5.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<KukoldJokerEntity>> KUKOLD_JOKER = ModEntities.register("kukold_joker", EntityType.Builder.of(KukoldJokerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<FakeVillagerEntity>> FAKE_VILLAGER = ModEntities.register("fake_villager", EntityType.Builder.of(FakeVillagerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.1f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        ScaryJokeEntity.init(event);
        FakeVillagerEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCARE_JOKE.get(), ScaryJokeEntity.createAttributes().build());
        event.put((EntityType)VICTIM.get(), VictimEntity.createAttributes().build());
        event.put((EntityType)ORIGINAL_JOKER.get(), OriginalJokerEntity.createAttributes().build());
        event.put((EntityType)BALLOBIK.get(), BallobikEntity.createAttributes().build());
        event.put((EntityType)BOSS.get(), BossEntity.createAttributes().build());
        event.put((EntityType)SMEG.get(), SmegEntity.createAttributes().build());
        event.put((EntityType)SPARK.get(), SparkEntity.createAttributes().build());
        event.put((EntityType)JOKER.get(), SparkEntity.createAttributes().build());
        event.put((EntityType)BALLOBIK_CORRUPTED.get(), BallobikCorruptedEntity.createAttributes().build());
        event.put((EntityType)JOKER_CORRUPTED.get(), JokerCorruptedEntity.createAttributes().build());
        event.put((EntityType)SCARE_JOKE_CORRUPTED.get(), ScaryJokeCorruptedEntity.createAttributes().build());
        event.put((EntityType)KUKOLD_JOKER.get(), KukoldJokerEntity.createAttributes().build());
        event.put((EntityType)FAKE_VILLAGER.get(), FakeVillagerEntity.createAttributes().build());
    }
}

