/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.mixin;

import net.knifick.badjoke.scare.events.PlayerEvent;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin {
    @Unique
    private static final ResourceLocation JOKE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/entity/original_joker.png");

    @Inject(method={"getSkin"}, at={@At(value="RETURN")}, cancellable=true)
    private void badjoke$swapSkinWhenRaining(CallbackInfoReturnable<PlayerSkin> cir) {
        if (!PlayerEvent.isActive) {
            return;
        }
        PlayerSkin base = (PlayerSkin)cir.getReturnValue();
        if (base == null) {
            return;
        }
        cir.setReturnValue((Object)new PlayerSkin(JOKE_TEXTURE, base.textureUrl(), base.capeTexture(), base.elytraTexture(), PlayerSkin.Model.WIDE, base.secure()));
    }
}

