/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.mixin;

import net.knifick.badjoke.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Unique
    private int bad_joke$shakeOffsetX = 0;
    @Unique
    private int bad_joke$shakeOffsetY = 0;

    private AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void badjoke$preRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.shouldShake()) {
            this.bad_joke$shakeOffsetX = (int)(Math.random() * 5.0 - 2.0);
            this.bad_joke$shakeOffsetY = (int)(Math.random() * 5.0 - 2.0);
            this.leftPos += this.bad_joke$shakeOffsetX;
            this.topPos += this.bad_joke$shakeOffsetY;
        } else {
            this.bad_joke$shakeOffsetX = 0;
            this.bad_joke$shakeOffsetY = 0;
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void badjoke$postRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        this.leftPos -= this.bad_joke$shakeOffsetX;
        this.topPos -= this.bad_joke$shakeOffsetY;
    }

    private boolean shouldShake() {
        Screen current = Minecraft.getInstance().screen;
        if (!(current instanceof AbstractContainerScreen)) {
            return false;
        }
        AbstractContainerScreen screen = (AbstractContainerScreen)current;
        try {
            MenuType type = screen.getMenu().getType();
            if (type != MenuType.GENERIC_9x3 && type != MenuType.GENERIC_9x6) {
                return false;
            }
            if (!screen.getMenu().slots.isEmpty()) {
                ItemStack stack = screen.getMenu().getSlot(0).getItem();
                return stack.getItem() == ModItems.EYES.get();
            }
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return false;
    }
}

