/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.mixin;

import net.knifick.badjoke.scare.MixinTriggerAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.food.FoodData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiSpeedometerMixin
implements MixinTriggerAccess {
    @Unique
    private boolean joke$speedoEnabled = false;
    @Unique
    private int joke$prevFood;
    @Unique
    private float joke$prevSaturation;
    @Unique
    private float joke$prevExhaustion;
    @Unique
    private boolean joke$didSwap = false;

    @Inject(method={"renderFoodLevel(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="HEAD")})
    private void badjoke$preRender(GuiGraphics p_283143_, CallbackInfo ci) {
        if (!this.joke$speedoEnabled) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer p = mc.player;
        if (p == null) {
            return;
        }
        double blocksPerSec = p.getDeltaMovement().horizontalDistance() * 20.0;
        double maxSpeed = 8.0;
        int bar = Mth.clamp((int)((int)Math.round(blocksPerSec / maxSpeed * 20.0)), (int)0, (int)20);
        FoodData food = p.getFoodData();
        this.joke$prevFood = food.getFoodLevel();
        this.joke$prevSaturation = food.getSaturationLevel();
        this.joke$prevExhaustion = food.getExhaustionLevel();
        food.setFoodLevel(bar);
        food.setSaturation(0.0f);
        food.setExhaustion(0.0f);
        this.joke$didSwap = true;
    }

    @Inject(method={"renderFoodLevel(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="TAIL")})
    private void badjoke$postRender(GuiGraphics p_283143_, CallbackInfo ci) {
        if (!this.joke$speedoEnabled || !this.joke$didSwap) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer p = mc.player;
        if (p == null) {
            return;
        }
        FoodData food = p.getFoodData();
        food.setFoodLevel(this.joke$prevFood);
        food.setSaturation(this.joke$prevSaturation);
        food.setExhaustion(this.joke$prevExhaustion);
        this.joke$didSwap = false;
    }

    @Override
    public void joke$action(boolean enable) {
        this.joke$speedoEnabled = enable;
    }
}

