/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.mixin;

import net.knifick.badjoke.client.SmileSeedGate;
import net.knifick.badjoke.client.effects.SmileChunkOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelLoadingScreen.class})
public abstract class LevelLoadingScreenMixin {
    @Shadow
    @Final
    private StoringChunkProgressListener progressListener;
    @Unique
    private boolean badjoke$gateChecked = false;
    @Unique
    private boolean badjoke$enabled = false;

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void badjoke$overlayIfSeed(GuiGraphics gg, int mouseX, int mouseY, float partial, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (!this.badjoke$gateChecked) {
            IntegratedServer srv = mc.getSingleplayerServer();
            if (srv != null) {
                long seed = srv.getWorldData().worldGenOptions().seed();
                this.badjoke$enabled = SmileSeedGate.matches(seed);
                this.badjoke$gateChecked = true;
            } else {
                return;
            }
        }
        if (!this.badjoke$enabled) {
            return;
        }
        int sw = mc.getWindow().getGuiScaledWidth();
        int sh = mc.getWindow().getGuiScaledHeight();
        float t = Mth.clamp((float)((float)this.progressListener.getProgress() / 100.0f), (float)0.0f, (float)1.0f);
        SmileChunkOverlay.draw(gg, this.progressListener, sw / 2, sh / 2, 2, 0, t);
    }
}

