/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.knifick.badjoke.client.ClientSeedChecker;
import net.knifick.badjoke.scare.MixinTriggerAccess;
import net.knifick.badjoke.scare.events.RainEvent;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin
implements MixinTriggerAccess {
    @Unique
    private boolean bad_joke$isActive = false;
    @Final
    @Shadow
    private static ResourceLocation SUN_LOCATION;
    @Final
    @Shadow
    private static ResourceLocation RAIN_LOCATION;
    @Unique
    private static final ResourceLocation JOKE_SUN;
    @Unique
    private static final ResourceLocation WRONG;

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V"))
    private void badjoke$bindJokeSun(int texUnit, ResourceLocation tex) {
        if (!ClientSeedChecker.enabled() && tex.equals((Object)SUN_LOCATION)) {
            RenderSystem.setShaderTexture((int)texUnit, (ResourceLocation)JOKE_SUN);
        } else {
            RenderSystem.setShaderTexture((int)texUnit, (ResourceLocation)tex);
        }
    }

    @Redirect(method={"renderSnowAndRain"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V"))
    private void badjoke$bindRain(int texUnit, ResourceLocation tex) {
        if (RainEvent.isActive && tex.equals((Object)RAIN_LOCATION)) {
            RenderSystem.setShaderTexture((int)texUnit, (ResourceLocation)WRONG);
        } else {
            RenderSystem.setShaderTexture((int)texUnit, (ResourceLocation)tex);
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelSkyRendering(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.level.dimension().location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"empty"))) {
            ci.cancel();
        }
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelSkyRendering(PoseStack poseStack, Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.level.dimension().location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"empty"))) {
            ci.cancel();
        }
    }

    @Unique
    private static boolean joke$isEmptyDim() {
        Minecraft mc = Minecraft.getInstance();
        return mc.level != null && mc.level.dimension().location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"empty"));
    }

    @Redirect(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"))
    private void joke$forceBlackClearColor(Camera camera, float partial, ClientLevel level, int effectiveRenderDistance, float darkenWorldAmount) {
        if (LevelRendererMixin.joke$isEmptyDim()) {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            return;
        }
        FogRenderer.setupColor((Camera)camera, (float)partial, (ClientLevel)level, (int)effectiveRenderDistance, (float)darkenWorldAmount);
    }

    @Redirect(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;levelFogColor()V"))
    private void joke$suppressLevelFogColor() {
        if (!LevelRendererMixin.joke$isEmptyDim()) {
            FogRenderer.levelFogColor();
        }
    }

    @Redirect(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"))
    private void joke$disableFog(Camera camera, FogRenderer.FogMode mode, float distance, boolean foggy, float partialTicks) {
        if (LevelRendererMixin.joke$isEmptyDim()) {
            FogRenderer.setupNoFog();
            return;
        }
        FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)mode, (float)distance, (boolean)foggy, (float)partialTicks);
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    private void joke$reEnableDepthAfterLayer(CallbackInfo ci) {
        RenderSystem.enableDepthTest();
    }

    @ModifyVariable(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"), ordinal=0)
    private Matrix4f injectFrustumMatrix(Matrix4f original) {
        if (this.bad_joke$isActive) {
            Matrix4f modified = new Matrix4f((Matrix4fc)original);
            double time = (double)System.currentTimeMillis() / 1000.0;
            float scaleX = 1.0f + (float)Math.sin(time) * 0.4f;
            float scaleY = 1.0f + (float)Math.sin(time) * 0.5f;
            float scaleZ = 1.0f + (float)Math.sin(time) * 0.3f;
            float angle = (float)(Math.sin(time) * 0.1);
            Matrix4f dancing = new Matrix4f().translation((float)Math.sin(time) * 0.4f, 0.0f, 0.0f).scale(scaleX, scaleY, scaleZ).rotateY(angle);
            modified.mul((Matrix4fc)dancing);
            return modified;
        }
        return original;
    }

    @Override
    public void joke$action(boolean action) {
        this.bad_joke$isActive = action;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", shift=At.Shift.BEFORE)})
    private void disableDepthTest(CallbackInfo ci) {
        if (this.bad_joke$isActive) {
            RenderSystem.disableDepthTest();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    private void reenableDepthTest(CallbackInfo ci) {
        if (!this.bad_joke$isActive) {
            RenderSystem.enableDepthTest();
        }
    }

    static {
        JOKE_SUN = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/environment/sun_joke.png");
        WRONG = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"wrong");
    }
}

