/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.mixin;

import java.util.List;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PauseScreen.class})
public abstract class PauseScreenQuitButtonDodgerMixin
extends Screen {
    @Unique
    private Button badjoke$targetButton;
    @Unique
    private boolean badjoke$scannedOnce;
    @Unique
    private long badjoke$lastTeleportMs = 0L;

    protected PauseScreenQuitButtonDodgerMixin(Component title) {
        super(title);
    }

    @Unique
    private List<Object> badjoke$getRenderables() {
        return (List)ObfuscationReflectionHelper.getPrivateValue(Screen.class, (Object)((Object)this), (String)"renderables");
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void badjoke$grabQuitButton(CallbackInfo ci) {
        if (this.badjoke$scannedOnce) {
            return;
        }
        this.badjoke$scannedOnce = true;
        List<Object> renderables = this.badjoke$getRenderables();
        if (renderables == null) {
            return;
        }
        for (Object r : renderables) {
            AbstractWidget w;
            if (r instanceof Button) {
                Button btn = (Button)r;
                if (!this.badjoke$isQuitLike(btn)) continue;
                this.badjoke$targetButton = btn;
                break;
            }
            if (!(r instanceof AbstractWidget) || !((w = (AbstractWidget)r) instanceof Button)) continue;
            Button btn = (Button)w;
            this.badjoke$isQuitLike(btn);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void badjoke$runAway(GuiGraphics gg, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)mc.level);
        if (vars == null || !vars.begin) {
            return;
        }
        if (this.badjoke$targetButton == null) {
            return;
        }
        int radius = 38;
        int push = 18;
        int maxStep = 28;
        int wallZone = 36;
        int wallPush = 16;
        int safeMargin = 8;
        int cornerTrapDist = 40;
        long tpCooldownMs = 450L;
        int bx = this.badjoke$targetButton.getX();
        int by = this.badjoke$targetButton.getY();
        int bw = this.badjoke$targetButton.getWidth();
        int bh = this.badjoke$targetButton.getHeight();
        float cx = (float)bx + (float)bw / 2.0f;
        float cy = (float)by + (float)bh / 2.0f;
        float dx = cx - (float)mouseX;
        float dy = cy - (float)mouseY;
        float dist = Mth.sqrt((float)(dx * dx + dy * dy));
        float moveX = 0.0f;
        float moveY = 0.0f;
        if (dist < (float)radius + (float)Math.max(bw, bh) / 2.0f) {
            float nx = dist > 0.001f ? dx / dist : 1.0f;
            float ny = dist > 0.001f ? dy / dist : 0.0f;
            float force = Mth.clamp((float)((float)radius - dist + (float)push), (float)push, (float)maxStep);
            moveX += nx * force;
            moveY += ny * force;
        }
        int maxX = this.width - bw - safeMargin;
        int maxY = this.height - bh - safeMargin;
        if (bx <= wallZone) {
            moveX += (float)wallPush;
        }
        if (bx >= maxX - wallZone) {
            moveX -= (float)wallPush;
        }
        if (by <= wallZone) {
            moveY += (float)wallPush;
        }
        if (by >= maxY - wallZone) {
            moveY -= (float)wallPush;
        }
        moveX = Mth.clamp((float)moveX, (float)(-maxStep), (float)maxStep);
        moveY = Mth.clamp((float)moveY, (float)(-maxStep), (float)maxStep);
        int newX = Math.round((float)bx + moveX);
        int newY = Math.round((float)by + moveY);
        newX = Mth.clamp((int)newX, (int)safeMargin, (int)maxX);
        newY = Mth.clamp((int)newY, (int)safeMargin, (int)maxY);
        this.badjoke$targetButton.setX(newX);
        this.badjoke$targetButton.setY(newY);
        boolean nearLeft = newX <= safeMargin + 2;
        boolean nearRight = newX >= maxX - 2;
        boolean nearTop = newY <= safeMargin + 2;
        boolean nearBottom = newY >= maxY - 2;
        boolean cornered = !(!nearLeft && !nearRight || !nearTop && !nearBottom);
        boolean mouseClose = dist < (float)cornerTrapDist;
        long now = System.currentTimeMillis();
        if (cornered && mouseClose && now - this.badjoke$lastTeleportMs > tpCooldownMs) {
            int targetX = mouseX < this.width / 2 ? Mth.clamp((int)(this.width - mouseX), (int)safeMargin, (int)maxX) : Mth.clamp((int)(this.width / 4), (int)safeMargin, (int)maxX);
            int targetY = mouseY < this.height / 2 ? Mth.clamp((int)(this.height - mouseY), (int)safeMargin, (int)maxY) : Mth.clamp((int)(this.height / 4), (int)safeMargin, (int)maxY);
            int jitter = 24;
            int jx = (int)(Math.random() * (double)(jitter * 2 + 1)) - jitter;
            int jy = (int)(Math.random() * (double)(jitter * 2 + 1)) - jitter;
            targetX = Mth.clamp((int)(targetX + jx), (int)safeMargin, (int)maxX);
            targetY = Mth.clamp((int)(targetY + jy), (int)safeMargin, (int)maxY);
            this.badjoke$targetButton.setX(targetX);
            this.badjoke$targetButton.setY(targetY);
            this.badjoke$lastTeleportMs = now;
        }
    }

    @Unique
    private boolean badjoke$isQuitLike(Button btn) {
        MutableComponent mc;
        ComponentContents componentContents;
        Component msg = btn.getMessage();
        if (msg instanceof MutableComponent && (componentContents = (mc = (MutableComponent)msg).getContents()) instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            String key = tc.getKey();
            return "menu.returnToMenu".equals(key) || "menu.disconnect".equals(key);
        }
        String s = msg.getString().toLowerCase();
        return s.contains("\u0432\u044b\u0439\u0442\u0438") || s.contains("\u043c\u0435\u043d\u044e") || s.contains("disconnect") || s.contains("quit");
    }
}

