/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TitleScreen.class})
public abstract class TitleScreenMixin {
    private static final ResourceLocation MENU_BG = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/screens/menu.png");
    private static final ResourceLocation MENU_EYES = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/screens/menu_eyes.png");
    private static final ResourceLocation MENU_HAND = ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"textures/screens/menu_hand.png");
    @Unique
    private static final int BASE_SHIFT_PX = -350;
    @Unique
    private boolean posePushed = false;
    @Unique
    private static final float EYES_BASE_MIN = 0.3f;
    @Unique
    private static final float EYES_BASE_MAX = 0.5f;
    @Unique
    private static final float EYES_PULSE_HZ = 0.1f;
    @Unique
    private static final int FLASH_MIN_DELAY_MS = 12000;
    @Unique
    private static final int FLASH_MAX_DELAY_MS = 32000;
    @Unique
    private static final int FLASH_DURATION_MS = 1200;
    @Unique
    private long nextFlashAtMs = 0L;
    @Unique
    private long flashEndMs = 0L;
    @Unique
    private static final int HAND_TEX_W = 838;
    @Unique
    private static final int HAND_TEX_H = 1021;
    @Unique
    private static final int HAND_PIVOT_X = 660;
    @Unique
    private static final int HAND_PIVOT_Y = 911;
    @Unique
    private static final float HAND_POS_KX = 0.414f;
    @Unique
    private static final float HAND_POS_KY = 0.642f;
    @Unique
    private static final float HAND_FREQ = 0.6f;
    @Unique
    private static final float HAND_DEG = 12.0f;

    @Unique
    private int guiShift() {
        double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
        if (guiScale <= 0.0) {
            guiScale = 1.0;
        }
        return (int)Math.round(-350.0 / guiScale);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void badjoke$shiftButtons(CallbackInfo ci) {
        int height = ((Screen)this).height;
        int shiftGui = this.guiShift();
        TitleScreen screen = (TitleScreen)this;
        for (Renderable r : screen.renderables) {
            AbstractWidget w;
            if (!(r instanceof AbstractWidget) || (w = (AbstractWidget)r).getY() > height - 20) continue;
            w.setX(w.getX() + shiftGui);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    private void badjoke$pushPoseForLogo(GuiGraphics g, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        g.pose().pushPose();
        g.pose().translate((float)this.guiShift(), 0.0f, 0.0f);
        this.posePushed = true;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/internal/BrandingControl;forEachLine(ZZLjava/util/function/BiConsumer;)V", shift=At.Shift.BEFORE)})
    private void badjoke$popBeforeRightBrand(GuiGraphics g, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.posePushed) {
            g.pose().popPose();
            this.posePushed = false;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/TitleScreen;renderPanorama(Lnet/minecraft/client/gui/GuiGraphics;F)V", shift=At.Shift.AFTER)})
    private void badjoke$drawBackgroundAndEyes(GuiGraphics g, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        int width = ((Screen)this).width;
        int height = ((Screen)this).height;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        g.blit(MENU_BG, 0, 0, 0.0f, 0.0f, width, height, width, height);
        long now = Util.getMillis();
        if (this.nextFlashAtMs == 0L) {
            this.nextFlashAtMs = now + (long)ThreadLocalRandom.current().nextInt(12000, 32001);
        }
        if (this.flashEndMs == 0L && now >= this.nextFlashAtMs) {
            this.flashEndMs = now + 1200L;
            this.nextFlashAtMs = now + (long)ThreadLocalRandom.current().nextInt(12000, 32001);
        }
        double t = (double)now / 1000.0;
        float pulse = (float)((Math.sin(0.6283185400806344 * t) + 1.0) * 0.5);
        float baseBrightness = 0.3f + 0.19999999f * pulse;
        float flashWeight = 0.0f;
        if (this.flashEndMs != 0L) {
            long flashStart = this.flashEndMs - 1200L;
            float progress = (float)Math.max(0.0, Math.min(1.0, (double)(now - flashStart) / 1200.0));
            flashWeight = (float)Math.sin((double)progress * Math.PI);
            if (now >= this.flashEndMs) {
                this.flashEndMs = 0L;
            }
        }
        float brightness = baseBrightness + (1.0f - baseBrightness) * flashWeight;
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        g.blit(MENU_EYES, 0, 0, 0.0f, 0.0f, width, height, width, height);
        this.shakeHand(g, mouseX, mouseY, partialTick, ci);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void badjoke$ensurePop(GuiGraphics g, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.posePushed) {
            g.pose().popPose();
            this.posePushed = false;
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void badjoke$onMouseClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (button == 0) {
            Screen screen = (Screen)this;
            double xCoeff = mouseX / (double)screen.width;
            double yCoeff = mouseY / (double)screen.height;
            System.out.printf("[BadJoke] Click at X=%.3f * width, Y=%.3f * height%n", xCoeff, yCoeff);
        }
    }

    @Unique
    private void shakeHand(GuiGraphics g, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        int sw = ((Screen)this).width;
        int sh = ((Screen)this).height;
        float pivotScreenX = 0.414f * (float)sw;
        float pivotScreenY = 0.642f * (float)sh;
        float scale = (float)sh / 1021.0f;
        float t = (float)Util.getMillis() / 1000.0f;
        float angle = (float)Math.sin(t * ((float)Math.PI * 2) * 0.6f) * 12.0f;
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate(pivotScreenX, pivotScreenY, 0.0f);
        pose.mulPose(Axis.ZP.rotationDegrees(angle));
        pose.scale(scale, scale, 1.0f);
        pose.translate(-660.0f, -911.0f, 0.0f);
        g.blit(MENU_HAND, 0, 0, 0.0f, 0.0f, 838, 1021, 838, 1021);
        pose.popPose();
    }
}

