/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.network;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.init.ModItems;
import net.knifick.badjoke.scare.Events;
import net.knifick.badjoke.scare.PhonePhrases;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class BadJokeModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"joke");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());
    public static boolean isTeleport = false;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BadJokeMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        BadJokeMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public float reputation = 0.0f;
        public int phone_timer = 0;
        public int event_timer = 0;
        public int phone_saver = 0;
        public int step_counter = 0;
        public boolean break_event = false;
        public boolean blaze_event = false;
        public PhonePhrases phrase = PhonePhrases.Empty;
        public Set<PhonePhrases> seen = new HashSet<PhonePhrases>();
        public Events cur_event = Events.EmptyEvent;
        public boolean isCalling = false;
        public BlockPos oldPos = BlockPos.ZERO;
        public int max_time = 12000;
        public int max_time_phone = 6000;
        public int personal_cooldown;
        public boolean joke_phone_given;
        public boolean sleep_wait;
        public boolean screen_filter = true;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putFloat("reputation", this.reputation);
            nbt.putInt("phone_timer", this.phone_timer);
            nbt.putInt("event_timer", this.event_timer);
            nbt.putBoolean("break_event", this.break_event);
            nbt.putBoolean("blaze_event", this.blaze_event);
            nbt.putString("phrase", this.phrase.name());
            nbt.putString("cur_event", this.cur_event.name());
            nbt.putBoolean("isCalling", this.isCalling);
            nbt.putInt("phone_saver", this.phone_saver);
            String seenSerialized = this.seen.stream().map(Enum::name).collect(Collectors.joining(","));
            nbt.putString("seen", seenSerialized);
            nbt.putInt("step_counter", this.step_counter);
            nbt.putInt("oldPosX", this.oldPos.getX());
            nbt.putInt("oldPosY", this.oldPos.getY());
            nbt.putInt("oldPosZ", this.oldPos.getZ());
            nbt.putInt("max_time", this.max_time);
            nbt.putInt("max_time_phone", this.max_time_phone);
            nbt.putBoolean("joke_phone_given", this.joke_phone_given);
            nbt.putBoolean("sleep_wait", this.sleep_wait);
            nbt.putBoolean("screen_filter", this.screen_filter);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            String seenSerialized;
            this.reputation = nbt.getFloat("reputation");
            this.phone_timer = nbt.getInt("phone_timer");
            this.event_timer = nbt.getInt("event_timer");
            this.break_event = nbt.getBoolean("break_event");
            this.blaze_event = nbt.getBoolean("blaze_event");
            this.phrase = PhonePhrases.valueOf(nbt.getString("phrase"));
            this.cur_event = Events.valueOf(nbt.getString("cur_event"));
            this.isCalling = nbt.getBoolean("isCalling");
            this.phone_saver = nbt.getInt("phone_saver");
            this.seen.clear();
            if (nbt.contains("seen") && !(seenSerialized = nbt.getString("seen")).isEmpty()) {
                this.seen.addAll(Arrays.stream(seenSerialized.split(",")).map(String::trim).map(PhonePhrases::valueOf).collect(Collectors.toSet()));
            }
            this.step_counter = nbt.getInt("step_counter");
            if (nbt.contains("oldPosX") && nbt.contains("oldPosY") && nbt.contains("oldPosZ")) {
                this.oldPos = new BlockPos(nbt.getInt("oldPosX"), nbt.getInt("oldPosY"), nbt.getInt("oldPosZ"));
            }
            this.max_time = nbt.getInt("max_time");
            this.max_time_phone = nbt.getInt("max_time_phone");
            this.personal_cooldown = nbt.getInt("personal_cooldown");
            this.joke_phone_given = nbt.getBoolean("joke_phone_given");
            this.sleep_wait = nbt.getBoolean("sleep_wait");
            this.screen_filter = nbt.getBoolean("screen_filter");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Reputation defineReputation() {
            if (this.reputation >= 0.0f && this.reputation < 2.0f) {
                return Reputation.NORMAL;
            }
            if (this.reputation >= 2.0f) {
                return Reputation.GOOD;
            }
            return Reputation.BAD;
        }

        public static enum Reputation {
            BAD,
            NORMAL,
            GOOD;

        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "joke_mapvars";
        public boolean begin = false;
        public int death_counter = 0;
        public boolean safe_mode = false;
        public boolean screamer_mode = false;
        public float event_rate = 1.0f;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.begin = nbt.getBoolean("begin");
            this.death_counter = nbt.getInt("death_counter");
            this.safe_mode = nbt.getBoolean("safe_mode");
            this.screamer_mode = nbt.getBoolean("screamer_mode");
            this.event_rate = nbt.getFloat("event_rate");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("begin", this.begin);
            nbt.putInt("death_counter", this.death_counter);
            nbt.putBoolean("safe_mode", this.safe_mode);
            nbt.putBoolean("screamer_mode", this.screamer_mode);
            nbt.putFloat("event_rate", this.event_rate);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "joke_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer oldP = (ServerPlayer)player;
            Player player2 = event.getEntity();
            if (!(player2 instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer newP = (ServerPlayer)player2;
            PlayerVariables oldV = (PlayerVariables)oldP.getData(PLAYER_VARIABLES);
            PlayerVariables newV = (PlayerVariables)newP.getData(PLAYER_VARIABLES);
            newV.reputation = oldV.reputation;
            newV.phone_timer = oldV.phone_timer;
            newV.event_timer = oldV.event_timer;
            newV.break_event = oldV.break_event;
            newV.blaze_event = oldV.blaze_event;
            newV.phrase = oldV.phrase;
            newV.cur_event = oldV.cur_event;
            newV.isCalling = oldV.isCalling;
            newV.phone_saver = oldV.phone_saver;
            newV.step_counter = oldV.step_counter;
            newV.oldPos = oldV.oldPos;
            newV.max_time = oldV.max_time;
            newV.max_time_phone = oldV.max_time_phone;
            newV.personal_cooldown = oldV.personal_cooldown;
            newV.joke_phone_given = oldV.joke_phone_given;
            newV.sleep_wait = oldV.sleep_wait;
            newV.screen_filter = oldV.screen_filter;
            newV.seen = new HashSet<PhonePhrases>(oldV.seen);
            if (event.isWasDeath()) {
                Inventory oldInv = oldP.getInventory();
                Inventory newInv = newP.getInventory();
                for (int i = 0; i < oldInv.getContainerSize(); ++i) {
                    ItemStack stack = oldInv.getItem(i);
                    if (stack.isEmpty() || !stack.is((Item)ModItems.PHONE.get())) continue;
                    newInv.setItem(i, stack.copy());
                }
            }
            newV.syncPlayerVariables((Entity)newP);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                PlayerVariables vars = (PlayerVariables)player2.getData(PLAYER_VARIABLES);
                System.out.println(vars.cur_event.name());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

