/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.network;

import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.client.effects.ClientRenderHandler;
import net.knifick.badjoke.client.screen.ConfigScreen;
import net.knifick.badjoke.client.screen.FakeVillagerOverlay;
import net.knifick.badjoke.entity.FakeVillagerEntity;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.network.payloads.BSODPayload;
import net.knifick.badjoke.network.payloads.CloseWindowPayload;
import net.knifick.badjoke.network.payloads.ConfigScreenPayload;
import net.knifick.badjoke.network.payloads.DialogueBoxClientPayload;
import net.knifick.badjoke.network.payloads.DialogueBoxClosePayload;
import net.knifick.badjoke.network.payloads.DialogueBoxPayload;
import net.knifick.badjoke.network.payloads.EventRatePayload;
import net.knifick.badjoke.network.payloads.EyeWindowPayload;
import net.knifick.badjoke.network.payloads.FakeVillagerPayload;
import net.knifick.badjoke.network.payloads.ForceDistancePayload;
import net.knifick.badjoke.network.payloads.GameClosePayload;
import net.knifick.badjoke.network.payloads.GamePayload;
import net.knifick.badjoke.network.payloads.IpRevealPayload;
import net.knifick.badjoke.network.payloads.ItemRendererSwitchPayload;
import net.knifick.badjoke.network.payloads.LevelRendererSwitchPayload;
import net.knifick.badjoke.network.payloads.MinimizeWindowPayload;
import net.knifick.badjoke.network.payloads.PlayerPayload;
import net.knifick.badjoke.network.payloads.RainPayload;
import net.knifick.badjoke.network.payloads.SafeModePayload;
import net.knifick.badjoke.network.payloads.ScreamerModePayload;
import net.knifick.badjoke.network.payloads.ScreamerPayload;
import net.knifick.badjoke.network.payloads.ScreenFilterPayload;
import net.knifick.badjoke.network.payloads.SleepPayload;
import net.knifick.badjoke.network.payloads.SmegPayload;
import net.knifick.badjoke.network.payloads.SmilePayload;
import net.knifick.badjoke.network.payloads.SpeedometerTogglePayload;
import net.knifick.badjoke.network.payloads.StepPayload;
import net.knifick.badjoke.network.payloads.VillagerGUISenderPayload;
import net.knifick.badjoke.network.payloads.WinToastPayload;
import net.knifick.badjoke.network.payloads.WindowsMessagePayload;
import net.knifick.badjoke.scare.PhonePhrases;
import net.knifick.badjoke.scare.events.BSODEvent;
import net.knifick.badjoke.scare.events.CallEvent;
import net.knifick.badjoke.scare.events.EyeWindowEvent;
import net.knifick.badjoke.scare.events.ForceDistanceReducer;
import net.knifick.badjoke.scare.events.GameEvent;
import net.knifick.badjoke.scare.events.IpRevealEvent;
import net.knifick.badjoke.scare.events.ItemRendererEvent;
import net.knifick.badjoke.scare.events.LevelRendererEvent;
import net.knifick.badjoke.scare.events.MinimizeWindowEvent;
import net.knifick.badjoke.scare.events.PlayerEvent;
import net.knifick.badjoke.scare.events.RainEvent;
import net.knifick.badjoke.scare.events.ScreamerEvent;
import net.knifick.badjoke.scare.events.SleepWaitEvent;
import net.knifick.badjoke.scare.events.SmegSpawnEvent;
import net.knifick.badjoke.scare.events.SmileEvent;
import net.knifick.badjoke.scare.events.SpeedometerEvent;
import net.knifick.badjoke.scare.events.VictimAttackEvent;
import net.knifick.badjoke.scare.events.WinToastEvent;
import net.knifick.badjoke.scare.events.WindowsMessageEvent;
import net.knifick.badjoke.scare.realise.PhrasesTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber
public class PayloadRegister {
    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(ForceDistancePayload.TYPE, ForceDistancePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new ForceDistanceReducer().clientExecution()));
        registrar.playToClient(MinimizeWindowPayload.TYPE, MinimizeWindowPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new MinimizeWindowEvent().clientExecution()));
        registrar.playToClient(ScreamerPayload.TYPE, ScreamerPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new ScreamerEvent().clientExecution()));
        registrar.playToClient(DialogueBoxPayload.TYPE, DialogueBoxPayload.STREAM_CODEC, (payload, context) -> {
            PhonePhrases phrase = payload.phrase();
            context.enqueueWork(() -> new CallEvent().customClientExecution(phrase));
        });
        registrar.playToClient(StepPayload.TYPE, StepPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> ClientRenderHandler.trigger(payload.x(), payload.y(), payload.z(), payload.dx(), payload.dz())));
        registrar.playToServer(DialogueBoxClosePayload.TYPE, DialogueBoxClosePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Player p = context.player();
            if (p instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)p;
                new CallEvent().onServerClose(player, payload.phrase());
            } else {
                BadJokeMod.LOGGER.error("Expected ServerPlayer but got null or wrong type!");
            }
        }));
        registrar.playToServer(DialogueBoxClientPayload.TYPE, DialogueBoxClientPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Player p = context.player();
            if (p instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)p;
                PhrasesTrigger.triggerIfMatch(player, payload.phrase());
            } else {
                BadJokeMod.LOGGER.error("Expected ServerPlayer but got null or wrong type!");
            }
        }));
        registrar.playToClient(CloseWindowPayload.TYPE, CloseWindowPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new VictimAttackEvent().clientExecution()));
        registrar.playToClient(ItemRendererSwitchPayload.TYPE, ItemRendererSwitchPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new ItemRendererEvent().clientExecution(payload.value())));
        registrar.playToClient(LevelRendererSwitchPayload.TYPE, LevelRendererSwitchPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new LevelRendererEvent().clientExecution(payload.value())));
        registrar.playToClient(WindowsMessagePayload.TYPE, WindowsMessagePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new WindowsMessageEvent().clientExecution()));
        registrar.playToClient(SmilePayload.TYPE, SmilePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new SmileEvent().clientExecution()));
        registrar.playToClient(SmegPayload.TYPE, SmegPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new SmegSpawnEvent().clientExecution()));
        registrar.playToClient(GamePayload.TYPE, GamePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new GameEvent().clientExecution()));
        registrar.playToServer(GameClosePayload.TYPE, GameClosePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Player p = context.player();
            BadJokeMod.LOGGER.info("[server] got GameClosePayload({}) from {}", (Object)payload.value(), (Object)p.getGameProfile().getName());
            if (p instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)p;
                BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)sp.level());
                vars.death_counter += payload.value();
                vars.syncData((LevelAccessor)sp.level());
                if (payload.value() == 5) {
                    BadJokeModVariables.PlayerVariables var = (BadJokeModVariables.PlayerVariables)sp.getData(BadJokeModVariables.PLAYER_VARIABLES);
                    var.reputation += 2.0f;
                    var.syncPlayerVariables((Entity)sp);
                }
                BadJokeMod.LOGGER.info("[server] death_counter now {}", (Object)vars.death_counter);
            }
        }));
        registrar.playToClient(SpeedometerTogglePayload.TYPE, SpeedometerTogglePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new SpeedometerEvent().clientExecution(payload.value())));
        registrar.playToClient(WinToastPayload.TYPE, WinToastPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new WinToastEvent().clientExecution()));
        registrar.playToClient(RainPayload.TYPE, RainPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new RainEvent().clientExecution()));
        registrar.playToClient(PlayerPayload.TYPE, PlayerPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new PlayerEvent().clientExecution()));
        registrar.playToClient(ConfigScreenPayload.TYPE, ConfigScreenPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            mc.setScreen((Screen)new ConfigScreen((Component)Component.literal((String)"Config")));
        }));
        registrar.playToServer(SafeModePayload.TYPE, SafeModePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)context.player().level());
            vars.safe_mode = payload.val();
            vars.syncData((LevelAccessor)context.player().level());
        }));
        registrar.playToClient(IpRevealPayload.TYPE, IpRevealPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new IpRevealEvent().clientExecution()));
        registrar.playToClient(SleepPayload.TYPE, SleepPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new SleepWaitEvent().clientExecution()));
        registrar.playToServer(ScreamerModePayload.TYPE, ScreamerModePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)context.player().level());
            vars.screamer_mode = payload.val();
            vars.syncData((LevelAccessor)context.player().level());
        }));
        registrar.playToClient(EyeWindowPayload.TYPE, EyeWindowPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new EyeWindowEvent().clientExecution()));
        registrar.playToServer(EventRatePayload.TYPE, EventRatePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)context.player().level());
            vars.event_rate = payload.val();
            vars.syncData((LevelAccessor)context.player().level());
        }));
        registrar.playToClient(BSODPayload.TYPE, BSODPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> new BSODEvent().clientExecution()));
        registrar.playToServer(FakeVillagerPayload.TYPE, FakeVillagerPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> FakeVillagerEntity.fire((ServerPlayer)context.player())));
        registrar.playToClient(VillagerGUISenderPayload.TYPE, VillagerGUISenderPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            FakeVillagerOverlay.visible = payload.value();
            return FakeVillagerOverlay.visible;
        }));
        registrar.playToServer(ScreenFilterPayload.TYPE, ScreenFilterPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)context.player().getData(BadJokeModVariables.PLAYER_VARIABLES);
            vars.screen_filter = payload.val();
            vars.syncPlayerVariables((Entity)context.player());
        }));
    }
}

