/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare;

import java.util.ArrayList;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.init.ModItems;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.scare.Events;
import net.knifick.badjoke.scare.PhonePhrases;
import net.knifick.badjoke.scare.events.CallEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class EventSystem {
    private static final int BASE_AVG_EVENT_TICKS = 9000;
    private static final int BASE_RNG_EVENT_TICKS = 2500;
    private static final int BASE_AVG_CALL_TICKS = 6000;
    private static final int BASE_RNG_CALL_TICKS = 3600;
    private static final int MIN_EVENT_TICKS = 1200;
    private static final int MIN_CALL_TICKS = 1200;
    private static final int COOLDOWN_AFTER_EVENT = 600;
    private static final int COOLDOWN_AFTER_CALL = 1800;
    private static final int PHRASE_TIMEOUT = 1200;
    public static final boolean DEBUG = false;

    @SubscribeEvent
    public static void perTickTimer(EntityTickEvent.Post e) {
        Entity ent = e.getEntity();
        if (ent.level().isClientSide || !(ent instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)ent;
        if (!BadJokeModVariables.MapVariables.get((LevelAccessor)player.level()).begin) {
            return;
        }
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        if (vars.max_time <= 0) {
            vars.max_time = EventSystem.reseedEventInterval(player.getRandom());
        }
        if (vars.max_time_phone <= 0) {
            vars.max_time_phone = EventSystem.reseedCallInterval(player.getRandom());
        }
        ++vars.event_timer;
        if (CallEvent.findPhoneInInventory((Player)player).is((Item)ModItems.PHONE.get())) {
            ++vars.phone_timer;
        }
        if (vars.personal_cooldown > 0) {
            --vars.personal_cooldown;
        }
        if (vars.phrase != PhonePhrases.Empty) {
            ++vars.phone_saver;
            if (vars.phone_saver > 1200) {
                vars.phrase = PhonePhrases.Empty;
                vars.phone_saver = 0;
                vars.syncPlayerVariables((Entity)player);
            }
        } else if (vars.phone_saver != 0) {
            vars.phone_saver = 0;
            vars.syncPlayerVariables((Entity)player);
        }
    }

    @SubscribeEvent
    public static void perTick(EntityTickEvent.Post e) {
        Entity ent = e.getEntity();
        if (ent.level().isClientSide || !(ent instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)ent;
        BadJokeModVariables.MapVariables world_vars = BadJokeModVariables.MapVariables.get((LevelAccessor)player.level());
        if (!world_vars.begin) {
            return;
        }
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        double eventRate = Math.max(0.0, (double)world_vars.event_rate);
        if (eventRate <= 0.0) {
            return;
        }
        if (EventSystem.isBusy(player)) {
            return;
        }
        long gameTime = player.serverLevel().getGameTime();
        double days = (double)gameTime / 12500.0;
        double scale = 1.0 + 0.25 * Math.sqrt(Math.max(0.0, days));
        int dayBucket = (int)Math.floor(days / 5.0);
        double dayBoost = Math.pow(2.0, days / 2.0);
        double eventTarget = Math.max(1200.0, (double)vars.max_time / scale / (eventRate * dayBoost));
        int callTarget = (int)Math.round((double)EventSystem.applyCallModifiers(vars.max_time_phone, player) / eventRate);
        if ((double)vars.event_timer >= eventTarget) {
            vars.max_time = EventSystem.reseedEventInterval(player.getRandom());
            EventSystem.randEvent(player);
            vars.event_timer = 0;
            EventSystem.setCooldown(player, 600);
            vars.syncPlayerVariables((Entity)player);
            return;
        }
        if (vars.phone_timer >= callTarget) {
            EventSystem.runEvent(Events.CallEvent, player, PhonePhrases.Empty);
            vars.max_time_phone = EventSystem.reseedCallInterval(player.getRandom());
            vars.phone_timer = 0;
            EventSystem.setCooldown(player, 1800);
            vars.syncPlayerVariables((Entity)player);
        }
    }

    private static int reseedEventInterval(RandomSource r) {
        int v = 9000 + r.nextInt(-2500, 2501);
        return Math.max(1200, v);
    }

    private static int reseedCallInterval(RandomSource r) {
        int v = 6000 + r.nextInt(-3600, 3601);
        return Math.max(1200, v);
    }

    private static int applyCallModifiers(int base, ServerPlayer p) {
        double m = 1.0;
        if (p.blockPosition().getY() < p.level().getSeaLevel() - 8) {
            m *= 1.25;
        }
        if (p.isUnderWater() || p.isOnFire() || p.fallDistance > 3.0f) {
            m *= 1.5;
        }
        if (p.hurtTime > 0) {
            m *= 1.25;
        }
        if (!p.level().isDay()) {
            m *= 0.9;
        }
        int v = (int)Math.round((double)base * m);
        return Math.max(1200, v);
    }

    private static boolean isBusy(ServerPlayer p) {
        BadJokeModVariables.PlayerVariables pv = (BadJokeModVariables.PlayerVariables)p.getData(BadJokeModVariables.PLAYER_VARIABLES);
        return pv.personal_cooldown > 0;
    }

    private static double getGameDays(ServerPlayer p) {
        long gameTime = p.serverLevel().getGameTime();
        return (double)gameTime / 12500.0;
    }

    private static void setCooldown(ServerPlayer p, int ticks) {
        BadJokeModVariables.PlayerVariables pv = (BadJokeModVariables.PlayerVariables)p.getData(BadJokeModVariables.PLAYER_VARIABLES);
        pv.personal_cooldown = Math.max(pv.personal_cooldown, ticks);
    }

    public static void randEvent(ServerPlayer player) {
        ItemStack chest;
        RandomSource rand = player.getRandom();
        double days = (double)player.serverLevel().getGameTime() / 12500.0;
        BadJokeModVariables.PlayerVariables.Reputation rep = ((BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES)).defineReputation();
        ArrayList<Events> pool = new ArrayList<Events>();
        for (Events ev : Events.values()) {
            float chance;
            if (ev == Events.EmptyEvent || (chance = ev.getChance()) <= 0.0f || !ev.matchesReputation(rep) || days < (double)ev.getMinDay()) continue;
            pool.add(ev);
        }
        if (pool.isEmpty()) {
            BadJokeMod.LOGGER.warn("No event candidates (weighted). days={}, rep={}", (Object)days, (Object)rep);
            return;
        }
        float totalWeight = 0.0f;
        for (Events ev : pool) {
            totalWeight += Math.max(0.0f, ev.getChance());
        }
        if (totalWeight <= 0.0f) {
            BadJokeMod.LOGGER.warn("Total weight is zero; no events can be selected. days={}, rep={}", (Object)days, (Object)rep);
            return;
        }
        float roll = rand.nextFloat() * totalWeight;
        float accum = 0.0f;
        Events picked = (Events)((Object)pool.get(pool.size() - 1));
        for (Events ev : pool) {
            if (!(roll <= (accum += ev.getChance()))) continue;
            picked = ev;
            break;
        }
        if (!(chest = player.getItemBySlot(EquipmentSlot.CHEST)).is((Item)ModItems.AMULET.get())) {
            EventSystem.runEvent(picked, player);
        } else {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.AMULET_JOKE, SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    public static void runEvent(Events event, ServerPlayer player) {
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!chest.is((Item)ModItems.AMULET.get())) {
            event.run(player);
        } else {
            chest.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.CHEST);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.AMULET_JOKE, SoundSource.MASTER, 1.0f, 1.0f);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SHIELD_BLOCK, SoundSource.MASTER, 1.0f, 1.0f);
        }
        for (Events ev : Events.values()) {
            if (ev == Events.EmptyEvent) continue;
            if (ev == event) {
                ev.resetChance();
                continue;
            }
            ev.increaseChance(0.025f);
        }
        BadJokeMod.LOGGER.info("Event: {}", (Object)event);
    }

    public static void runEvent(Events event, ServerPlayer player, PhonePhrases phrases) {
        event.run(player, phrases);
        BadJokeMod.LOGGER.info("Event: {}, Phrase: {}", (Object)event, (Object)phrases);
    }
}

