/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare;

import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.scare.Event;
import net.knifick.badjoke.scare.PhonePhrases;
import net.knifick.badjoke.scare.events.AdvancementEvent;
import net.knifick.badjoke.scare.events.ArmorBreakEvent;
import net.knifick.badjoke.scare.events.BSODEvent;
import net.knifick.badjoke.scare.events.BallobikSpawnEvent;
import net.knifick.badjoke.scare.events.BlazeEvent;
import net.knifick.badjoke.scare.events.CallEvent;
import net.knifick.badjoke.scare.events.CheerEvent;
import net.knifick.badjoke.scare.events.ChestSpawnerEvent;
import net.knifick.badjoke.scare.events.EpilepticSpawnEvent;
import net.knifick.badjoke.scare.events.EyeWindowEvent;
import net.knifick.badjoke.scare.events.ForceDistanceReducer;
import net.knifick.badjoke.scare.events.GameEvent;
import net.knifick.badjoke.scare.events.GlitchCallEvent;
import net.knifick.badjoke.scare.events.IpRevealEvent;
import net.knifick.badjoke.scare.events.ItemRendererEvent;
import net.knifick.badjoke.scare.events.JokeSpawnerEvent;
import net.knifick.badjoke.scare.events.KukoldSpawnerEvent;
import net.knifick.badjoke.scare.events.LevelRendererEvent;
import net.knifick.badjoke.scare.events.LightingBoltEvent;
import net.knifick.badjoke.scare.events.MinimizeWindowEvent;
import net.knifick.badjoke.scare.events.PlayerEvent;
import net.knifick.badjoke.scare.events.RainEvent;
import net.knifick.badjoke.scare.events.ScreamerEvent;
import net.knifick.badjoke.scare.events.SignSpawnerEvent;
import net.knifick.badjoke.scare.events.SleepWaitEvent;
import net.knifick.badjoke.scare.events.SmegSpawnEvent;
import net.knifick.badjoke.scare.events.SmileEvent;
import net.knifick.badjoke.scare.events.SpeedometerEvent;
import net.knifick.badjoke.scare.events.StructureEvent;
import net.knifick.badjoke.scare.events.TorchOffEvent;
import net.knifick.badjoke.scare.events.TreeStoneifyEvent;
import net.knifick.badjoke.scare.events.VictimAttackEvent;
import net.knifick.badjoke.scare.events.VictimSpawnEvent;
import net.knifick.badjoke.scare.events.WinToastEvent;
import net.knifick.badjoke.scare.events.WindowsMessageEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public enum Events {
    ForceDistanceReducer(new ForceDistanceReducer(), 0.5f, 0, 0),
    LightingBoltEvent(new LightingBoltEvent(), 0.5f, -1, 0),
    MinimizeWindowEvent(new MinimizeWindowEvent(), 0.1f, 0, 1),
    ArmorBreakEvent(new ArmorBreakEvent(), 0.3f, 0, 0),
    ScreamerEvent(new ScreamerEvent(), 0.1f, -1, 2),
    CallEvent(new CallEvent(), 0.5f, 0, 0),
    VictimAttackEvent(new VictimAttackEvent(), 0.0f, 0, 0),
    VictimSpawnEvent(new VictimSpawnEvent(), 0.05f, -1, 5),
    EpilepticSpawn(new EpilepticSpawnEvent(), 0.15f, 0, 3),
    SignSpawner(new SignSpawnerEvent(), 0.1f, 0, 2),
    BallobikSpawn(new BallobikSpawnEvent(), 0.1f, 0, 2),
    ChestSpawn(new ChestSpawnerEvent(), 0.1f, 0, 1),
    ItemRenderer(new ItemRendererEvent(), 0.1f, -1, 4),
    LevelRenderer(new LevelRendererEvent(), 0.1f, -1, 4),
    SmileEvent(new SmileEvent(), 0.5f, -1, 10),
    WindowsMessage(new WindowsMessageEvent(), 0.03f, -1, 5),
    SmegSpawn(new SmegSpawnEvent(), 0.0f, -1, 0),
    GameEvent(new GameEvent(), 0.0f, 0, 0),
    Speedometer(new SpeedometerEvent(), 0.5f, 0, 0),
    Treestone(new TreeStoneifyEvent(), 0.5f, -1, 4),
    Blaze(new BlazeEvent(), 0.75f, -1, 0),
    WinToast(new WinToastEvent(), 0.5f, 0, 4),
    Advancement(new AdvancementEvent(), 0.3f, -1, 1),
    Rain(new RainEvent(), 0.15f, -1, 3),
    PlayerEvent(new PlayerEvent(), 0.5f, 1, 2),
    IpReveal(new IpRevealEvent(), 0.01f, -1, 7),
    SleepEvent(new SleepWaitEvent(), 0.5f, -1, 5),
    JokerSpawnEvent(new JokeSpawnerEvent(), 0.1f, 0, 5),
    CheerEvent(new CheerEvent(), 0.5f, 1, 0),
    EyeEvent(new EyeWindowEvent(), 0.2f, 0, 5),
    StructureEvent(new StructureEvent(), 0.2f, 0, 2),
    BSODEvent(new BSODEvent(), 0.25f, -1, 2),
    KukoldSpawn(new KukoldSpawnerEvent(), 0.5f, 0, 2),
    TorchOffEvent(new TorchOffEvent(), 0.025f, -1, 4),
    GlitchCallEvent(new GlitchCallEvent(), 0.05f, -1, 5),
    EmptyEvent{

        @Override
        public void run(ServerPlayer player) {
        }
    };

    private Event event;
    private float chance;
    private float defaultChance;
    private int type = 0;
    private int minDay = 0;

    private Events() {
    }

    private Events(Event event, float chance) {
        this.event = event;
        this.chance = chance;
        this.defaultChance = chance;
    }

    private Events(Event event, float chance, int type) {
        this.event = event;
        this.chance = chance;
        this.defaultChance = chance;
        this.type = type;
    }

    private Events(Event event, float chance, int type, int minDay) {
        this.event = event;
        this.chance = chance;
        this.defaultChance = chance;
        this.type = type;
        this.minDay = Math.max(0, minDay);
    }

    public float getChance() {
        return this.chance;
    }

    public int getType() {
        return this.type;
    }

    public int getMinDay() {
        return this.minDay;
    }

    public void run(ServerPlayer player) {
        if (this.event != null) {
            this.event.fire(player);
        }
    }

    public void run(ServerPlayer player, PhonePhrases phrases) {
        if (this.event != null) {
            this.event.fire(player, phrases);
        }
    }

    public boolean matchesReputation(BadJokeModVariables.PlayerVariables.Reputation rep) {
        return switch (rep) {
            default -> throw new MatchException(null, null);
            case BadJokeModVariables.PlayerVariables.Reputation.BAD -> {
                if (this.type <= 0) {
                    yield true;
                }
                yield false;
            }
            case BadJokeModVariables.PlayerVariables.Reputation.NORMAL -> true;
            case BadJokeModVariables.PlayerVariables.Reputation.GOOD -> this.type >= 0;
        };
    }

    public static void addReputation(ServerPlayer player, float delta) {
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        vars.reputation += delta;
        vars.syncPlayerVariables((Entity)player);
    }

    public void resetChance() {
        this.chance = this.defaultChance;
    }

    public void increaseChance(float delta) {
        if (this.defaultChance <= 0.0f) {
            return;
        }
        this.chance = Math.min(1.0f, this.chance + delta);
    }
}

