/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.knifick.badjoke.init.ModItems;
import net.knifick.badjoke.item.BombItem;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public final class BlazeEvent
implements Event {
    private static final String NBT_BOMB_END = "bomb_end_tick";
    private static final int DEFAULT_DURATION_TICKS = 40;
    private static final float EXPLOSION_POWER = 7.0f;
    private static final boolean EXPLOSION_BREAKS_BLOCKS = true;
    private static final Map<UUID, Long> ACTIVE_DROPPED = new ConcurrentHashMap<UUID, Long>();

    @SubscribeEvent
    public static void onItemPickupPre(ItemEntityPickupEvent.Pre evt) {
        Player player = evt.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)sp.getData(BadJokeModVariables.PLAYER_VARIABLES);
        if (!vars.blaze_event) {
            return;
        }
        ItemEntity itemEntity = evt.getItemEntity();
        ItemStack stack = itemEntity.getItem();
        if (!stack.is(Items.BLAZE_ROD)) {
            return;
        }
        vars.blaze_event = false;
        vars.syncPlayerVariables((Entity)sp);
        int count = stack.getCount();
        evt.setCanPickup(TriState.FALSE);
        itemEntity.discard();
        BlazeEvent.giveBombStack(sp, count, 40);
    }

    @SubscribeEvent
    public static void onToss(ItemTossEvent evt) {
        Player player = evt.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ItemEntity ie = evt.getEntity();
        ItemStack stack = ie.getItem();
        if (!(stack.getItem() instanceof BombItem)) {
            return;
        }
        long end = BlazeEvent.getEndTick(stack);
        if (end <= 0L) {
            end = sp.serverLevel().getGameTime() + 40L;
            BlazeEvent.putEndTick(stack, end);
            ie.setItem(stack);
        }
        ACTIVE_DROPPED.put(ie.getUUID(), end);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ServerLevel level = sp.serverLevel();
        long now = level.getGameTime();
        Inventory inv = sp.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            long end;
            ItemStack st = inv.getItem(i);
            if (!(st.getItem() instanceof BombItem) || (end = BlazeEvent.getEndTick(st)) <= 0L || now < end) continue;
            BlazeEvent.explode(level, sp.getX(), sp.getY() + 0.5, sp.getZ());
            st.shrink(1);
            if (st.isEmpty()) {
                inv.setItem(i, ItemStack.EMPTY);
                break;
            }
            long next = now + 40L;
            BlazeEvent.putEndTick(st, next);
            inv.setItem(i, st);
            break;
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post evt) {
        Level level = evt.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        long now = level2.getGameTime();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Long> e : ACTIVE_DROPPED.entrySet()) {
            UUID id = e.getKey();
            long end = e.getValue();
            if (now < end) continue;
            Entity ent = level2.getEntity(id);
            if (ent instanceof ItemEntity) {
                ItemEntity ie = (ItemEntity)ent;
                ItemStack st = ie.getItem();
                if (st.getItem() instanceof BombItem) {
                    BlazeEvent.explode(level2, ie.getX(), ie.getY(), ie.getZ());
                }
                ie.discard();
            }
            toRemove.add(id);
        }
        toRemove.forEach(ACTIVE_DROPPED::remove);
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload evt) {
        if (evt.getLevel() instanceof ServerLevel) {
            ACTIVE_DROPPED.clear();
        }
    }

    public static void startFor(ServerPlayer player, int durationTicks) {
        BlazeEvent.giveBombStack(player, 1, durationTicks);
    }

    private static void giveBombStack(ServerPlayer sp, int count, int durationTicks) {
        ServerLevel level = sp.serverLevel();
        long end = level.getGameTime() + (long)Math.max(1, durationTicks);
        ItemStack bomb = new ItemStack((ItemLike)ModItems.BOMB.get(), Math.max(1, count));
        BlazeEvent.putEndTick(bomb, end);
        boolean added = sp.addItem(bomb);
        if (!added) {
            ItemEntity ie = new ItemEntity((Level)level, sp.getX(), sp.getY() + 0.5, sp.getZ(), bomb);
            level.addFreshEntity((Entity)ie);
            ACTIVE_DROPPED.put(ie.getUUID(), end);
        }
    }

    private static void putEndTick(ItemStack stack, long endTick) {
        CustomData existing = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = existing.copyTag();
        tag.putLong(NBT_BOMB_END, endTick);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    private static long getEndTick(ItemStack stack) {
        CustomData existing = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = existing.copyTag();
        return tag.contains(NBT_BOMB_END) ? tag.getLong(NBT_BOMB_END) : -1L;
    }

    private static void explode(ServerLevel level, double x, double y, double z) {
        level.explode(null, x, y, z, 7.0f, Level.ExplosionInteraction.TNT);
    }

    @Override
    public void fire(ServerPlayer player) {
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        vars.blaze_event = true;
        vars.syncPlayerVariables((Entity)player);
    }
}

