/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.util.Random;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ChestSpawnerEvent
implements Event {
    private static final Random random = new Random();

    @Override
    public void fire(ServerPlayer player) {
        ChestSpawnerEvent.tryPlaceSignNearPlayer(player);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.HOSTILE, 9.375f, 1.0f);
    }

    public static void tryPlaceSignNearPlayer(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        if (level.isClientSide()) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        boolean isUnderground = ChestSpawnerEvent.isUnderground((Level)level, playerPos);
        int radius = isUnderground ? 2 : 3;
        int attempts = 50;
        for (int i = 0; i < attempts; ++i) {
            int dx = random.nextInt(radius * 2 + 1) - radius;
            int dz = random.nextInt(radius * 2 + 1) - radius;
            int dy = random.nextInt(5) - 2;
            BlockPos basePos = playerPos.offset(dx, dy - 1, dz);
            BlockPos signPos = basePos.above();
            BlockState baseState = level.getBlockState(basePos);
            BlockState aboveState = level.getBlockState(signPos);
            if (!baseState.isFaceSturdy((BlockGetter)level, basePos, Direction.UP) || !aboveState.isAir()) continue;
            StructureTemplate template = level.getStructureManager().getOrCreate(ChestSpawnerEvent.defineChest(player));
            template.placeInWorld((ServerLevelAccessor)level, signPos, signPos, new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).setIgnoreEntities(false), level.random, 3);
            return;
        }
    }

    private static boolean isUnderground(Level level, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos above = pos.above(i);
            if (!level.getBlockState(above).isAir()) continue;
            return false;
        }
        return true;
    }

    private static ResourceLocation defineChest(ServerPlayer player) {
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        return switch (vars.defineReputation()) {
            default -> throw new MatchException(null, null);
            case BadJokeModVariables.PlayerVariables.Reputation.NORMAL -> ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"normal_chest");
            case BadJokeModVariables.PlayerVariables.Reputation.GOOD -> ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"good_chest");
            case BadJokeModVariables.PlayerVariables.Reputation.BAD -> ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"bad_chest");
        };
    }
}

