/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import net.knifick.badjoke.entity.ScaryJokeCorruptedEntity;
import net.knifick.badjoke.entity.ScaryJokeEntity;
import net.knifick.badjoke.init.ModEntities;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class EpilepticSpawnEvent
implements Event {
    @Override
    public void fire(ServerPlayer player) {
        Entity mob;
        ServerLevel level = (ServerLevel)player.level();
        RandomSource random = level.getRandom();
        double distance = Mth.nextDouble((RandomSource)random, (double)32.0, (double)48.0);
        double angle = Mth.nextDouble((RandomSource)random, (double)0.0, (double)(Math.PI * 2));
        int offsetX = Mth.floor((double)(distance * Math.cos(angle)));
        int offsetZ = Mth.floor((double)(distance * Math.sin(angle)));
        BlockPos.MutableBlockPos spawnPos = new BlockPos.MutableBlockPos(player.getX() + (double)offsetX, 0.0, player.getZ() + (double)offsetZ);
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnPos.getX(), spawnPos.getZ());
        spawnPos.setY(y);
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        if (vars.defineReputation() == BadJokeModVariables.PlayerVariables.Reputation.BAD && new ScaryJokeCorruptedEntity((EntityType<ScaryJokeCorruptedEntity>)((EntityType)ModEntities.SCARE_JOKE_CORRUPTED.get()), (Level)level).checkSpawnRules((LevelAccessor)level, MobSpawnType.NATURAL)) {
            Entity mob2 = ((EntityType)ModEntities.SCARE_JOKE_CORRUPTED.get()).create((Level)level);
            if (mob2 != null) {
                mob2.moveTo((double)spawnPos.getX() + 0.5, (double)y, (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                level.addFreshEntity(mob2);
            }
            return;
        }
        if (new ScaryJokeEntity((EntityType<ScaryJokeEntity>)((EntityType)ModEntities.SCARE_JOKE.get()), (Level)level).checkSpawnRules((LevelAccessor)level, MobSpawnType.NATURAL) && (mob = ((EntityType)ModEntities.SCARE_JOKE.get()).create((Level)level)) != null) {
            mob.moveTo((double)spawnPos.getX() + 0.5, (double)y, (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            level.addFreshEntity(mob);
        }
    }
}

